/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.portal.wireless.taglibs.mail.FolderBean;
import com.sun.portal.wireless.taglibs.mail.MsgBean;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;

class MailUtils {
    private static int direction = 1;

    MailUtils() {
    }

    public static void setSortDirection(String sd) {
        direction = 1;
        if (sd != null && sd.equals("down")) {
            direction = -1;
        }
    }

    public static MsgBean[] toBeanArray(Message[] msgs, String from, TimeZone tz) {
        MsgBean[] tmp = new MsgBean[msgs.length];
        int i = 0;
        while (i < msgs.length) {
            tmp[i] = new MsgBean(msgs[i], from, tz);
            ++i;
        }
        return tmp;
    }

    public static FolderBean[] toFolderBeanArray(Folder[] folders) {
        FolderBean[] tmp = new FolderBean[folders.length];
        int i = 0;
        while (i < folders.length) {
            tmp[i] = new FolderBean(folders[i]);
            ++i;
        }
        return tmp;
    }

    public static Object[] inboxOrder(Object[] in) {
        if (direction < 0) {
            int len = in.length - 1;
            int hlen = in.length / 2;
            int i = 0;
            while (i < hlen) {
                Object tmp = in[i];
                in[i] = in[len - i];
                in[len - i] = tmp;
                ++i;
            }
        }
        return in;
    }

    public static void prefetch(MsgBean[] msgs, String field) {
        FetchProfile fp = new FetchProfile();
        fp.add(field);
        MailUtils.prefetch(msgs, fp);
    }

    public static void prefetch(MsgBean[] msgs, FetchProfile fp) {
        try {
            Message[] m = new Message[msgs.length];
            int i = 0;
            while (i < msgs.length) {
                m[i] = msgs[i].getObject();
                ++i;
            }
            m[0].getFolder().fetch(m, fp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class MsgRecentComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            boolean s2;
            boolean s1;
            MsgBean b1 = (MsgBean)a;
            MsgBean b2 = (MsgBean)b;
            int i = b1.getMsgid();
            int j = b2.getMsgid();
            try {
                s1 = b1.isRecent();
            }
            catch (Exception e) {
                s1 = false;
            }
            try {
                s2 = b2.isRecent();
            }
            catch (Exception e) {
                s2 = false;
            }
            if (s1 == s2) {
                return direction * (i - j);
            }
            if (s1) {
                return direction;
            }
            return -direction;
        }
    }

    public static class MsgSeenComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            boolean s2;
            boolean s1;
            MsgBean b1 = (MsgBean)a;
            MsgBean b2 = (MsgBean)b;
            int i = b1.getMsgid();
            int j = b2.getMsgid();
            try {
                s1 = b1.isSeen();
            }
            catch (Exception e) {
                s1 = false;
            }
            try {
                s2 = b2.isSeen();
            }
            catch (Exception e) {
                s2 = false;
            }
            if (s1 == s2) {
                return direction * (i - j);
            }
            if (s1) {
                return direction;
            }
            return -direction;
        }
    }

    public static class MsgIdComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            MsgBean b1 = (MsgBean)a;
            MsgBean b2 = (MsgBean)b;
            int i = b1.getMsgid();
            int j = b2.getMsgid();
            return direction * (i - j);
        }
    }

    public static class MsgDateComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            Date d2;
            Date d1;
            MsgBean b1 = (MsgBean)a;
            MsgBean b2 = (MsgBean)b;
            Message m1 = b1.getObject();
            Message m2 = b2.getObject();
            try {
                d1 = m1.getReceivedDate();
            }
            catch (MessagingException ex) {
                return direction * 1;
            }
            try {
                d2 = m2.getReceivedDate();
            }
            catch (MessagingException ex) {
                return direction * -1;
            }
            return direction * d1.compareTo(d2);
        }
    }

    public static class MsgSubjectComparator
    implements Comparator {
        Collator collate = null;

        public MsgSubjectComparator(Collator c) {
            this.collate = c;
        }

        public int compare(Object a, Object b) {
            MsgBean b1 = (MsgBean)a;
            MsgBean b2 = (MsgBean)b;
            String tmp1 = "";
            String tmp2 = "";
            try {
                tmp1 = b1.getSubject();
            }
            catch (MessagingException ex) {
                // empty catch block
            }
            try {
                tmp2 = b2.getSubject();
            }
            catch (MessagingException ex) {
                // empty catch block
            }
            return direction * this.collate.compare(tmp1, tmp2);
        }
    }

    public static class MsgFromComparator
    implements Comparator {
        Collator collate = null;

        public MsgFromComparator(Collator c) {
            this.collate = c;
        }

        public int compare(Object a, Object b) {
            MsgBean b1 = (MsgBean)a;
            MsgBean b2 = (MsgBean)b;
            String tmp1 = "";
            String tmp2 = "";
            try {
                tmp1 = b1.getFrom();
            }
            catch (MessagingException ex) {
                // empty catch block
            }
            try {
                tmp2 = b2.getFrom();
            }
            catch (MessagingException ex) {
                // empty catch block
            }
            return direction * this.collate.compare(tmp1, tmp2);
        }
    }

    public static class FolderComparator
    implements Comparator {
        Collator collate = null;

        public FolderComparator(Collator c) {
            this.collate = c;
        }

        public int compare(Object a, Object b) {
            Folder f1 = ((FolderBean)a).getFolder();
            Folder f2 = ((FolderBean)b).getFolder();
            String tmp1 = f1.getName();
            String tmp2 = f2.getName();
            return direction * this.collate.compare(tmp1, tmp2);
        }
    }
}

