/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.portal.wireless.taglibs.base.Context;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.mail.AllView;
import com.sun.portal.wireless.taglibs.mail.ConfigBean;
import com.sun.portal.wireless.taglibs.mail.FolderBean;
import com.sun.portal.wireless.taglibs.mail.LineBean;
import com.sun.portal.wireless.taglibs.mail.MsgBean;
import com.sun.portal.wireless.taglibs.mail.PresetMsg;
import com.sun.portal.wireless.taglibs.mail.ViewBean;
import com.sun.portal.wireless.taglibs.util.Catalog;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationFactory;
import com.sun.ssoadapter.config.PSClientAwareContextFactory;
import com.sun.ssoadapter.impl.JavaMailSSOAdapter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class MailContext
extends Context {
    public static final String CONTEXT_CLASS_NAME = "com.sun.portal.wireless.taglibs.mail.MailContext";
    public static final String CONTEXT_CACHE_CLASS_NAME = "com.sun.portal.wireless.taglibs.mail.MailContextCache";
    public static final String CONTEXT_TYPE = "mailcontext";
    public static final String SSO_CONFIG_TYPE = "MAIL-TYPE";
    private JavaMailSSOAdapter mailSSOAdapter;
    private Session mailSession;
    private Store mailStore = null;
    private FolderBean currentFolder = null;
    private Folder INBOX;
    private String fromAddress = null;
    private MsgBean currentMsg = null;
    private int currentMsgIdx = 0;
    private boolean doMsgInclude = false;
    private boolean includeSig = true;
    private boolean saveSent = false;
    private ViewBean allView = null;
    private ViewBean currentView = null;
    private FolderBean[] folders = null;
    private MsgBean[] messages = null;
    private LineBean[] lines = null;
    private ViewBean[] views = null;
    private Vector presetMessages = null;
    private Vector configs = null;
    private int lineLength = 0;
    private Configuration mailAppConfig = null;

    public void init(HttpServletRequest request, SSOToken session, SSOAdapter ssoAdapter) throws Exception {
        super.init(request, session, "SunMobileAppMailService", ssoAdapter);
        this.initMail(session, request);
        this.initConfigs(request);
        this.initViewCollection(request);
        this.fromAddress = this.mailAppConfig.getProperty("fromAddress");
        if (this.fromAddress == null || this.fromAddress.length() == 0) {
            Properties ssoProperties = ssoAdapter.getProperties();
            String user = ssoProperties.getProperty("uid");
            if (user == null || user.length() == 0) {
                try {
                    HashMap<String, String> authServiceMap = new HashMap<String, String>();
                    authServiceMap.put("serviceName", "iPlanetAMAuthService");
                    PSClientAwareContextFactory authSvcContextFactory = PSClientAwareContextFactory.getInstance();
                    ClientAwareUserContext authSvcContext = authSvcContextFactory.getClientAwareUserContext(request);
                    String uidAttr = authSvcContext.getStringAttribute(authServiceMap, "iplanet-am-auth-user-naming-attr");
                    user = authSvcContext.getStringAttribute(authServiceMap, uidAttr);
                }
                catch (Exception e) {
                    Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".init(): cannot determine uid from SSOToken"));
                }
            }
            if (user == null || user.length() == 0) {
                this.fromAddress = "";
            } else if (user.indexOf(64) >= 0) {
                this.fromAddress = user;
            } else {
                String mailDomain = this.getAttributeString("sunMobileAppMailDefaultMailDomain");
                if (mailDomain == null || mailDomain.length() == 0) {
                    mailDomain = ssoProperties.getProperty("smtpServer");
                }
                if (mailDomain == null || mailDomain.length() == 0) {
                    mailDomain = ssoProperties.getProperty("host");
                }
                this.fromAddress = user + "@" + mailDomain;
            }
        }
        try {
            String lineLengthString = ClientsManager.getInstance((String)this.getClientType()).getProperty("lineLength");
            if (lineLengthString != null) {
                this.lineLength = Integer.parseInt(lineLengthString);
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
        String tmp = this.mailAppConfig.getProperty("sentFolderCopy");
        if (tmp != null) {
            Boolean b = new Boolean(tmp);
            this.saveSent = b;
        }
    }

    public static MailContext getContext(PageContext pageContext) throws Exception {
        return (MailContext)Context.getContext((PageContext)pageContext, (String)CONTEXT_CLASS_NAME, (String)CONTEXT_CACHE_CLASS_NAME, (String)CONTEXT_TYPE);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getInboxNumMsgs() throws MessagingException {
        int msgCount = this.INBOX.getMessageCount();
        if (msgCount < 0) {
            this.INBOX.open(1);
            msgCount = this.INBOX.getMessageCount();
            this.INBOX.close(false);
        }
        return msgCount;
    }

    public int getInboxNumUnreadMsgs() throws MessagingException {
        int unreadCount = this.INBOX.getUnreadMessageCount();
        if (unreadCount < 0) {
            this.INBOX.open(1);
            unreadCount = this.INBOX.getUnreadMessageCount();
            this.INBOX.close(false);
        }
        return unreadCount;
    }

    public int getInboxNumUnreadAddrToMeMsgs() throws MessagingException {
        boolean InboxWasAlreadyOpen = true;
        int unreadCount = this.INBOX.getUnreadMessageCount();
        if (unreadCount < 0 || !this.INBOX.isOpen()) {
            InboxWasAlreadyOpen = false;
            this.INBOX.open(1);
            unreadCount = this.INBOX.getUnreadMessageCount();
        }
        if (unreadCount > 0) {
            FlagTerm unseen = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            HeaderTerm to = new HeaderTerm("To", this.fromAddress);
            AndTerm term = new AndTerm((SearchTerm)unseen, (SearchTerm)to);
            Message[] msgs = this.INBOX.search((SearchTerm)term);
            int n = unreadCount = msgs != null ? msgs.length : 0;
        }
        if (!InboxWasAlreadyOpen) {
            this.INBOX.close(false);
        }
        return unreadCount;
    }

    public int getInboxNumNewMsgs() throws MessagingException {
        int newCount = this.INBOX.getNewMessageCount();
        if (newCount < 0) {
            this.INBOX.open(1);
            newCount = this.INBOX.getNewMessageCount();
            this.INBOX.close(false);
        }
        return newCount;
    }

    public int getNumMsgs() throws MessagingException {
        if (this.messages != null) {
            return this.messages.length;
        }
        Folder f = this.currentFolder.getFolder();
        return f.getMessageCount();
    }

    public int getNumUnreadMsgs() throws MessagingException {
        Folder f = this.currentFolder.getFolder();
        return f.getUnreadMessageCount();
    }

    public int getNumUnreadAddrToMeMsgs() throws MessagingException {
        Folder folder = this.currentFolder.getFolder();
        int unreadCount = folder.getUnreadMessageCount();
        if (unreadCount > 0) {
            FlagTerm unseen = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            HeaderTerm to = new HeaderTerm("To", this.fromAddress);
            AndTerm term = new AndTerm((SearchTerm)unseen, (SearchTerm)to);
            Message[] msgs = folder.search((SearchTerm)term);
            int n = unreadCount = msgs != null ? msgs.length : 0;
        }
        if (unreadCount < 0) {
            unreadCount = 0;
        }
        return unreadCount;
    }

    public int getNumNewMsgs() throws MessagingException {
        Folder f = this.currentFolder.getFolder();
        return f.getNewMessageCount();
    }

    public Folder getInbox() {
        return this.INBOX;
    }

    public FolderBean getCurrentFolder() {
        return this.currentFolder;
    }

    public void setCurrentFolder(FolderBean folder) {
        this.currentFolder = folder;
    }

    public MsgBean getMsg() {
        return this.currentMsg;
    }

    public void setMsg(MsgBean m) {
        this.currentMsg = m;
    }

    public int getMsgIdx() {
        return this.currentMsgIdx;
    }

    public void setMsgIdx(int idx) {
        this.currentMsgIdx = idx;
    }

    public String getFrom() {
        return this.fromAddress;
    }

    public String getTextEncoding() {
        Catalog rb = new Catalog("mail", this.getLocale());
        return rb.getMsg("textEncoding");
    }

    public String getCharset() {
        String charset = super.getCharset();
        try {
            Set attributeSet = this.getAttributeSet("sunMobileAppMailOutboundMailCharset");
            if (attributeSet == null) {
                return charset;
            }
            Iterator attrIterator = attributeSet.iterator();
            while (attrIterator.hasNext()) {
                String attribute = (String)attrIterator.next();
                if (!attribute.toUpperCase().startsWith(charset.toUpperCase())) continue;
                int i = attribute.indexOf(61);
                if (i > 0) {
                    return attribute.substring(i + 1);
                }
                return charset;
            }
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".getCharset(): "), (Throwable)e);
        }
        return charset;
    }

    public Store getMailStore() {
        return this.mailStore;
    }

    public Session getMailSession() {
        try {
            return this.mailSSOAdapter.getSession();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSignature() {
        return this.getAttributeString("sunMobileAppMailSignature", "");
    }

    public boolean saveSentMail() {
        return this.saveSent;
    }

    public boolean includeMsg() {
        return this.doMsgInclude;
    }

    public void setDoMsgInclude(String flag) {
        Boolean b = new Boolean(flag);
        this.doMsgInclude = b;
    }

    public boolean includeSig() {
        return this.includeSig;
    }

    public void setIncludeSig(String flag) {
        Boolean b = new Boolean(flag);
        this.includeSig = b;
    }

    public boolean isAtmsgend() {
        return this.currentMsgIdx + 1 >= this.messages.length;
    }

    public boolean isAtmsgstart() {
        return this.currentMsgIdx - 1 < 0;
    }

    public int getNextmsgidx() {
        if (!this.isAtmsgend()) {
            return this.currentMsgIdx + 1;
        }
        return this.messages.length - 1;
    }

    public int getPrevmsgidx() {
        if (!this.isAtmsgstart()) {
            return this.currentMsgIdx - 1;
        }
        return 0;
    }

    public boolean isPresetEmpty() {
        return this.presetMessages == null || this.presetMessages.size() <= 0;
    }

    public Vector getPresetMessages() {
        return this.presetMessages;
    }

    public boolean doPresetMessagesFetch() {
        Vector<PresetMsg> presetMsgList = new Vector<PresetMsg>();
        Set msgSetTmp = this.getAttributeSet("sunMobileAppMailPredefinedReplies");
        TreeSet msgSet = new TreeSet(msgSetTmp);
        if (msgSet == null) {
            this.presetMessages = presetMsgList;
            return true;
        }
        Iterator msgIterator = msgSet.iterator();
        int i = 1;
        while (msgIterator.hasNext()) {
            String nameValue = (String)msgIterator.next();
            int delimiter = nameValue.indexOf(61);
            if (delimiter != -1) {
                String presetIdx = "preset" + i;
                String key = nameValue.substring(0, delimiter);
                String value = nameValue.substring(delimiter + 1, nameValue.length());
                if (key.equals(presetIdx)) {
                    if (value != null && !value.equals("")) {
                        presetMsgList.add(new PresetMsg(value, i));
                    }
                } else {
                    Util.logError((String)(((Object)((Object)this)).getClass().getName() + ".doPresetMessagesFetch(): Key not equal to " + presetIdx + ". SunMobileAppMailService." + "sunMobileAppMailPredefinedReplies attribute misconfigured"));
                }
            } else {
                Util.logError((String)(((Object)((Object)this)).getClass().getName() + ".doPresetMessagesFetch(): Not of format " + "preset1|<predefined message>"));
            }
            ++i;
        }
        this.presetMessages = presetMsgList;
        return true;
    }

    public boolean isPopEmpty() {
        if (this.configs != null) {
            int i = 0;
            while (i < this.configs.size()) {
                if (((ConfigBean)this.configs.elementAt(i)).getProtocol().equals("pop3")) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public Vector getConfigsCollection() {
        return this.configs;
    }

    private void initViewCollection(HttpServletRequest request) {
        Set viewClients = this.getAttributeSet("sunMobileAppMailViewClients");
        this.allView = new AllView(0);
        if (viewClients != null && viewClients.size() > 0) {
            int len = viewClients.size();
            this.views = new ViewBean[len + 1];
            this.views[0] = this.allView;
            ConfigurationFactory viewFactory = ConfigurationFactory.getInstance((String)"SunMobileAppMailService", (String)"sunMobileAppMailViews");
            ConfigurationFactory ruleFactory = ConfigurationFactory.getInstance((String)"SunMobileAppMailService", (String)"sunMobileAppMailViewRules");
            String[] tmp = new String[len];
            viewClients.toArray(tmp);
            Configuration conf = null;
            int i = 0;
            while (i < len) {
                try {
                    int k = tmp[i].indexOf("|");
                    tmp[i] = tmp[i].substring(k + 1);
                    conf = viewFactory.readConfiguration(tmp[i], false, request);
                    this.views[i + 1] = new ViewBean(conf, ruleFactory, request, i + 1);
                }
                catch (Exception e) {
                    Util.logError((String)(((Object)((Object)this)).getClass().getName() + ".getCharset(): "), (Throwable)e);
                    this.views = new ViewBean[1];
                    this.views[0] = this.allView;
                    return;
                }
                ++i;
            }
        } else {
            this.views = new ViewBean[1];
            this.views[0] = this.allView;
        }
    }

    public int getNumOfViews() {
        return this.views.length;
    }

    public ViewBean[] getViewCollection() {
        return this.views;
    }

    public ViewBean getCurrentViewBean() {
        if (this.currentView == null) {
            return this.allView;
        }
        return this.currentView;
    }

    public void setCurrentView(String idx) {
        int index = -1;
        index = Integer.parseInt(idx);
        ViewBean current = this.allView;
        if (this.views != null && index >= 0 && index < this.views.length) {
            current = this.views[index];
        }
        this.currentView = current;
    }

    public void setDefaultView(String str) {
        ViewBean view = this.allView;
        Flags flags = new Flags(Flags.Flag.SEEN);
        FlagTerm term = null;
        if (str.equals("read")) {
            term = new FlagTerm(flags, true);
        } else if (str.equals("unread")) {
            term = new FlagTerm(flags, false);
        } else if (str.equals("unreadAddrToMe")) {
            term = new HeaderTerm("To", this.fromAddress);
            FlagTerm ft = new FlagTerm(flags, false);
            term = new AndTerm((SearchTerm)ft, (SearchTerm)term);
        } else {
            return;
        }
        if (term != null) {
            try {
                view = new ViewBean((SearchTerm)term);
            }
            catch (Exception e) {
                Util.logError((String)(((Object)((Object)this)).getClass().getName() + ".setDefaultView(): cannot create ViewBean"), (Throwable)e);
                return;
            }
        }
        this.currentView = view;
    }

    public FolderBean[] getFoldersCollection() {
        return this.folders;
    }

    public void setFoldersCollection(FolderBean[] folders) {
        this.folders = folders;
    }

    public MsgBean[] getMsgsCollection() {
        return this.messages;
    }

    public void setMsgsCollection(MsgBean[] msgs) {
        this.messages = msgs;
    }

    public LineBean[] getLinesCollection() {
        return this.lines;
    }

    public void setLinesCollection(LineBean[] vlines) {
        this.lines = vlines;
    }

    private void initMail(SSOToken session, HttpServletRequest request) throws Exception {
        this.mailSSOAdapter = (JavaMailSSOAdapter)this.ssoAdapter;
        this.mailStore = (Store)this.ssoAdapter.getConnection();
        this.currentFolder = new FolderBean(this.mailStore.getFolder("INBOX"));
        this.INBOX = this.mailStore.getFolder("INBOX");
    }

    private void initConfigs(HttpServletRequest request) throws Exception {
        ConfigurationFactory configFactory = ConfigurationFactory.getInstance((String)"SunSSOAdapterService", (String)"sunSSOAdapterConfigurations", (String)"sunConfigurationTemplates");
        Enumeration configEnum = configFactory.getConfigurationNames(request);
        if (configEnum != null) {
            this.configs = new Vector();
            int index = 0;
            while (configEnum.hasMoreElements()) {
                String configName = (String)configEnum.nextElement();
                Configuration configProps = configFactory.readConfiguration(configName, true, request);
                if (configProps == null || configProps.getConfigurationDescription() == null || !configProps.getConfigurationDescription().equals("POP-COLLECTIONS")) continue;
                this.configs.add(new ConfigBean(configName, configProps.getProperty("protocol"), index++));
            }
        }
        configFactory = ConfigurationFactory.getInstance((String)"SunMobileAppMailService", (String)"sunMobileAppMailConfig", (String)"sunConfigurationTemplates");
        try {
            String configName = this.ssoAdapter.getName();
            this.mailAppConfig = configFactory.readConfiguration(configName, true, request);
            if (this.mailAppConfig == null) {
                int i = configName.indexOf(95);
                if (i >= 0) {
                    this.mailAppConfig = configFactory.readConfiguration(configName.substring(0, i), true, request);
                }
                if (this.mailAppConfig == null) {
                    this.mailAppConfig = new Configuration();
                }
            }
        }
        catch (Exception e) {
            this.mailAppConfig = new Configuration();
        }
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (evtType != 3 && evtType != 1 && evtType != 2) {
                return;
            }
            if (this.currentFolder != null) {
                this.currentFolder.getFolder().close(true);
            }
            if (this.mailStore != null) {
                this.mailStore.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.ssoTokenChanged(evt);
    }
}

