/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.engine;

import com.aligo.aml.base.interfaces.AmlElement;
import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.engine.Content;
import com.aligo.engine.interfaces.AligoEngineInterface;
import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.exceptions.AligoException;
import com.aligo.modules.manager.StyleManagerFactory;
import com.aligo.modules.manager.exceptions.StyleManagerException;
import com.aligo.modules.manager.interfaces.StyleManager;
import com.aligo.modules.manager.log.StyleLogger;
import com.aligo.modules.maps.interfaces.MapContainerInterface;
import com.aligo.modules.presentation.loaders.interfaces.HandlerLoaderInterface;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.Cache;
import com.aligo.util.ClassUtils;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.PageCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class AligoEngine
implements AligoEngineInterface {
    private static final String MODULE_PATH = "com.aligo.modules";
    private static final String PATH_SEPARATOR = ".";
    private static final String LOADER_SUFFIX = "HandlerLoader";
    private static LoggerInterface oLogger;
    private LoggerInterface oLocalLogger;
    private Cache oCache;
    private static boolean bFirstRun;
    private static StyleManager oStyleManager;
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String WML_CONTENT_TYPE = "text/vnd.wap.wml";
    private static final String HDML_CONTENT_TYPE = "text/x-hdml";
    private static final String XHTML_CONTENT_TYPE = "text/html";
    private static HashMap contentTypes;

    public static void init(InputStreamReader configReader, InputStream externalLib, LoggerInterface logger) throws IOException {
        AligoEngine aligoEngine = new AligoEngine();
        aligoEngine.setLogger(logger);
        aligoEngine.initStyleManager(configReader, externalLib);
    }

    public void setCache(Cache cache) {
        this.oCache = cache;
    }

    public Cache getCache() {
        return this.oCache;
    }

    public synchronized void setLogger(LoggerInterface logger) {
        oLogger = logger;
        StyleLogger.setLogger(oLogger);
    }

    public static synchronized LoggerInterface getLogger() {
        return oLogger;
    }

    public void setLocalLogger(LoggerInterface logger) {
        this.oLocalLogger = logger;
    }

    public LoggerInterface getLocalLogger() {
        return this.oLocalLogger;
    }

    private synchronized void loadStyleManager() {
        block6: {
            try {
                if (!bFirstRun) break block6;
                boolean created = false;
                try {
                    oStyleManager = StyleManagerFactory.getStyleManager();
                    if (oStyleManager != null) {
                        created = true;
                    }
                }
                catch (StyleManagerException styleManagerException) {
                    // empty catch block
                }
                if (!created) {
                    this.initStyleManager();
                }
                bFirstRun = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Content processContent(AmlElement amlElement, UAProfile uaProfile) throws AligoException {
        return this.processContent(amlElement.getAxmlElement(), uaProfile);
    }

    public Content processContent(AxmlElement axmlElement, UAProfile uaProfile) throws AligoException {
        Content content = new Content();
        String contents = this.getContent(axmlElement, uaProfile);
        content.setContents(contents);
        this.setHeaders(content, axmlElement, uaProfile);
        return content;
    }

    public String getContent(AxmlElement axmlElement, UAProfile uaProfile) throws AligoException {
        LoggerInterface logger;
        Cache cache;
        String contents = null;
        if (bFirstRun) {
            this.loadStyleManager();
        }
        if ((cache = this.oCache) == null) {
            cache = new Cache();
        }
        if ((logger = this.oLocalLogger) == null) {
            logger = oLogger;
        }
        PageCache oPageCache = cache.getPageCache();
        FormRedirectionInfo formRedirectionInfo = cache.getFormRedirectionInfo();
        String dynamicURL = cache.getDynamicUrl();
        String cacheURL = cache.getCacheUrl();
        if (uaProfile != null) {
            String xmlID = uaProfile.getXmlID();
            HandlerLoaderInterface loader = this.getLoader(xmlID);
            if (loader != null) {
                MapContainerInterface mapContainer = this.getMapContainer(xmlID);
                loader.setMapContainer(mapContainer);
                loader.setUAProfile(uaProfile);
                loader.setCacheURL(cacheURL);
                loader.setPageCache(oPageCache);
                loader.setFormRedirectionInfo(formRedirectionInfo);
                loader.setDynamicURL(dynamicURL);
                loader.setLogger(logger);
                contents = loader.getContents(axmlElement);
            } else {
                throw new AligoException("Sorry engine does not support your device");
            }
        }
        return contents;
    }

    private void setHeaders(Content content, AxmlElement axmlElement, UAProfile uaProfile) {
        if (axmlElement instanceof AxmlDocument) {
            AxmlDocument document = (AxmlDocument)axmlElement;
            String encoding = document.getAxmlAttributeValue("encoding");
            AligoEngine.setContentType(content, uaProfile, encoding);
        }
        if (this.oCache != null) {
            this.oCache.setHeaders(content.getHeaders());
        }
    }

    public static void setContentType(Content content, UAProfile uaProfile, String encoding) {
        String contentType = (String)contentTypes.get(uaProfile.getXmlID());
        if (encoding != null && !encoding.equals("")) {
            content.addHeader("Encoding", encoding);
            contentType = contentType + "; charset=" + encoding;
        }
        content.addHeader("Content-type", contentType);
    }

    private InputStreamReader getSMConfigReader() throws IOException {
        Class<?> tclass = this.getClass();
        InputStream config = tclass.getResourceAsStream("config/stylemanager.xml");
        if (config == null) {
            config = tclass.getResourceAsStream("config/stylemanagerinternal.xml");
        }
        return new InputStreamReader(config);
    }

    private InputStream getSMInternalLib() throws IOException {
        Class<?> tclass = this.getClass();
        return tclass.getResourceAsStream("config/sminternallib.jar");
    }

    private InputStream getSMExternalLib() throws IOException {
        Class<?> tclass = this.getClass();
        return tclass.getResourceAsStream("config/smexternallib.jar");
    }

    private void initStyleManager() throws IOException {
        InputStreamReader configReader = this.getSMConfigReader();
        InputStream internallib = this.getSMInternalLib();
        InputStream externallib = this.getSMExternalLib();
        this.initStyleManager(configReader, internallib, externallib);
    }

    public void initStyleManager(InputStreamReader configReader, InputStream externalLib) throws IOException {
        InputStream internalLib = this.getSMInternalLib();
        this.initStyleManager(configReader, internalLib, externalLib);
    }

    private void initStyleManager(InputStreamReader configReader, InputStream internalLib, InputStream externalLib) throws IOException {
        try {
            oStyleManager = StyleManagerFactory.getStyleManager(configReader, internalLib, externalLib);
        }
        catch (StyleManagerException sm) {
            sm.printStackTrace();
            throw new IOException(sm.getMessage());
        }
    }

    private HandlerLoaderInterface getLoader(String xmlID) {
        String handlerName = "com.aligo.modules." + xmlID.toLowerCase() + PATH_SEPARATOR + xmlID + LOADER_SUFFIX;
        return (HandlerLoaderInterface)ClassUtils.createElement((String)handlerName);
    }

    private MapContainerInterface getMapContainer(String xmlID) throws AligoException {
        Object mapContainer = null;
        try {
            return oStyleManager.getMapContainer(xmlID);
        }
        catch (StyleManagerException ex) {
            throw new AligoException(ex.getMessage());
        }
    }

    static {
        bFirstRun = true;
        oStyleManager = null;
        contentTypes = new HashMap();
        contentTypes.put("Html", "text/html");
        contentTypes.put("CHtml", "text/html");
        contentTypes.put("IHtml", "text/html");
        contentTypes.put("JHtml", "text/html");
        contentTypes.put("Wml", WML_CONTENT_TYPE);
        contentTypes.put("Hdml", HDML_CONTENT_TYPE);
        contentTypes.put("XHtml", "text/html");
    }
}

