<%--
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms.
 --%>
<%-- @(#)psSearch.jsp --%>
<%@ page import="java.util.*" %>

<%@ taglib uri="/tld/jx.tld" prefix="jx" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/desktopTheme.tld" prefix="dttheme" %>

<dt:obtainChannel channel="$JSPProvider">
    <dtpc:providerContext>
	<!-- set the desktop theme variables --> 
	<dttheme:getAttribute name="bgColor" id="tBgColor" scope="request"/> 
	<dttheme:getAttribute name="titleBarColor" id="tTitleBarColor" scope="request"/> 
	<dttheme:getAttribute name="titleFontColor" id="tTitleFontColor" default="#000000" scope="request"/> 
	<dttheme:getAttribute name="fontColor" id="tFontColor" scope="request"/> 
	<dttheme:getAttribute name="borderColor" id="tBorderColor" scope="request"/> 
	<dttheme:getAttribute name="fontFace" id="tFontFace" scope="request"/> 
	<dttheme:getAttribute name="borderWidth" id="tBorderWidth" scope="request"/> 

	<%-- search channel properties --%>
	<dtpc:getStringProperty key="defaultMode" id="defaultMode" scope="request"/> 
	<dtpc:getStringProperty key="searchServer" id="searchServer" scope="request"/>
	<dtpc:getIntegerProperty key="viewHits" id="hitNumber" scope="request"/> 
	<dtpc:getBooleanProperty key="categorySearch" id="categorySearch" scope="request"/> 
	<dtpc:getSessionID id="accessToken" scope="request"/>
	<dtpc:getLocale id="locale" scope="request"/>
	<dtpc:getDesktopURL id="desktopUrl" scope="request"/>

	<%
	Map desktopArgsMap = new HashMap();
	Enumeration params = request.getParameterNames();
	while (  params.hasMoreElements() ) {
	    String paramKey = (String)params.nextElement(); 
	    String paramValue = request.getParameter(paramKey); 
	    if ((!paramKey.equalsIgnoreCase("mode")) && (!paramKey.equalsIgnoreCase("browseCategory")) && (!paramKey.equalsIgnoreCase("scope")) && (!paramKey.equalsIgnoreCase("database")) && (!paramKey.equalsIgnoreCase("page")) && (!paramKey.equalsIgnoreCase("description")) && (!paramKey.equalsIgnoreCase("scat")))
		desktopArgsMap.put(paramKey, paramValue); 
	} 
	pageContext.setAttribute("desktopArgs", desktopArgsMap); 
	%> 
	<dtpc:getDesktopURL id="dpurl" pathinfo="$desktopArgs" scope="request"/>

	<%
	Map pathInfo = new HashMap();
	pathInfo.put("action", "content");
	pathInfo.put("provider", "JSPDynamicSingleContainer");
	pathInfo.put("JSPDynamicSingleContainer.selectedChannel", "Discussions");
	pathInfo.put("last", "false");
	pageContext.setAttribute("pathInfo", pathInfo);
	%>
	<dtpc:getDesktopURL id="desktopPathInfo" pathinfo="$pathInfo" scope="request"/>
   </dtpc:providerContext>
   <dt:getName id="channelName" scope="request"/>
</dt:obtainChannel>
