<%@ page contentType="text/html; charset=UTF-8" %>
<%--
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms.
 --%>
<%-- @(#)results.jsp --%>
<%@page language= "java" import="com.sun.portal.search.providers.*,
                                 com.sun.portal.search.util.Encoder,
                                 java.util.*,
				 java.text.*" %>

<%@ page import="com.iplanet.sso.SSOTokenManager,
                 com.iplanet.sso.SSOToken, 
                 com.iplanet.am.sdk.AMStoreConnection, 
                 com.iplanet.sso.SSOException, 
                 com.iplanet.am.sdk.AMUser" %>

<%@ taglib uri="/tld/search.tld" prefix="search" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/jx.tld" prefix="jx" %>

<jsp:useBean id="formbean" scope="request" class="SearchRequestBean">
<jsp:setProperty name="formbean" property= "*"/>
</jsp:useBean>

<%-- declare all UI related variables --%>
<jx:declare id="tFontColor" type="java.lang.String"/>
<jx:declare id="tFontFace" type="java.lang.String"/>
<jx:declare id="tBgColor" type="java.lang.String"/>
<jx:declare id="tBorderColor" type="java.lang.String"/>

<!-- Beginning of about search results -->

<search:getDatabase id="rd_database" scope="request"/>
<jx:declare id="rd_database" type="java.lang.String"/>
<br><FONT color="#707070" face="<%=tFontFace%>">从 "<%=rd_database%>"&nbsp;</FONT>

<search:getNoHits id= "noHits"/>
<jx:choose>
<jx:when test="$noHits">
    <!-- Beginning of about search results --> 
    <search:getPage id="pg"/>
    <FONT face="<%=tFontFace%>" size="-1"><b>未找到<jx:if test="$pg != 1">更多</jx:if>结果。</b></font>
    <!-- End of about search results --> 
</jx:when> 

<jx:otherwise>
    <!-- Beginning of about search results --> 
    <FONT color="<%=tFontColor%>" face="<%=tFontFace%>" size="-1"> 
    <NOBR><B>结果<search:getFirstHit/> - <search:getToHit/> (共 <search:getHitCount/>)</B>
    </FONT>
<%
    try {
        SSOTokenManager mgr = SSOTokenManager.getInstance(); 
        SSOToken token = mgr.createSSOToken(request);
        if (token !=null) {
	    AMStoreConnection amstore = new AMStoreConnection(token);
	    AMUser user = amstore.getUser(token.getPrincipal().getName() );
	    boolean subscriptionsService = user.getAssignedServices().contains("SunPortalSubscriptionsService");
	    if ((user != null) && (subscriptionsService != false)) {
		//<!-- adding link to save search in the subscriptions channel --> 
		String[] db = request.getParameterValues("database");
		Map pathInfo = new HashMap();
		pathInfo.put("action", "edit");
		pathInfo.put("provider", "JSPEditContainer");
		pathInfo.put("targetprovider","Subscriptions");
		pathInfo.put("containerName", "SearchTabPanelContainer");
		pathInfo.put("last", "false");
		pageContext.setAttribute("pathInfo", pathInfo);
		%><dt:obtainChannel channel="$JSPProvider">
		<dtpc:providerContext>
		<search:getQuery id="searchQuery"/>
		<jx:declare id="searchQuery" type="java.lang.String"/>
		<%
		String query = "";
		String label = "";
                String server = (String)pageContext.findAttribute("searchServer");
                String database = rd_database;
		if (formbean.getMode().equals("adv")) {
		    if (searchQuery != null) {
			int scopeNdxStart = searchQuery.indexOf("scope=");
			int scopeNdxEnd = searchQuery.indexOf("&",scopeNdxStart);
			query = searchQuery.substring(
                                searchQuery.indexOf("=",scopeNdxStart)+1,
                                scopeNdxEnd);
		    }
		    label = Encoder.urlEncode(request.getParameter("wordsVal"),"UTF-8");
		} else {
		    query = Encoder.urlEncode(formbean.getScope(),"UTF-8");
		    label = Encoder.urlEncode(formbean.getScope(),"UTF-8");
                    server = Encoder.urlEncode(server,"UTF-8");
                    database = Encoder.urlEncode(rd_database,"UTF-8");
		}
		if (db != null && db.length > 0) {
		    if (db[0].equals("discussion")) {
			Map queryInfo = new HashMap();
			queryInfo.put("newDiscSubscription", "ROOT");
			queryInfo.put("newDiscTitle",label);
                        queryInfo.put("newServer",server);
                        queryInfo.put("newDB",database);
			queryInfo.put("scope",query);
			pageContext.setAttribute("queryInfo", queryInfo);
			%>
			&nbsp;&nbsp;<a target="ps_main" href='<dtpc:getDesktopURL pathinfo="$pathInfo" querymap="$queryInfo"/>'>保存此讨论搜索</a>&nbsp;
			<%
		    } else {
			if (formbean.getMode().equals("browse")) {
			    Map queryInfo = new HashMap();
			    queryInfo.put("newCatSubscription", Encoder.urlEncode(formbean.getBrowseCategory(),"UTF-8"));
			    queryInfo.put("scope",query);
                            queryInfo.put("newServer",server);
                            queryInfo.put("newDB",database);
			    pageContext.setAttribute("queryInfo", queryInfo);
			    %>
			&nbsp;&nbsp;<a target="ps_main" href='<dtpc:getDesktopURL pathinfo="$pathInfo" querymap="$queryInfo"/>'>保存搜索</a>&nbsp;
			<% } else {
			    Map queryInfo = new HashMap();
			    queryInfo.put("newSavedSearchSubscription", query);
			    queryInfo.put("title", label);
                            queryInfo.put("newServer",server);
                            queryInfo.put("newDB",database);
			    pageContext.setAttribute("queryInfo", queryInfo);
			    %>
			    &nbsp;&nbsp;<a target="ps_main" href='<dtpc:getDesktopURL pathinfo="$pathInfo" querymap="$queryInfo"/>'>保存搜索</a>&nbsp;
			<%}%>
		    <%}
		} else {
		    if (formbean.getMode().equals("browse") && (formbean.getScat().equals("cat") || (!formbean.getScat().equals("cat") && formbean.getScope().equals("")))) {
			Map queryInfo = new HashMap();
			queryInfo.put("newCatSubscription", Encoder.urlEncode(formbean.getBrowseCategory(),"UTF-8"));
			queryInfo.put("scope", query);
                        queryInfo.put("newServer",server);
                        queryInfo.put("newDB",database);
			pageContext.setAttribute("queryInfo", queryInfo);
			%>
			<a target="ps_main" href='<dtpc:getDesktopURL pathinfo="$pathInfo" querymap="$queryInfo"/>'>订阅类别</a>&nbsp;
		    <% } else {
			Map queryInfo = new HashMap();
			queryInfo.put("newSavedSearchSubscription",query);
			queryInfo.put("title",label);
                        queryInfo.put("newServer",server);
                        queryInfo.put("newDB",database);
			pageContext.setAttribute("queryInfo", queryInfo);
			%>
			<a target="ps_main" href='<dtpc:getDesktopURL pathinfo="$pathInfo" querymap="$queryInfo"/>'>保存搜索</a>&nbsp;
		    <%}%>
		<%}%>
		</dtpc:providerContext>
		</dt:obtainChannel><%
            }
        }
    } catch (Exception e) {
        // failed to get token or AMUser, means not subscription allowed
    }
%>
    </NOBR><BR>
    <!-- End of about search results -->

    <!-- Beginning of display results --> 
    <search:getNextResult input="$resultstream"> 

 <% if (!formbean.getMode().equals("browse") || !formbean.getScope().equals("")) { %>
      <%@ include file="score.jsp" %>
<% } %>

    <TABLE BORDER=0 CELLPADDING="0" CELLSPACING="5"> 

    <search:getURL id="url"/>
    <jx:declare id="url" type="java.lang.String"/>

    <jx:declare id="desktopPathInfo" type="java.lang.String"/>

    <jx:set var="isDiscussion" value="false"/>
    <search:getValue attribute="rd-reference-id" id="rid"/>
    <jx:if test="$rid != ''">
    <jx:set var="isDiscussion" value="true"/>
    <% url = desktopPathInfo+"?Discussions_dmode=vl&did="+Encoder.urlEncode(url); %>
    </jx:if> 
    <jx:declare id="isDiscussion" type="java.lang.String"/>

    <TR>
    <TD> 
    <A class=noUnderline target="ps_main" HREF="<%=url%>"><font face="<%=tFontFace%>"><search:getValue attribute="hl-title" escape="false"/></font></A><BR> 
    </TD> 
    </TR>

    <% if (formbean.getDescription().equals("brief")) { %> 
	<TR>
	<TD> 
	    <FONT size=-1 color=<%=tFontColor%> face=<%=tFontFace%>>
	    <search:getValue attribute="hl-description" escape="false"/>
	    </FONT>
        </TD> 
        </TR>

	<TR>
	<TD> 
	    <search:getValue attribute="hl-url" escape="false" id="rd_url" scope="request"/>
	    <jx:declare id="rd_url" type="java.lang.String"/>
	    <%@ include file="rating.jsp"%>
	</TD> 
	</TR>
    <% } else if (formbean.getDescription().equals("full")) { %> 
	<TR>
	<TD> 
	    <FONT size=-1 color=<%=tFontColor%> face=<%=tFontFace%>>
	    <search:getValue attribute="hl-description" escape="false"/>
	    </FONT>
	</TD> 
	</TR>

	<TR>
	<TD> 
	    <FONT size=-1 color=#707070 face=<%=tFontFace%>>

	    <search:getValue attribute="hl-url" escape="false" id="rd_url" scope="request"/>
	    <jx:declare id="rd_url" type="java.lang.String"/>
	    <%=rd_url%>&nbsp;

	    <search:getValue attribute="content-length" id="sz"/>
	    <jx:declare id="sz" type="java.lang.String"/>
	    <%
	    int sizek = 1;
	    try {
		sizek = Math.max(1, (Integer.parseInt(sz) + 512)/1024 ); 
	    } catch (Exception e) {
	    }
	    %>
	    大小： <%= sizek %>k&nbsp;

	    <search:getValue attribute="classification" multivalue="10" id="classification"/>
	    <search:getValue attribute="hl-classification" multivalue="10" id="hlclassification"/>
	    <jx:if test = "$classification != ''">
	    分类：
	    <%
	    String cls = (String)pageContext.getAttribute("classification");
	    String hlcls = (String)pageContext.getAttribute("hlclassification");
	    StringTokenizer st = new StringTokenizer(cls, "\n");
	    StringTokenizer sth = new StringTokenizer(hlcls, "\n");
	    while (st.hasMoreTokens() && sth.hasMoreTokens()) {
		String cl = st.nextToken();   // html encoded classification
		String clh = sth.nextToken(); // html encoded classification with highlights
		%>
		<A HREF="javascript:document.searchform.browseCategory.value=&quot;<%=SearchContext.htmlEncode(Encoder.quotedEscape(cl))%>&quot;;document.searchform.scope.value='';document.searchform.mode.value='browse';document.searchform.submit();"><FONT size=-1 face=<%=tFontFace%>><%=clh%></FONT></A>
		<%
	    } %>
	    </jx:if>
	    </FONT>
	</TD> 
	</TR>

	<TR>
	<TD> 
	    <%@ include file="rating.jsp"%>
	</TD> 
	</TR>

	<TR>
	<TD> 
	    <jx:choose>
	    <jx:when test="$isDiscussion == 'true'">
		<a target="ps_main" href="<%=url%>"><FONT size=-1 face=<%=tFontFace%>>查看讨论</FONT></a>
	    </jx:when>
	    <jx:otherwise>
		<a target="ps_main" href="<%=desktopPathInfo%>?Discussions_dmode=cmt&ref_id=<%=Encoder.urlEncode(url)%>&database=default"><FONT size=-1 face=<%=tFontFace%>>启动讨论</FONT></a>
	    </jx:otherwise>
	    </jx:choose>
	</TD> 
	</TR>
    <% } else { %> 
	<TR>
	<TD> 
    <% } %> 
    </TD> 
    </TR> 
    </TABLE> 

    </search:getNextResult>
    <!-- End of Display Results -->

    <search:getTotalPages id="total2" scope="request"/>
    <%--
    <% if (((Integer)pageContext.getAttribute("total3", PageContext.REQUEST_SCOPE)).intValue() > total2) { %>
       <jx:set var="total2" value="$total3"/>
    <% } %>
    --%>
    </jx:if>
</jx:otherwise>
</jx:choose>

