/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange.outlook;

import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.outlook.OutlookNewPimRecipientItem;
import com.aligo.pim.exchange.outlook.OutlookOldPimRecipientItem;
import com.aligo.pim.exchange.outlook.OutlookPimItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import outlook.Recipient;
import outlook.Recipients;

public class OutlookPimRecipientItems
extends OutlookPimItems
implements PimRecipientItems {
    private Recipients _oRecipients;

    public OutlookPimRecipientItems(Recipients _oRecipients) {
        this._oRecipients = _oRecipients;
    }

    public void setOutlookRecipients(Recipients _oRecipients) {
        this._oRecipients = _oRecipients;
    }

    public PimRecipientItem addRecipientItem() throws ExchangePimException {
        try {
            return new OutlookNewPimRecipientItem(this.getOutlookRecipients());
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
    }

    public Recipients getOutlookRecipients() {
        return this._oRecipients;
    }

    public int getCount() throws ExchangePimException {
        try {
            return this.getOutlookRecipients().getCount();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getRecipientItem(int itemNumber) throws ExchangePimException {
        try {
            Recipient _oRecipient = this.getOutlookRecipients().item(new Integer(itemNumber + 1));
            if (_oRecipient == null) {
                return null;
            }
            return new OutlookOldPimRecipientItem(_oRecipient);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getRecipientItem(String id) throws ExchangePimException {
        try {
            Recipient _oRecipient = this.getOutlookRecipients().item(new Integer(this.getFirstIndex()));
            while (_oRecipient != null) {
                if (_oRecipient.getEntryID().equals(id)) {
                    return new OutlookOldPimRecipientItem(_oRecipient);
                }
                _oRecipient = this.getOutlookRecipients().item(new Integer(this.getNextIndex()));
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
        return null;
    }

    public PimRecipientItem getFirstRecipientItem() throws ExchangePimException {
        try {
            return this.getRecipientItem(this.getFirstIndex() - 1);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getNextRecipientItem() throws ExchangePimException {
        try {
            return this.getRecipientItem(this.getNextIndex() - 1);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getLastRecipientItem() throws ExchangePimException {
        try {
            return this.getRecipientItem(this.getLastIndex() - 1);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getPreviousRecipientItem() throws ExchangePimException {
        try {
            return this.getRecipientItem(this.getPreviousIndex() - 1);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getRecipientItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getRecipientItem(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addRecipientItem();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstRecipientItem();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextRecipientItem();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastRecipientItem();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousRecipientItem();
    }
}

