/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeFolder;
import com.aligo.messaging.exchange.ExchangeFolders;
import com.aligo.pim.PimFolderItemsType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exchange.ExchangePimCalendar;
import com.aligo.pim.exchange.ExchangePimContact;
import com.aligo.pim.exchange.ExchangePimDeleted;
import com.aligo.pim.exchange.ExchangePimDraft;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFolderItemsTypeMapper;
import com.aligo.pim.exchange.ExchangePimGeneral;
import com.aligo.pim.exchange.ExchangePimInbox;
import com.aligo.pim.exchange.ExchangePimItems;
import com.aligo.pim.exchange.ExchangePimJournal;
import com.aligo.pim.exchange.ExchangePimNotes;
import com.aligo.pim.exchange.ExchangePimOutbox;
import com.aligo.pim.exchange.ExchangePimSent;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.ExchangePimSortTypeMapper;
import com.aligo.pim.exchange.ExchangePimTask;
import com.aligo.pim.exchange.util.ExchangePimUtil;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimFolders;
import com.aligo.pim.interfaces.PimItem;

public class ExchangePimFolders
extends ExchangePimItems
implements PimFolders {
    private ExchangeFolders _oFolders;

    public ExchangePimFolders(ExchangeFolders _oFolders, ExchangePimSession pimSession) {
        super(pimSession);
        this._oFolders = _oFolders;
    }

    public void setExchangeFolders(ExchangeFolders _oFolders) {
        this._oFolders = _oFolders;
    }

    public ExchangeFolders getExchangeFolders() {
        return this._oFolders;
    }

    public int getCount() throws ExchangePimException {
        try {
            if (this.getExchangeFolders() == null) {
                return 0;
            }
            return this.getExchangeFolders().getCount();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFolder getFolder(int itemNumber) throws ExchangePimException {
        try {
            ExchangeFolder _oFolder = this.getExchangeFolders().getItem(itemNumber + 1);
            if (_oFolder == null) {
                return null;
            }
            return this.getRespectivePimFolder(_oFolder);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFolder getFolder(String id) throws ExchangePimException {
        try {
            ExchangeFolder _oFolder = this.getExchangeFolders().getFirst();
            while (_oFolder != null) {
                if (_oFolder.getId().equals(id)) {
                    return this.getRespectivePimFolder(_oFolder);
                }
                _oFolder = this.getExchangeFolders().getNext();
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return null;
    }

    public PimFolder addFolder() throws ExchangePimException {
        return this.addFolder("Unknown");
    }

    public PimFolder addFolder(String name) throws ExchangePimException {
        return this.addFolder(name, PimFolderItemsType.MAIL_ITEMS);
    }

    public PimFolder addFolder(String name, PimFolderItemsType pimFolderItemsType) throws ExchangePimException {
        try {
            ExchangeFolder _oFolder = this.getExchangeFolders().add(name);
            ExchangeFields fields = _oFolder.getFields();
            fields.add(907214879, ExchangePimFolderItemsTypeMapper.getType(pimFolderItemsType));
            _oFolder.update(true, false);
            if (_oFolder == null) {
                return null;
            }
            return this.getRespectivePimFolder(_oFolder);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFolder getRespectivePimFolder(ExchangeFolder _oFolder) throws ExchangePimException {
        try {
            PimFolderItemsType type = ExchangePimUtil.getFodlerType(this.getPimSession().getExchangeSession(), _oFolder);
            if (type != null) {
                if (type.equals(PimFolderItemsType.MAIL_ITEMS) || type.equals(PimFolderItemsType.INBOX_ITEMS)) {
                    return new ExchangePimInbox(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.APPOINTMNENT_ITEMS)) {
                    return new ExchangePimCalendar(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.CONTACT_ITEMS)) {
                    return new ExchangePimContact(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.JOURNAL_ITEMS)) {
                    return new ExchangePimJournal(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.NOTE_ITEMS)) {
                    return new ExchangePimNotes(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.TASK_ITEMS)) {
                    return new ExchangePimTask(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.OUTBOX_ITEMS)) {
                    return new ExchangePimOutbox(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.SENT_ITEMS)) {
                    return new ExchangePimSent(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.DELETED_ITEMS)) {
                    return new ExchangePimDeleted(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.DRAFT_ITEMS)) {
                    return new ExchangePimDraft(_oFolder, this.getPimSession());
                }
                if (type.equals(PimFolderItemsType.GENERAL_ITEMS)) {
                    return new ExchangePimGeneral(_oFolder, this.getPimSession());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ExchangePimGeneral(_oFolder, this.getPimSession());
    }

    public PimFolder getFirstFolder() throws ExchangePimException {
        try {
            ExchangeFolders _oFolders = this.getExchangeFolders();
            if (_oFolders == null) {
                return null;
            }
            ExchangeFolder _oFolder = _oFolders.getFirst();
            if (_oFolder == null) {
                return null;
            }
            return this.getRespectivePimFolder(_oFolder);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFolder getNextFolder() throws ExchangePimException {
        try {
            ExchangeFolders _oFolders = this.getExchangeFolders();
            if (_oFolders == null) {
                return null;
            }
            ExchangeFolder _oFolder = _oFolders.getNext();
            if (_oFolder == null) {
                return null;
            }
            return this.getRespectivePimFolder(_oFolder);
        }
        catch (AligoExchangeException e) {
            return null;
        }
    }

    public PimFolder getLastFolder() throws ExchangePimException {
        try {
            ExchangeFolders _oFolders = this.getExchangeFolders();
            if (_oFolders == null) {
                return null;
            }
            ExchangeFolder _oFolder = _oFolders.getLast();
            if (_oFolder == null) {
                return null;
            }
            return this.getRespectivePimFolder(_oFolder);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFolder getPreviousFolder() throws ExchangePimException {
        try {
            ExchangeFolders _oFolders = this.getExchangeFolders();
            if (_oFolders == null) {
                return null;
            }
            ExchangeFolder _oFolder = _oFolders.getPrevious();
            if (_oFolder == null) {
                return null;
            }
            return this.getRespectivePimFolder(_oFolder);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void sort(PimSortType pimSortType) throws ExchangePimException {
        try {
            this.getExchangeFolders().sort(ExchangePimSortTypeMapper.getType(pimSortType), null);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeFolders().delete();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getFolder(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getFolder(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addFolder();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstFolder();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextFolder();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastFolder();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousFolder();
    }
}

