/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimTaskStatusType;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.interfaces.PimTaskItem;
import com.aligo.pim.lotus.LotusPimCommonTaskItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimExistingApptExistingReminderItem;
import com.aligo.pim.lotus.LotusPimExistingApptNewReminderItem;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimRecurrencePatternItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTaskItem;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextStyle;
import lotus.domino.ViewEntry;

public class LotusPimRecurringTaskItem
extends LotusPimMessageItem
implements PimTaskItem,
LotusPimCommonTaskItem {
    public static final String ID_DELIMITER = "+";
    public static final String DATE_INDEX_DELIMITER = ":";
    private int m_iStartDateTimeIndex;
    private int m_iEndDateTimeIndex;
    private LotusPimRecurrencePatternItem m_oPimRecurrencePatternItem;
    private PimReminderItem m_oPimReminderItem;

    public LotusPimRecurringTaskItem(ViewEntry viewEntry, int n, int n2, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
        this.m_iStartDateTimeIndex = n;
        this.m_iEndDateTimeIndex = n2;
    }

    public LotusPimRecurringTaskItem(Document document, int n, int n2, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
        this.m_iStartDateTimeIndex = n;
        this.m_iEndDateTimeIndex = n2;
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws LotusPimException {
        try {
            String string = this.getLotusDocument().getItemValueString("OrgRepeat");
            if (string != null && string.equals("1")) {
                this.m_oPimRecurrencePatternItem = new LotusPimRecurrencePatternItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem getReminderItem() throws LotusPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                String string = this.getLotusDocument().getItemValueString("Alarms");
                if (string != null && string.equals("1") && this.getLotusDocument().hasItem("$Alarm") && this.getLotusDocument().getItemValueInteger("$Alarm") == 1) {
                    this.m_oPimReminderItem = new LotusPimExistingApptExistingReminderItem(this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
                } else {
                    return null;
                }
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem addReminderItem() throws LotusPimException {
        try {
            this.m_oPimReminderItem = this.getReminderItem();
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new LotusPimExistingApptNewReminderItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private DateTime getStartDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem("StartDateTime") && !(vector = this.getLotusDocument().getItemValue("StartDateTime")).isEmpty() && vector.size() > this.getStartDateTimeIndex()) {
                DateTime dateTime = (DateTime)vector.elementAt(this.getStartDateTimeIndex());
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    private int getStartDateTimeIndex() {
        return this.m_iStartDateTimeIndex;
    }

    private int getEndDateTimeIndex() {
        return this.m_iEndDateTimeIndex;
    }

    private DateTime getDueDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem("DueDateTime") && !(vector = this.getLotusDocument().getItemValue("DueDateTime")).isEmpty() && vector.size() > this.getEndDateTimeIndex()) {
                DateTime dateTime = (DateTime)vector.elementAt(this.getEndDateTimeIndex());
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public Date getDueDate() throws LotusPimException {
        try {
            DateTime dateTime = this.getDueDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public PimImportanceType getImportance() throws LotusPimException {
        return PimImportanceType.NORMAL;
    }

    public String getLocation() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem("Location")) {
                return this.getLotusDocument().getItemValueString("Location");
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public Date getStartDate() throws LotusPimException {
        try {
            DateTime dateTime = this.getStartDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public String getSubject() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem("subject")) {
                return this.getLotusDocument().getItemValueString("subject");
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getText() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem("Body")) {
                return this.getLotusDocument().getItemValueString("Body");
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public void setDueDate(Date date) throws LotusPimException {
        try {
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            DateTime dateTime2 = this.getStartDateTime();
            if (dateTime2 == null || dateTime.timeDifference(dateTime2) < 0) {
                throw new LotusPimException(13L);
            }
            this.getLotusDocument().replaceItemValue("DueDate", (Object)dateTime);
            this.getLotusDocument().replaceItemValue("DueDateTime", (Object)dateTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
    }

    public void setLocation(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("Location", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setStartDate(Date date) throws LotusPimException {
        try {
            DateTime dateTime = this.getLotusSession().createDateTime(date);
            DateTime dateTime2 = this.getDueDateTime();
            if (dateTime2 != null && dateTime2.timeDifference(dateTime) < 0) {
                throw new LotusPimException(13L);
            }
            this.getLotusDocument().replaceItemValue("CalendarDateTime", (Object)dateTime);
            this.getLotusDocument().replaceItemValue("StartDate", (Object)dateTime);
            this.getLotusDocument().replaceItemValue("StartDateTime", (Object)dateTime);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("subject", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setText(String string) throws LotusPimException {
        try {
            this.getLotusDocument().removeItem("Body");
            this.getLotusDocument().save(true);
            try {
                RichTextItem richTextItem = this.getLotusDocument().createRichTextItem("Body");
                RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                richTextStyle.setFontSize(9);
                richTextItem.appendStyle(richTextStyle);
                richTextItem.appendText(string);
            }
            catch (Exception exception) {
                this.getLotusDocument().replaceItemValue("Body", (Object)string);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Task Item forwarded ");
            LotusPimTaskItem lotusPimTaskItem = new LotusPimTaskItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimTaskItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
        try {
            super.send();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getID() throws LotusPimException {
        try {
            return this.getLotusDocument().getNoteID() + ID_DELIMITER + this.getStartDateTimeIndex() + DATE_INDEX_DELIMITER + this.getEndDateTimeIndex();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            return "Task: " + this.getSubject() + " in " + this.getLocation();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
        try {
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskStatusType getStatus() throws LotusPimException {
        try {
            int n;
            Document document = this.getLotusDocument();
            if (document.hasItem("DueState") && (n = document.getItemValueInteger("DueState")) == 9) {
                return PimTaskStatusType.COMPLETE;
            }
            return PimTaskStatusType.NOT_COMPLETE;
        }
        catch (Exception exception) {
            return PimTaskStatusType.NOT_COMPLETE;
        }
    }

    public void setStatus(PimTaskStatusType pimTaskStatusType) throws LotusPimException {
        try {
            if (pimTaskStatusType != null) {
                Document document = this.getLotusDocument();
                if (pimTaskStatusType.equals(PimTaskStatusType.COMPLETE)) {
                    if (this.getStatus().equals(PimTaskStatusType.NOT_COMPLETE)) {
                        document.replaceItemValue("ASSIGNSTATE", (Object)new Integer(9));
                        DateTime dateTime = this.getLotusSession().createDateTime(new Date());
                        document.replaceItemValue("CompletedDateTime", (Object)dateTime);
                        document.replaceItemValue("DueState", (Object)new Integer(9));
                        document.replaceItemValue("NoticeType", (Object)"F");
                        document.replaceItemValue("_ViewIcon", (Object)new Integer(82));
                    }
                } else if (this.getStatus().equals(PimTaskStatusType.COMPLETE)) {
                    document.removeItem("ASSIGNSTATE");
                    document.removeItem("CompletedDateTime");
                    document.removeItem("NoticeType");
                    document.replaceItemValue("_ViewIcon", (Object)new Integer(168));
                    document.replaceItemValue("DueState", (Object)new Integer(1));
                }
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

