/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimRecipientType;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItems;
import com.aligo.pim.lotus.LotusPimRecipientItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.Session;

public class LotusPimRecipientItems
extends LotusPimItems
implements PimRecipientItems {
    private Vector m_oSendTo = new Vector();
    private Vector m_oCopyTo = new Vector();
    private Vector m_oBlindCopyTo = new Vector();
    private Session _oSession;

    public LotusPimRecipientItems(Session session, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._oSession = session;
    }

    public Vector getSendTo() {
        return this.m_oSendTo;
    }

    public Vector getCopyTo() {
        return this.m_oCopyTo;
    }

    public Vector getBlindCopyTo() {
        return this.m_oBlindCopyTo;
    }

    public Session getLotusSession() {
        return this._oSession;
    }

    public Vector getSendToVector() throws LotusPimException {
        if (this.m_oSendTo == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.m_oSendTo.elements();
        while (enumeration.hasMoreElements()) {
            LotusPimRecipientItem lotusPimRecipientItem = (LotusPimRecipientItem)enumeration.nextElement();
            vector.add(lotusPimRecipientItem.getEmailAddress());
        }
        return vector;
    }

    public Vector getCopyToVector() throws LotusPimException {
        if (this.m_oCopyTo == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.m_oCopyTo.elements();
        while (enumeration.hasMoreElements()) {
            LotusPimRecipientItem lotusPimRecipientItem = (LotusPimRecipientItem)enumeration.nextElement();
            vector.add(lotusPimRecipientItem.getEmailAddress());
        }
        return vector;
    }

    public Vector getBlindCopyToVector() throws LotusPimException {
        if (this.m_oBlindCopyTo == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.m_oBlindCopyTo.elements();
        while (enumeration.hasMoreElements()) {
            LotusPimRecipientItem lotusPimRecipientItem = (LotusPimRecipientItem)enumeration.nextElement();
            vector.add(lotusPimRecipientItem.getEmailAddress());
        }
        return vector;
    }

    public void setSendTo(Vector vector) throws LotusPimException {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LotusPimRecipientItem lotusPimRecipientItem = new LotusPimRecipientItem(this, this.getLotusPimSession(), this.getRecycle());
            lotusPimRecipientItem.setEmailAddress(string);
            lotusPimRecipientItem.setRecipientType(PimRecipientType.TO);
            this.m_oSendTo.add(lotusPimRecipientItem);
        }
    }

    public void setCopyTo(Vector vector) throws LotusPimException {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LotusPimRecipientItem lotusPimRecipientItem = new LotusPimRecipientItem(this, this.getLotusPimSession(), this.getRecycle());
            lotusPimRecipientItem.setEmailAddress(string);
            lotusPimRecipientItem.setRecipientType(PimRecipientType.CC);
            this.m_oCopyTo.add(lotusPimRecipientItem);
        }
    }

    public void setBlindCopyTo(Vector vector) throws LotusPimException {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LotusPimRecipientItem lotusPimRecipientItem = new LotusPimRecipientItem(this, this.getLotusPimSession(), this.getRecycle());
            lotusPimRecipientItem.setEmailAddress(string);
            lotusPimRecipientItem.setRecipientType(PimRecipientType.BCC);
            this.m_oBlindCopyTo.add(lotusPimRecipientItem);
        }
    }

    public PimRecipientItem addRecipientItem() throws LotusPimException {
        try {
            LotusPimRecipientItem lotusPimRecipientItem = new LotusPimRecipientItem(this, this.getLotusPimSession(), this.getRecycle());
            return lotusPimRecipientItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimItem addItem() throws LotusPimException {
        return this.addRecipientItem();
    }

    public void addRecipient(LotusPimRecipientItem lotusPimRecipientItem) throws LotusPimException {
        try {
            if (lotusPimRecipientItem == null) {
                return;
            }
            PimRecipientType pimRecipientType = lotusPimRecipientItem.getRecipientType();
            if (pimRecipientType.equals(PimRecipientType.TO)) {
                this.m_oSendTo.add(lotusPimRecipientItem);
            } else if (pimRecipientType.equals(PimRecipientType.CC)) {
                this.m_oCopyTo.add(lotusPimRecipientItem);
            } else if (pimRecipientType.equals(PimRecipientType.BCC)) {
                this.m_oBlindCopyTo.add(lotusPimRecipientItem);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            this.m_oSendTo = null;
            this.m_oCopyTo = null;
            this.m_oBlindCopyTo = null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void deleteRecipient(LotusPimRecipientItem lotusPimRecipientItem) throws LotusPimException {
        try {
            PimRecipientType pimRecipientType = lotusPimRecipientItem.getRecipientType();
            if (pimRecipientType.equals(PimRecipientType.TO)) {
                this.m_oSendTo.remove(lotusPimRecipientItem);
            } else if (pimRecipientType.equals(PimRecipientType.CC)) {
                this.m_oCopyTo.remove(lotusPimRecipientItem);
            } else if (pimRecipientType.equals(PimRecipientType.BCC)) {
                this.m_oBlindCopyTo.remove(lotusPimRecipientItem);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getCount() throws LotusPimException {
        try {
            return this.getSendTo().size() + this.getCopyTo().size() + this.getBlindCopyTo().size();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecipientItem getRecipientItem(int n) throws LotusPimException {
        try {
            if (this.getCount() <= 0 || n >= this.getCount() || n < 0) {
                return null;
            }
            if (n >= 0 && n < this.m_oSendTo.size()) {
                return (PimRecipientItem)this.m_oSendTo.elementAt(n);
            }
            if ((n -= this.m_oSendTo.size()) >= 0 && n < this.m_oCopyTo.size()) {
                return (PimRecipientItem)this.m_oCopyTo.elementAt(n);
            }
            if ((n -= this.m_oCopyTo.size()) >= 0 && n < this.m_oBlindCopyTo.size()) {
                return (PimRecipientItem)this.m_oBlindCopyTo.elementAt(n);
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecipientItem getRecipientItem(String string) throws LotusPimException {
        return null;
    }

    public PimItem getItem(int n) throws LotusPimException {
        return this.getRecipientItem(n);
    }

    public PimItem getItem(String string) throws LotusPimException {
        return this.getRecipientItem(string);
    }

    public PimItem getFirstItem() throws LotusPimException {
        try {
            return this.getItem(this.getFirstIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimItem getNextItem() throws LotusPimException {
        try {
            return this.getItem(this.getNextIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimItem getLastItem() throws LotusPimException {
        try {
            return this.getItem(this.getLastIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimItem getPreviousItem() throws LotusPimException {
        try {
            return this.getItem(this.getPreviousIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecipientItem getFirstRecipientItem() throws LotusPimException {
        try {
            return this.getRecipientItem(this.getFirstIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecipientItem getNextRecipientItem() throws LotusPimException {
        try {
            return this.getRecipientItem(this.getNextIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecipientItem getLastRecipientItem() throws LotusPimException {
        try {
            return this.getRecipientItem(this.getLastIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecipientItem getPreviousRecipientItem() throws LotusPimException {
        try {
            return this.getRecipientItem(this.getPreviousIndex());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

