/*
 * Decompiled with CFR 0.152.
 */
import com.aligo.pim.PimContainerType;
import com.aligo.pim.PimFactory;
import com.aligo.pim.PimFolderType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimRecipientType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.PimUserInfoParameter;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAttachmentItem;
import com.aligo.pim.interfaces.PimAttachmentItems;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimInbox;
import com.aligo.pim.interfaces.PimMailItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMailMessageItemFilter;
import com.aligo.pim.interfaces.PimMailMessageItems;
import com.aligo.pim.interfaces.PimMeetingItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.interfaces.PimUserInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class TestKCS {
    private static String LABEL_NO_SUBJECT = "(No Subject)";

    public static void main(String[] stringArray) {
        try {
            PimContainer pimContainer = TestKCS.getPimContainer();
            TestKCS.getTotalMessages(pimContainer);
            TestKCS.getNoOfFilteredMessages(pimContainer, 1, 0);
            TestKCS.getMessages(pimContainer, 1, 0, 0, 20);
            int n = 0;
            while (n < 1000) {
                String string = "5A67E2A0F622683B07256D12008213B1";
                TestKCS.getSingleMail(pimContainer, string);
                TestKCS.getNoOfFilteredMessages(pimContainer, 1, 0);
                TestKCS.getMessages(pimContainer, 1, 0, 0, 20);
                ++n;
            }
            TestKCS.getTotalMessages(pimContainer);
            pimContainer.logoff();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static PimContainer getPimContainer() {
        try {
            PimContainer pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.LOTUS);
            PimUserInfo pimUserInfo = pimContainer.addUserInfo();
            pimUserInfo.set(PimUserInfoParameter.LOTUS_USERNAME, "Jordan Meyerowitz");
            pimUserInfo.set(PimUserInfoParameter.LOTUS_PASSWORD, "jordan");
            pimUserInfo.set(PimUserInfoParameter.LOTUS_SERVER, "domino1");
            pimContainer.logon();
            return pimContainer;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void getTotalMessages(PimContainer pimContainer) {
        int n = 0;
        int n2 = 0;
        try {
            PimInbox pimInbox = (PimInbox)pimContainer.getFolder(PimFolderType.INBOX);
            PimMailMessageItems pimMailMessageItems = (PimMailMessageItems)pimInbox.getItems();
            n = pimMailMessageItems.getCount();
            PimMailMessageItemFilter pimMailMessageItemFilter = pimMailMessageItems.getMailMessageItemFilter();
            pimMailMessageItemFilter.setUnread(true);
            n2 = pimMailMessageItems.getCount();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static int getNoOfFilteredMessages(PimContainer pimContainer, int n, int n2) {
        try {
            PimInbox pimInbox = (PimInbox)pimContainer.getFolder(PimFolderType.INBOX);
            PimMailMessageItems pimMailMessageItems = (PimMailMessageItems)pimInbox.getItems();
            TestKCS.prepareFilter(pimMailMessageItems, n, n2);
            return pimMailMessageItems.getCount();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    private static void prepareFilter(PimMailMessageItems pimMailMessageItems, int n, int n2) {
        try {
            if (n == 2) {
                PimMailMessageItemFilter pimMailMessageItemFilter = pimMailMessageItems.getMailMessageItemFilter();
                pimMailMessageItemFilter.setUnread(true);
            } else if (n == 3) {
                PimMailMessageItemFilter pimMailMessageItemFilter = pimMailMessageItems.getMailMessageItemFilter();
                pimMailMessageItemFilter.setImportance(PimImportanceType.HIGH);
            } else if (n == 4 && n2 != 1) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                if (n2 == 3) {
                    calendar.add(5, -7);
                } else if (n2 == 4) {
                    calendar.add(5, -30);
                } else if (n2 == 5) {
                    calendar.add(5, -60);
                }
                PimMailMessageItemFilter pimMailMessageItemFilter = pimMailMessageItems.getMailMessageItemFilter();
                pimMailMessageItemFilter.setStartTime(calendar.getTime());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void getMessages(PimContainer pimContainer, int n, int n2, int n3, int n4) {
        PimMailMessageItem pimMailMessageItem = null;
        Vector vector = new Vector();
        try {
            PimInbox pimInbox = (PimInbox)pimContainer.getFolder(PimFolderType.INBOX);
            PimMailMessageItems pimMailMessageItems = (PimMailMessageItems)pimInbox.getItems();
            TestKCS.prepareFilter(pimMailMessageItems, n, n2);
            pimMailMessageItems.sort(PimSortType.DESCENDING);
            int n5 = n3;
            while (n5 < n3 + n4) {
                if (n5 < pimMailMessageItems.getCount() && ((pimMailMessageItem = pimMailMessageItems.getMailMessageItem(n5)) instanceof PimMailItem || pimMailMessageItem instanceof PimMeetingItem)) {
                    Object object;
                    String string;
                    String string2;
                    PimMailItem pimMailItem;
                    if (pimMailMessageItem instanceof PimMailItem) {
                        pimMailItem = (PimMailItem)pimMailMessageItem;
                        string2 = pimMailItem.getSubject();
                        if (TestKCS.isEmptyOrNull(string2)) {
                            string2 = LABEL_NO_SUBJECT;
                        }
                        pimMailItem.getUnread();
                        string = pimMailItem.getSender();
                        if (!(string == null || string.equals("") || (object = string.getName()) != null && ((String)object).trim().length() != 0)) {
                            object = string.getEmailAddress();
                        }
                        object = pimMailItem.getAttachmentItems();
                        int n6 = object.getCount();
                        pimMailItem.getID();
                        Date date = pimMailItem.getTimeReceived();
                    } else if (pimMailMessageItem instanceof PimMeetingItem) {
                        pimMailItem = (PimMeetingItem)pimMailMessageItem;
                        string2 = pimMailItem.getAssociatedAppointmentItem();
                        string = string2.getSubject();
                        if (TestKCS.isEmptyOrNull(string)) {
                            string = LABEL_NO_SUBJECT;
                        }
                        string2.getImportance();
                        pimMailItem.getUnread();
                        object = string2.getOrganizer();
                        if (object != null && !object.equals("")) {
                            String string3 = object.getName();
                        }
                        pimMailItem.getID();
                        Date date = pimMailItem.getTimeReceived();
                    }
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void getSingleMail(PimContainer pimContainer, String string) {
        try {
            PimInbox pimInbox = (PimInbox)pimContainer.getFolder(PimFolderType.INBOX);
            PimMailMessageItems pimMailMessageItems = (PimMailMessageItems)pimInbox.getItems();
            pimMailMessageItems.sort(PimSortType.DESCENDING);
            PimMailMessageItem pimMailMessageItem = pimMailMessageItems.getMailMessageItem(string);
            System.out.println("subject =" + pimMailMessageItem.getSubject());
            TestKCS._getSingleMail(pimMailMessageItem, pimMailMessageItems, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void _getSingleMail(PimMailMessageItem pimMailMessageItem, PimMailMessageItems pimMailMessageItems, String string) {
        try {
            if (pimMailMessageItem instanceof PimMailItem) {
                PimMailItem pimMailItem = (PimMailItem)pimMailMessageItem;
                pimMailItem.setUnread(false);
                pimMailItem.update();
                pimMailItem.getID();
                pimMailItem.getTimeReceived();
                pimMailItem.getBody();
                pimMailItem.getSubject();
                TestKCS._setSender(pimMailItem.getSender());
                TestKCS._setAttachments((PimAttachmentItems)pimMailItem.getAttachmentItems());
                TestKCS._setRecipients(pimMailItem.getRecipientItems());
                TestKCS._setPreviousNext(pimMailMessageItems, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void _setPreviousNext(PimMailMessageItems pimMailMessageItems, String string) throws PimException {
        PimMailMessageItem pimMailMessageItem = pimMailMessageItems.getFirstMailMessageItem();
        if (!string.equals(pimMailMessageItem.getID())) {
            // empty if block
        }
        if (!string.equals((pimMailMessageItem = pimMailMessageItems.getLastMailMessageItem()).getID())) {
            // empty if block
        }
    }

    private static void _setSender(PimAddressEntryItem pimAddressEntryItem) throws PimException {
        if (pimAddressEntryItem != null) {
            TestKCS.getSmtpMailAddressFromAddressEntry(pimAddressEntryItem);
            pimAddressEntryItem.getBusinessTelephoneNumber();
            pimAddressEntryItem.getMobileTelephoneNumber();
        }
    }

    private static void _setAttachments(PimAttachmentItems pimAttachmentItems) throws PimException {
        int n = pimAttachmentItems.getCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            PimAttachmentItem pimAttachmentItem = pimAttachmentItems.getAttachmentItem(n2);
            stringArray[n2] = pimAttachmentItem.getName();
            ++n2;
        }
    }

    private static String getSmtpMailAddressFromAddressEntry(PimAddressEntryItem pimAddressEntryItem) {
        try {
            String string = null;
            string = pimAddressEntryItem.getEmailAddress();
            if (string.equals("") || string == null) {
                string = pimAddressEntryItem.getName();
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void _setRecipients(PimRecipientItems pimRecipientItems) throws PimException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n = 0;
        while (n < pimRecipientItems.getCount()) {
            stringArray = pimRecipientItems.getRecipientItem(n);
            String string = TestKCS.getSmtpMailAddress((PimRecipientItem)stringArray);
            if (string != null) {
                PimRecipientType pimRecipientType = stringArray.getRecipientType();
                if (pimRecipientType == PimRecipientType.TO) {
                    arrayList.add(string);
                } else if (pimRecipientType == PimRecipientType.CC) {
                    arrayList2.add(string);
                } else if (pimRecipientType == PimRecipientType.BCC) {
                    arrayList3.add(string);
                }
            }
            ++n;
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        stringArray = new String[arrayList3.size()];
        arrayList3.toArray(stringArray);
    }

    private static String getSmtpMailAddress(PimRecipientItem pimRecipientItem) {
        try {
            String string = null;
            string = pimRecipientItem.getEmailAddress();
            if (string.indexOf("@") == -1 || string.indexOf("CN=") != -1) {
                PimAddressEntryItem pimAddressEntryItem = pimRecipientItem.getAddressEntryItem();
                string = pimAddressEntryItem.getEmailAddress();
                if (string.equals("") || string == null) {
                    string = pimAddressEntryItem.getName();
                }
            } else if (string.indexOf("SMTP:") != -1) {
                string = string.substring(5);
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean isEmptyOrNull(String string) {
        return string == null || string.trim().length() == 0;
    }
}

