/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.BasicAuthentication;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.SSLCachedSSLSocketFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSession;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.AuthContext;
import sun.security.ssl.SSLSocketImpl;

public class SSLHTTPSRetriever
extends HTTPRetriever {
    private static final String DEFAULT_SSL_PORT = "443";
    private SSLSession session;
    public static String currentReqHost;
    private static String rpSubdomain;
    private static String rpDomain;
    private static boolean doBasicAuthentication;

    public byte[] getServerCertificate() {
        return null;
    }

    public Response getResponse(Request request, String string, Integer n) {
        Object object;
        block23: {
            CachedSocket cachedSocket = null;
            String string2 = null;
            boolean bl = false;
            if (doBasicAuthentication) {
                string2 = request.getRequestHeader("Authorization");
                if (string2 == null) {
                    bl = BasicAuthentication.getPassword(request, string);
                } else {
                    object = string2.substring(string2.indexOf(58) + 1).trim();
                    if (!((String)object).regionMatches(true, 0, "basic ", 0, 5)) {
                        string2 = null;
                    }
                }
            }
            object = new HTTPResponse();
            try {
                String string3;
                Object object2;
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SSLHTTPSRetriever: AttemptRetrieve " + request);
                }
                if (request.getUseProxy()) {
                    String string4;
                    object2 = request.getProxyHost();
                    string3 = request.getRequestHeader("Proxy-Authorization");
                    if (string3 == null && (string4 = HTTPRetriever.getProxyPassword((String)object2)) != null) {
                        request.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + string4);
                    }
                    cachedSocket = this.createTunnelSocket(request);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("SSLHTTPSRetriever: Connecting to " + request.getProxyHost());
                    }
                } else {
                    cachedSocket = SSLCachedSSLSocketFactory.getCachedSocket(request.getHost(), Integer.parseInt(request.getPort()), "ssl", n);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("SSLHTTPSRetriever: Connecting to: " + request.getHost());
                    }
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SSLHTTPSRetriever: Connecting to: " + request.getHost());
                }
                if (cachedSocket == null) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("SSLHTTPSRetriever: Null socket returned. Probably couldn't resolve host.");
                    }
                    return null;
                }
                this.ForceSSLHandshake(request, cachedSocket);
                try {
                    this.sendRequest(request, cachedSocket);
                    object2 = cachedSocket.getInputStream();
                    this.getResponseHeader((HTTPResponse)object, (CSBufferedInputStream)object2, request);
                }
                catch (Exception exception) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Exception while sending request/recieving response", exception);
                    }
                    return null;
                }
                if (doBasicAuthentication && object.getStatusCode().compareTo("401") != 0 && object.getStatusCode().compareTo("403") != 0 && string2 != null) {
                    BasicAuthentication.storePassword(request, string);
                }
                string3 = object.getResponseHeader("content-length");
                int n2 = 0;
                n2 = string3 != null ? Integer.parseInt(string3.substring(string3.indexOf(58) + 1).trim()) : -1;
                ((CSBufferedInputStream)object2).setClosed();
                ((CSBufferedInputStream)object2).setLength(n2);
                ((HTTPResponse)object).setContentStream((BufferedInputStream)object2);
                object.setSocket(cachedSocket);
            }
            catch (Exception exception) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("SSLHTTPSRetriever: ErrorRetrieve " + request, exception);
                }
                object = null;
                if (cachedSocket == null) break block23;
                try {
                    cachedSocket.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementSSLSockets();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return object;
    }

    private CachedSocket createTunnelSocket(Request request) throws IOException {
        String string;
        byte[] byArray;
        Socket socket = new Socket(request.getProxyHost(), request.getProxyPort());
        if (PerfContextObject.ENABLE_PERF) {
            SocketCount.incrementPlainSockets();
        }
        String string2 = request.getProxyHost();
        String string3 = request.getRequestHeader("Proxy-Authorization");
        String string4 = null;
        if (string3 == null && (string4 = HTTPRetriever.getProxyPassword(string2)) != null) {
            request.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + string4);
        }
        OutputStream outputStream = socket.getOutputStream();
        String string5 = null;
        string5 = string4 == null ? "CONNECT " + request.getHost() + ":" + Integer.parseInt(request.getPort()) + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n" : "CONNECT " + request.getHost() + ":" + Integer.parseInt(request.getPort()) + " HTTP/1.0\n" + "Proxy-Authorization: Basic " + string4 + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            byArray = string5.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string5.getBytes();
        }
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        boolean bl2 = false;
        while (n2 < 2) {
            int n3 = inputStream.read();
            if (n3 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n3 == 10) {
                bl = true;
                ++n2;
                continue;
            }
            if (n3 == 13) continue;
            n2 = 0;
            if (bl || n >= byArray2.length) continue;
            byArray2[n++] = (byte)n3;
        }
        try {
            string = new String(byArray2, 0, n, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray2, 0, n);
        }
        if (!string.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through " + request.getProxyHost() + ":" + request.getProxyPort() + ".  Proxy returns \"" + string + "\"");
        }
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(socket, AuthContext.getDefault(), request.getHost(), Integer.parseInt(request.getPort()));
        return SSLCachedSSLSocketFactory.createSocket(sSLSocketImpl);
    }

    public void ForceSSLHandshake(Request request, CachedSocket cachedSocket) throws IOException {
        String string = DEFAULT_SSL_PORT;
        synchronized (string) {
            StringTokenizer stringTokenizer;
            int n;
            String string2 = request.getHost();
            currentReqHost = string2 != null ? ((n = (stringTokenizer = new StringTokenizer(string2, ".")).countTokens()) == 1 ? string2 + "." + rpSubdomain + rpDomain : (n == 2 ? string2 + rpDomain : string2)) : null;
            try {
                cachedSocket.getOutputStream().write(new byte[0]);
            }
            catch (IOException iOException) {
                currentReqHost = null;
                throw iOException;
            }
            currentReqHost = null;
        }
    }

    static {
        String string = SystemProperties.get("gateway.host", null);
        String string2 = "https://" + string + "/";
        if (string2 != null) {
            int n = string2.length();
            int n2 = string2.indexOf(46);
            if (n2 != -1 && n2 + 1 < n) {
                int n3 = string2.indexOf(46, n2 + 1);
                if (n3 == -1) {
                    rpSubdomain = string2.substring(n2 + 1);
                } else {
                    rpSubdomain = string2.substring(n2 + 1, n3);
                    rpDomain = string2.substring(n3);
                }
            }
        }
        doBasicAuthentication = false;
        doBasicAuthentication = GatewayProfile.getBoolean("DoBasicAuthentication", false) && ServiceIdentifier.isGateway();
    }
}

