/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.CipherMsg;
import com.sun.portal.netlet.econnection.ProxyMsgConstants;
import com.sun.portal.netlet.econnection.SizeConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ProxyCipherMsg
extends CipherMsg
implements ProxyMsgConstants,
SizeConstants {
    protected int srcPort;
    protected int hostNameLen;
    protected byte[] hostName;
    protected final int MAX_HOSTNAME_LEN = 255;
    protected final int MAX_PROXY_LEN = 263;
    protected int dstPortLen;
    protected byte[] dstPortList;

    public ProxyCipherMsg() {
        super((byte)1, (short)2);
    }

    public ProxyCipherMsg(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        super((byte)1, (short)2);
        if (n3 <= 255) {
            this.srcPort = n;
            this.dstPortLen = n2;
            this.dstPortList = new byte[n2];
            System.arraycopy(byArray, 0, this.dstPortList, 0, n2);
            this.hostNameLen = n3;
            this.hostName = new byte[n3];
            this.msgLen = 12 + n3 + n2;
            System.arraycopy(byArray2, 0, this.hostName, 0, n3);
        }
    }

    public int readMsg(DataInputStream dataInputStream) {
        int n = 0;
        n = this.readHeader(dataInputStream);
        if (n == 0) {
            if (this.msgLen > 0 && this.msgLen <= 263) {
                byte[] byArray = new byte[this.msgLen];
                try {
                    dataInputStream.readFully(byArray, 0, this.msgLen);
                    DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
                    this.srcPort = dataInputStream2.readInt();
                    this.dstPortLen = dataInputStream2.readInt();
                    this.dstPortList = new byte[this.dstPortLen];
                    this.hostNameLen = dataInputStream2.readInt();
                    if (this.hostNameLen > 512) {
                        n = -1;
                    } else {
                        this.hostName = new byte[this.hostNameLen];
                    }
                    dataInputStream2.readFully(this.dstPortList, 0, this.dstPortLen);
                    dataInputStream2.readFully(this.hostName, 0, this.hostNameLen);
                }
                catch (IOException iOException) {
                    System.out.println("ProxyMsg: IOE reading proxy info: " + iOException);
                    n = -1;
                }
            } else {
                n = -1;
            }
        }
        return n;
    }

    public int writeMsg(DataOutputStream dataOutputStream) {
        int n = 0;
        if (this.hostNameLen > 0 && this.hostNameLen < 255) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.msgLen);
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream2.writeInt(this.srcPort);
                dataOutputStream2.writeInt(this.dstPortLen);
                dataOutputStream2.writeInt(this.hostNameLen);
                byteArrayOutputStream.write(this.dstPortList, 0, this.dstPortLen);
                byteArrayOutputStream.write(this.hostName, 0, this.hostNameLen);
                byte[] byArray = new byte[this.msgLen];
                System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray, 0, this.msgLen);
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(274);
                int n2 = this.msgLen;
                this.writeHeaderToByteArray(byteArrayOutputStream2);
                byteArrayOutputStream2.write(byArray, 0, this.msgLen);
                byteArrayOutputStream2.writeTo(dataOutputStream);
                dataOutputStream.flush();
                this.msgLen = n2;
                byArray = null;
            }
            catch (IOException iOException) {
                System.out.println("ProxyMsg: IOE writing proxy info: " + iOException);
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    public byte[] getToDataStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(263);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.srcPort);
            dataOutputStream.writeInt(this.dstPortLen);
            dataOutputStream.writeInt(this.hostNameLen);
            byteArrayOutputStream.write(this.dstPortList, 0, this.dstPortLen);
            byteArrayOutputStream.write(this.hostName, 0, this.hostNameLen);
        }
        catch (IOException iOException) {
            System.out.println("ProxyMsg: IOE writing proxy info to data stream: " + iOException);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int setFromDataStream(byte[] byArray, int n) {
        int n2 = 0;
        if (n > 0 && n <= 263) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.msgLen = n;
                this.srcPort = dataInputStream.readInt();
                this.dstPortLen = dataInputStream.readInt();
                this.dstPortList = new byte[this.dstPortLen];
                this.hostNameLen = dataInputStream.readInt();
                if (this.hostNameLen > 512) {
                    n2 = -1;
                } else {
                    this.hostName = new byte[this.hostNameLen];
                }
                dataInputStream.readFully(this.dstPortList, 0, this.dstPortLen);
                dataInputStream.readFully(this.hostName, 0, this.hostNameLen);
            }
            catch (IOException iOException) {
                System.out.println("ProxyMsg: IOE reading proxy info from data stream: " + iOException);
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int n) {
        this.srcPort = n;
    }

    public String getDstPort() {
        return new String(this.dstPortList);
    }

    public String getHostName() {
        return new String(this.hostName);
    }

    public void setHostName(String string) {
        this.hostNameLen = 0;
        if (this.hostName != null) {
            this.hostName = null;
        }
        if (string.length() <= 255) {
            this.hostNameLen = string.length();
            this.hostName = new byte[this.hostNameLen];
            System.arraycopy(string, 0, this.hostName, 0, this.hostNameLen);
        }
    }
}

