/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.StringHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class URIHelper {
    public static final String COFFEE_SCHEME = "coffee";
    public static final String DATA_SCHEME = "data";
    public static final String FILE_SCHEME = "file";
    public static final String FTP_SCHEME = "ftp";
    public static final String GOPHER_SCHEME = "gopher";
    public static final String HNEWS_SCHEME = "hnews";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTP_NG_SCHEME = "http-ng";
    public static final String HTTPS_SCHEME = "https";
    public static final String IMAP_SCHEME = "imap";
    public static final String IRC_SCHEME = "irc";
    public static final String JAR_SCHEME = "jar";
    public static final String LDAP_SCHEME = "ldap";
    public static final String MAILTO_SCHEME = "mailto:";
    public static final String NEWS_SCHEME = "news";
    public static final String NFS_SCHEME = "nfs";
    public static final String NNTP_SCHEME = "nntp";
    public static final String POP_SCHEME = "pop";
    public static final String PROSPERO_SCHEME = "prospero";
    public static final String RWHOIS_SCHEME = "rwhois";
    public static final String SHTTP_SCHEME = "shttp";
    public static final String SMTP_SCHEME = "smtp";
    public static final String SNEWS_SCHEME = "snews";
    public static final String TELNET_SCHEME = "telnet";
    public static final String URN_SCHEME = "urn";
    public static final String VEMMI_SCHEME = "vemmi";
    public static final String VIDEOTEX_SCHEME = "videotex";
    public static final String WAIS_SCHEME = "wais";
    public static final String WHOIS_SCHEME = "whois";
    public static final String WHOIS_PLUS_SCHEME = "whois++";
    public static final String Z3950R_SCHEME = "z39.50r";
    public static final String Z3950S_SCHEME = "z39.50s";
    public static final int COFFEE_PORT = 80;
    public static final int FTP_PORT = 21;
    public static final int GOPHER_PORT = 70;
    public static final int HNEWS_PORT = 80;
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final int HTTP_NG_PORT = 80;
    public static final int IMAP_PORT = 143;
    public static final int IRC_PORT = 194;
    public static final int LDAP_PORT = 389;
    public static final int NNTP_PORT = 119;
    public static final int NEWS_PORT = 119;
    public static final int NFS_PORT = 2049;
    public static final int POP_PORT = 110;
    public static final int PROSPERO_PORT = 1525;
    public static final int RWHOIS_PORT = 4321;
    public static final int SHTTP_PORT = 80;
    public static final int SMTP_PORT = 25;
    public static final int SNEWS_PORT = 563;
    public static final int TELNET_PORT = 23;
    public static final int VEMMI_PORT = 575;
    public static final int VIDEOTEX_PORT = 516;
    public static final int WAIS_PORT = 210;
    public static final int WHOIS_PORT = 43;
    public static final int WHOIS_PLUS_PORT = 63;
    public static final int Z3950R_PORT = 210;
    public static final int Z3950S_PORT = 210;
    private static final HashMap protocolPorts = new HashMap(30);

    public static int getDefaultPort(String aProtocol) {
        int result = 0;
        Integer val = (Integer)protocolPorts.get(aProtocol.toLowerCase());
        if (val != null) {
            result = val;
        }
        return result;
    }

    public static Map parseQueryString(String aQuery) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        if (StringHelper.normalize(aQuery).length() == 0) {
            return hashMap;
        }
        StringBuffer stringbuffer = new StringBuffer(aQuery.length());
        StringTokenizer stringtokenizer = new StringTokenizer(aQuery, "&");
        while (stringtokenizer.hasMoreTokens()) {
            String[] lParamValueArray;
            String bToken = stringtokenizer.nextToken();
            int i = bToken.indexOf(61);
            if (i == -1) continue;
            String lParamName = URIHelper.parseName(bToken.substring(0, i), stringbuffer);
            String bParamValue = URIHelper.parseName(bToken.substring(i + 1, bToken.length()), stringbuffer);
            if (hashMap.containsKey(lParamName)) {
                String[] as1 = (String[])hashMap.get(lParamName);
                lParamValueArray = new String[as1.length + 1];
                int j = 0;
                while (j < as1.length) {
                    lParamValueArray[j] = as1[j];
                    ++j;
                }
                lParamValueArray[as1.length] = bParamValue;
            } else {
                lParamValueArray = new String[]{bParamValue};
            }
            hashMap.put(lParamName, lParamValueArray);
        }
        return hashMap;
    }

    private static String parseName(String aContent, StringBuffer aBuffer) {
        aBuffer.setLength(0);
        int i = 0;
        while (i < aContent.length()) {
            char c = aContent.charAt(i);
            switch (c) {
                case '+': {
                    aBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        aBuffer.append((char)Integer.parseInt(aContent.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException _ex) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException _ex) {
                        String s1 = aContent.substring(i);
                        aBuffer.append(s1);
                        if (s1.length() != 2) break;
                        ++i;
                        break;
                    }
                }
                default: {
                    aBuffer.append(c);
                }
            }
            ++i;
        }
        return aBuffer.toString();
    }

    static String deparameterize(String uri, Map parameters) {
        int i = uri.lastIndexOf(63);
        if (i == -1) {
            return uri;
        }
        String[] params = StringHelper.tokenize(uri.substring(i + 1), "&");
        int j = 0;
        while (j < params.length) {
            String p = params[j];
            int k = p.indexOf(61);
            if (k == -1) break;
            String name = p.substring(0, k);
            String value = p.substring(k + 1);
            parameters.put(name, value);
            ++j;
        }
        return uri.substring(0, i);
    }

    public static String parameterize(String aURI, Map aParams) {
        if (aURI == null || aURI.length() == 0 || aParams == null || aParams.size() == 0) {
            return aURI;
        }
        aURI = aURI.trim();
        StringBuffer buffer = new StringBuffer(aURI);
        int i = aURI.lastIndexOf(63);
        if (i == -1) {
            buffer.append('?');
        } else {
            buffer.append('&');
        }
        Iterator iterator = aParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            buffer.append('&');
        }
        return buffer.toString();
    }

    public static boolean needsToAppendDirectorySeperator(String aString) {
        if (aString == null) {
            return false;
        }
        boolean mayBeDirectory = false;
        if (aString.endsWith(".")) {
            mayBeDirectory = true;
            int i = aString.length() - 2;
            while (i >= 0) {
                char c = aString.charAt(i);
                if (c == '/') break;
                if (c != '.') {
                    mayBeDirectory = false;
                    break;
                }
                --i;
            }
        }
        return mayBeDirectory;
    }

    static {
        protocolPorts.put(HTTP_SCHEME, new Integer(80));
        protocolPorts.put(SHTTP_SCHEME, new Integer(80));
        protocolPorts.put(HTTPS_SCHEME, new Integer(443));
        protocolPorts.put(HTTP_NG_SCHEME, new Integer(80));
        protocolPorts.put(COFFEE_SCHEME, new Integer(80));
        protocolPorts.put(FTP_SCHEME, new Integer(21));
        protocolPorts.put(TELNET_SCHEME, new Integer(23));
        protocolPorts.put(NNTP_SCHEME, new Integer(119));
        protocolPorts.put(NEWS_SCHEME, new Integer(119));
        protocolPorts.put(SNEWS_SCHEME, new Integer(563));
        protocolPorts.put(HNEWS_SCHEME, new Integer(80));
        protocolPorts.put(SMTP_SCHEME, new Integer(25));
        protocolPorts.put(GOPHER_SCHEME, new Integer(70));
        protocolPorts.put(WAIS_SCHEME, new Integer(210));
        protocolPorts.put(WHOIS_SCHEME, new Integer(43));
        protocolPorts.put(WHOIS_PLUS_SCHEME, new Integer(63));
        protocolPorts.put(RWHOIS_SCHEME, new Integer(4321));
        protocolPorts.put(IMAP_SCHEME, new Integer(143));
        protocolPorts.put(POP_SCHEME, new Integer(110));
        protocolPorts.put(PROSPERO_SCHEME, new Integer(1525));
        protocolPorts.put(IRC_SCHEME, new Integer(194));
        protocolPorts.put(LDAP_SCHEME, new Integer(389));
        protocolPorts.put(Z3950R_SCHEME, new Integer(210));
        protocolPorts.put(Z3950S_SCHEME, new Integer(210));
        protocolPorts.put(VEMMI_SCHEME, new Integer(575));
        protocolPorts.put(VIDEOTEX_SCHEME, new Integer(516));
        protocolPorts.put(NFS_SCHEME, new Integer(2049));
    }
}

