/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ProxyCipherMsg;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.econnection.SessionKey;
import com.sun.portal.netlet.eproxy.NetletAccessController;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.netlet.eproxy.NetletProxyRouter;
import com.sun.portal.netlet.eproxy.RWGroupCrypt;
import com.sun.portal.netlet.eproxy.RWGroupForward;
import com.sun.portal.netlet.eproxy.RWGroupFtp;
import com.sun.portal.netlet.eproxy.Redirect;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.connectionhandler.Session;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.ServiceIdentifier;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLSocket;

public class ESession
implements KeyConstants,
Runnable {
    protected SessionRequest sessReq = null;
    protected SessionKey sKey;
    protected NetletProfile userProfile;
    protected ProxyCipherMsg pMsg;
    protected RWGroupCrypt rwg = null;
    protected RWGroupForward rwgf = null;
    protected RWGroupFtp rwgcf = null;
    protected Socket fromSock;
    protected DataInputStream fromClient;
    protected Integer logId;
    protected SessionAuthenticator sessionAuth;
    protected static boolean useNetletProxy = false;
    protected String netletProxyHost = null;
    protected int netletProxyPort = 10555;
    protected Hashtable cipherList = new Hashtable();
    public static final String NETLET_PROXY = "__sra_netlet_proxy__";
    private boolean validatePDC = false;
    private String digest = null;

    public ESession(Socket socket, Integer n) {
        try {
            this.fromClient = new DataInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("ESession: Unable to create DataInputStream -> ", iOException);
            }
            return;
        }
        this.logId = n;
        this.fromSock = socket;
        this.sessionAuth = new SessionAuthenticator();
    }

    public void run() {
        Object object;
        Object object2;
        SSOToken sSOToken;
        block56: {
            sSOToken = null;
            if (!this.readClientCertificate()) {
                this.cleanUp();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Unable to read Client Certificate: Closing Netlet Connections");
                }
                return;
            }
            if (this.readSessionId() != 0) {
                this.cleanUp();
                return;
            }
            if (this.sessionAuth.authenticate(this.sessReq) != 0) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: invalid session id");
                }
                this.cleanUp();
                return;
            }
            try {
                object2 = SSOTokenManager.getInstance();
                sSOToken = object2.createSSOToken(this.sessReq.getSessionID());
                object2.refreshSession(sSOToken);
                if (this.validatePDC && !this.verifyClientCertificate(sSOToken)) {
                    this.cleanUp();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Unable to verify Client Certificate: Closing Netlet Connections");
                    }
                    return;
                }
                this.userProfile = new NetletProfile(sSOToken.getTokenID().toString());
                object = NetletProfile.getStringList("Ciphers");
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < object.size()) {
                    stringBuffer.append((String)object.get(n)).append("|");
                    ++n;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "|");
                while (stringTokenizer.hasMoreElements()) {
                    this.cipherList.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                }
            }
            catch (SSOException sSOException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + (Object)((Object)sSOException));
                }
            }
            catch (GetResponseException getResponseException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + getResponseException);
                }
            }
            catch (SendRequestException sendRequestException) {
                if (!GWDebug.debug.errorEnabled()) break block56;
                GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + sendRequestException);
            }
        }
        if (useNetletProxy) {
            block57: {
                object2 = this.sessReq.getSessionID();
                try {
                    this.netletProxyHost = this.getAssociatedNetletProxy(sSOToken);
                }
                catch (SSOException sSOException) {
                    sSOException.printStackTrace();
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Invalid SSOToken while looking op NLP -> " + (Object)((Object)sSOException));
                    }
                    return;
                }
                object = null;
                try {
                    object = new URL(this.netletProxyHost);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                this.netletProxyHost = ((URL)object).getHost();
                int n = ((URL)object).getPort();
                if (n != -1) {
                    this.netletProxyPort = n;
                }
                object = null;
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("ESession: Netlet proxy host -> " + this.netletProxyHost + " port -> " + this.netletProxyPort);
                }
                this.rwgf = new RWGroupForward(this.fromSock, this.netletProxyHost, this.netletProxyPort, (String)object2);
                try {
                    NetletGroupManager.getNetletGroupManager();
                    NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgf, (String)object2);
                }
                catch (SSOException sSOException) {
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.unregister((String)object2);
                    }
                    catch (Exception exception) {
                        if (!GWDebug.debug.errorEnabled()) break block57;
                        GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                    }
                }
            }
            String string = GWLocale.getPFString("es1", new Object[]{this.logId, new String(GWLogManager.getUserId((String)object2)), this.netletProxyHost, new Integer(this.netletProxyPort)});
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("netlet", string);
            }
        } else {
            object2 = new NetletAccessController(this.userProfile);
            try {
                this.pMsg = new ProxyCipherMsg();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (this.pMsg.readMsg(this.fromClient) == 0) {
                String string;
                block58: {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ESession: srcPort -> " + this.pMsg.getSrcPort());
                    }
                    if (((Redirect)(object = new Redirect(this.pMsg.getSrcPort(), this.sessReq))).doRedirect()) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("ESession: redirect to -> " + ((Redirect)object).getDstPortList() + " " + ((Redirect)object).getDstHost());
                        }
                        string = GWLocale.getPFString("es2", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), ((Redirect)object).getDstHost(), ((Redirect)object).getDstPortList()});
                        if (!((NetletAccessController)object2).isAccessAllowed(((Redirect)object).getDstHost())) {
                            this.cleanUp();
                            return;
                        }
                        this.rwg = new RWGroupCrypt(this.fromSock, this.pMsg.getSrcPort(), ((Redirect)object).getDstPortList(), ((Redirect)object).getDstHost(), this.sessionAuth, this.sessReq);
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                        }
                        catch (SSOException sSOException) {
                            try {
                                NetletGroupManager.getNetletGroupManager();
                                NetletGroupManager.unregister(this.sessReq.getSessionID());
                                break block58;
                            }
                            catch (Exception exception) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                                }
                                break block58;
                            }
                        }
                    }
                    if (this.pMsg.getDstPort().equals("-1")) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("ESession: FTP data connection to -> " + ((Redirect)object).getDstHost());
                        }
                        string = GWLocale.getPFString("es4", new Object[]{this.logId, ((Redirect)object).getDstHost()});
                        this.rwgcf = new RWGroupFtp(this.fromSock, this.sessionAuth, this.sessReq);
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgcf, this.sessReq.getSessionID());
                        }
                        catch (SSOException sSOException) {
                            try {
                                NetletGroupManager.getNetletGroupManager();
                                NetletGroupManager.unregister(this.sessReq.getSessionID());
                                break block58;
                            }
                            catch (Exception exception) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                                }
                                break block58;
                            }
                        }
                    }
                    string = GWLocale.getPFString("es3", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), this.pMsg.getHostName(), this.pMsg.getDstPort()});
                    if (!((NetletAccessController)object2).isAccessAllowed(this.pMsg.getHostName())) {
                        this.cleanUp();
                        return;
                    }
                    this.rwg = new RWGroupCrypt(this.fromSock, this.pMsg.getSrcPort(), this.pMsg.getDstPort(), this.pMsg.getHostName(), this.sessionAuth, this.sessReq);
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                    }
                    catch (SSOException sSOException) {
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.unregister(this.sessReq.getSessionID());
                        }
                        catch (Exception exception) {
                            if (!GWDebug.debug.errorEnabled()) break block58;
                            GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                        }
                    }
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("netlet", string);
                }
            } else if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("ESession: unable to get proxy config!");
            }
            this.pMsg = null;
        }
    }

    public void stop() {
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.fromSock != null) {
            try {
                block5: {
                    try {
                        this.fromSock.close();
                        if (!PerfContextObject.ENABLE_PERF) break block5;
                        SocketCount.decrementPlainSockets();
                    }
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        this.fromSock = null;
                    }
                }
                Object var3_1 = null;
                this.fromSock = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.fromSock = null;
                throw throwable;
            }
        }
    }

    public String getSessionID() {
        return this.sessReq.getSessionID();
    }

    public byte[] getSessionKey() {
        byte[] byArray = new byte[32];
        System.arraycopy(this.sKey.getSessionKey(), 0, byArray, 0, 32);
        return byArray;
    }

    public boolean isDone() {
        if (this.rwg != null) {
            return this.rwg.isDone();
        }
        if (this.rwgf != null) {
            return this.rwgf.isDone();
        }
        if (this.rwgcf != null) {
            return this.rwgcf.isDone();
        }
        return this.fromSock == null;
    }

    private int readSessionId() {
        if (this.sessReq == null) {
            this.sessReq = new SessionRequest();
        }
        if (this.sessReq.readMsg(this.fromClient) == 0) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ESession: sessId = " + this.sessReq.getSessionID());
            }
        } else {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ESession: negotiateSessionId IOException");
            }
            return -1;
        }
        return 0;
    }

    private String getAssociatedNetletProxy(SSOToken sSOToken) throws SSOException {
        String string = sSOToken.getProperty(NETLET_PROXY);
        if (string == null) {
            string = NetletProxyRouter.getNetletProxyAlive();
            if (string == null) {
                return NetletProxyRouter.getServer();
            }
            sSOToken.setProperty(NETLET_PROXY, string);
            return string;
        }
        if (NetletProxyRouter.isNetletProxyAlive(string)) {
            return string;
        }
        string = NetletProxyRouter.getNetletProxyAlive();
        if (string == null) {
            return NetletProxyRouter.getServer();
        }
        sSOToken.setProperty(NETLET_PROXY, string);
        return string;
    }

    private boolean readClientCertificate() {
        if (!(this.fromSock instanceof SSLSocket)) {
            return true;
        }
        if (!Session.doingPDC) {
            return true;
        }
        try {
            X509Certificate x509Certificate = ((SSLSocket)this.fromSock).getStatus().getPeerCertificate();
            byte[] byArray = x509Certificate.getEncoded();
            String string = JSSUtil.getDefaultDecoder().getEncodedStr(byArray);
            this.digest = JSSUtil.getDefaultDecoder().digest(string);
        }
        catch (Exception exception) {
            GWDebug.debug.error("Netlet : Unable to get client cert");
            return false;
        }
        return false;
    }

    private boolean verifyClientCertificate(SSOToken sSOToken) {
        String string = null;
        if (this.digest == null || this.digest.trim().length() == 0) {
            return false;
        }
        try {
            string = sSOToken.getProperty("__sra_pdc_cert__");
        }
        catch (SSOException sSOException) {
            GWDebug.debug.error("Netlet : Unable to get certificate digest", sSOException);
            return false;
        }
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return this.digest.equals(string);
    }

    static {
        useNetletProxy = GatewayProfile.getBoolean("UseNetletProxy", false) && ServiceIdentifier.isGateway();
    }
}

