/*
 * Decompiled with CFR 0.152.
 */
package ob.listbox;

import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import ob.listbox.ListItem;
import ob.listbox.SortableListBox;

public class SearchableListBox
extends SortableListBox {
    String m_strCurrentSearchString = "";

    public SearchableListBox(boolean bMultipleSelections) {
        super(bMultipleSelections);
    }

    public SearchableListBox() {
        this(false);
    }

    public void setSearchString(String newSearch) {
        this.m_strCurrentSearchString = newSearch;
    }

    public int search(String strSearch) {
        if (this.m_nColumnSorted != 0) {
            this.sort();
        }
        if (strSearch == null || strSearch.length() == 0) {
            return 0;
        }
        int nSearchLength = strSearch.length();
        int maximumLocation = this.m_arrItems.size() - 1;
        int minimumLocation = 0;
        while (maximumLocation > minimumLocation) {
            int middle = (maximumLocation + minimumLocation) / 2;
            ListItem currentItem = (ListItem)this.m_arrItems.elementAt(middle);
            String currentString = currentItem.getText().toUpperCase();
            if (currentString.startsWith(strSearch.toUpperCase())) {
                int tempMiddle = middle;
                while (currentString.startsWith(strSearch.toUpperCase()) && tempMiddle >= 0) {
                    if (--tempMiddle == -1) continue;
                    currentString = ((ListItem)this.m_arrItems.elementAt(tempMiddle)).getText().toUpperCase();
                }
                return tempMiddle + 1;
            }
            if (currentString.compareTo(strSearch.toUpperCase()) > 0) {
                maximumLocation = middle - 1;
                continue;
            }
            minimumLocation = middle + 1;
        }
        if (((ListItem)this.m_arrItems.elementAt(minimumLocation)).getText().toUpperCase().startsWith(strSearch.toUpperCase())) {
            return minimumLocation;
        }
        return this.search(strSearch.substring(0, strSearch.length() - 1));
    }

    protected void changeItemText() {
        super.changeItemText();
        this.m_nColumnSorted = -1;
    }

    protected void processKeyEvent(KeyEvent e) {
        int key = e.getKeyCode();
        String keyChar = KeyEvent.getKeyText(key);
        if (e.getID() == 401) {
            if (!e.isActionKey() && key != 8 && keyChar.length() == 1) {
                int searchIndex;
                this.m_strCurrentSearchString = this.m_strCurrentSearchString.concat(keyChar);
                this.prev = searchIndex = this.search(this.m_strCurrentSearchString);
                this.selected = new int[0];
                this.select(searchIndex, false);
                this.scrollToView(searchIndex);
                this.update();
                this.processItemEvent(new ItemEvent(this, 701, this.getItem(searchIndex), 1));
            } else if (key == 8) {
                int searchIndex;
                int nIndex = this.m_strCurrentSearchString.length() - 1;
                if (nIndex < 0) {
                    nIndex = 0;
                }
                this.m_strCurrentSearchString = this.m_strCurrentSearchString.substring(0, nIndex);
                this.prev = searchIndex = this.search(this.m_strCurrentSearchString);
                this.selected = new int[0];
                this.select(searchIndex);
                this.scrollToView(searchIndex);
                this.update();
                this.processItemEvent(new ItemEvent(this, 701, this.getItem(searchIndex), 1));
            }
        }
        super.processKeyEvent(e);
    }
}

