/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.jsp.JSPProvider;
import com.sun.portal.providers.jsp.JspServletEnvironment;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

class JspRequestDispatcher
implements RequestDispatcher {
    private JspServletEnvironment jspEnv;
    private ProviderContext providerContext;
    private String path;
    private String baseuri;

    public JspRequestDispatcher(String path, JspServletEnvironment jspEnv) {
        this.path = path;
        this.baseuri = path;
        this.jspEnv = jspEnv;
        this.providerContext = ProviderContextThreadLocalizer.get();
        int index = path.indexOf(63);
        if (index != -1) {
            this.baseuri = path.substring(0, index);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.path.length() == 0 || this.path == null) {
            return;
        }
        StringBuffer icontent = new StringBuffer();
        try {
            icontent = this.baseuri.endsWith(".jsp") ? this.getJspResource(request, response) : this.getStaticResource();
        }
        catch (ServletException se) {
            Throwable rootCause = se.getRootCause();
            if (rootCause != null) {
                this.providerContext.debugError("JspRequestDispatcher: error in " + this.baseuri, rootCause);
            } else {
                this.providerContext.debugError("JspRequestDispatcher:", se);
            }
            return;
        }
        if (icontent != null) {
            PrintWriter pw = response.getWriter();
            pw.print(icontent.toString());
            pw.flush();
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.include(request, response);
    }

    private StringBuffer getJspResource(ServletRequest request, ServletResponse response) throws ServletException {
        Hashtable parameters = this.getRequestParameters(request);
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        StringBuffer buffer = new StringBuffer();
        JSPProvider jp = (JSPProvider)hrequest.getAttribute("com.sun.portal.providers.jsp.JSPProvider");
        if (jp != null) {
            try {
                buffer = jp.includeJspPage(this.path, parameters, hrequest, hresponse);
            }
            catch (ProviderException pe) {
                throw new ServletException("Problem processing JSP: " + this.path, (Throwable)pe);
            }
            catch (Exception e) {
                throw new ServletException("Problem processing JSP: " + this.path, (Throwable)e);
            }
        }
        return buffer;
    }

    private StringBuffer getStaticResource() throws ServletException {
        StringBuffer buffer = new StringBuffer();
        try {
            FileReader fr = new FileReader(this.jspEnv.getRealPath(this.path));
            char[] c = new char[4096];
            int read = 0;
            while ((read = fr.read(c)) != -1) {
                buffer.append(c, 0, read);
            }
            fr.close();
        }
        catch (FileNotFoundException fnf) {
            throw new ServletException("File Not Found: " + this.path, (Throwable)fnf);
        }
        catch (IOException ioe) {
            throw new ServletException("Problem processing file: " + this.path, (Throwable)ioe);
        }
        catch (Exception e) {
            throw new ServletException("Problem processing file: " + this.path, (Throwable)e);
        }
        return buffer;
    }

    private Hashtable getRequestParameters(ServletRequest req) throws ServletException {
        Hashtable parameters = new Hashtable();
        int index = this.path.indexOf(63);
        String qstring = null;
        if (index != -1) {
            qstring = this.path.substring(index + 1);
            try {
                parameters = HttpUtils.parseQueryString((String)qstring);
            }
            catch (IllegalArgumentException e) {
                throw new ServletException("Problem parsing query string:" + qstring, (Throwable)e);
            }
            catch (Exception e) {
                throw new ServletException("Problem parsing query string:" + qstring, (Throwable)e);
            }
        }
        Enumeration pe = req.getParameterNames();
        while (pe.hasMoreElements()) {
            String pname = (String)pe.nextElement();
            parameters.put(pname, req.getParameterValues(pname));
        }
        return parameters;
    }
}

