/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.jsp.JspFactoryImpl;
import com.sun.portal.providers.jsp.JspServletEnvironment;
import com.sun.portal.providers.jsp.JspServletWrapper;
import com.sun.portal.providers.jsp.JspSession;
import com.sun.portal.providers.jsp.Request;
import com.sun.portal.providers.jsp.Response;
import com.sun.portal.providers.jsp.jasper3.jasper.JspFactory;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPProvider
extends ProfileProviderAdapter {
    private static HashMap cachedJsps = new HashMap();
    private static JspFactory theJspFactory = new JspFactoryImpl();
    private static String jspCompilerClassPath = null;
    JspSession jspsession = new JspSession();
    JspServletEnvironment jspEnv = null;
    JspServletWrapper contentWrapper = null;
    JspServletWrapper editWrapper = null;
    JspServletWrapper processWrapper = null;
    private Boolean isPresentable = null;
    private String providerClassDir = null;

    public void init(String n, HttpServletRequest httpreq) throws ProviderException {
        super.init(n, httpreq);
        String clientType = null;
        String clientPath = null;
        clientType = this.getProviderContext().getClientType();
        if (clientType != null) {
            clientPath = this.getProviderContext().getClientProperty("filePath");
        }
        DesktopContext dc = DesktopContextThreadLocalizer.get();
        String jspScratchDir = dc.getJSPScratchDir();
        this.providerClassDir = dc.getProviderClassBaseDir();
        if (jspCompilerClassPath == null) {
            String jspCompilerWARClassPath = (String)this.getProviderContext().getServletConfig().getServletContext().getAttribute("com.iplanet.server.http.servlet.classpath");
            if (jspCompilerWARClassPath == null) {
                jspCompilerWARClassPath = dc.getJSPCompilerWARClassPath();
            }
            if (jspCompilerWARClassPath == null) {
                throw new ProviderException("JSPProvider.init(): couldn't get WAR class path");
            }
            JSPProvider.initCompilerCP(jspCompilerWARClassPath);
        }
        String desktopType = dc.getDesktopType();
        String userLocale = dc.getLocaleString();
        this.jspEnv = new JspServletEnvironment(this, this.getName(), jspScratchDir, desktopType, userLocale, clientPath, jspCompilerClassPath);
        if (!this.getProviderContext().isAuthless(httpreq)) {
            this.isPresentable = this.isPresentable(httpreq) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static synchronized void initCompilerCP(String jspCompilerWARClassPath) {
        String javaClassPath = System.getProperties().getProperty("java.class.path");
        int len = 0;
        if (javaClassPath != null) {
            len = jspCompilerWARClassPath.length() + javaClassPath.length() + 1;
            jspCompilerClassPath = new StringBuffer(len).append(jspCompilerWARClassPath).append(File.pathSeparatorChar).append(javaClassPath).toString();
        } else {
            jspCompilerClassPath = jspCompilerWARClassPath;
        }
    }

    public boolean isPresentable(HttpServletRequest req) {
        boolean ip = false;
        if (this.isPresentable != null) {
            ip = this.isPresentable;
        } else {
            ip = this.contentPageExists();
            if (!ip) {
                ip = super.isPresentable(req);
            }
        }
        return ip;
    }

    private boolean contentPageExists() {
        boolean exists = false;
        try {
            String jsp = this.getStringProperty("contentPage");
            if (jsp.length() != 0) {
                File fullJspPath;
                int index = jsp.indexOf(63);
                String uri = jsp;
                if (index != -1) {
                    uri = jsp.substring(0, index);
                }
                if ((fullJspPath = this.getExistingJSPPath(this.getProviderContext(), this.getName(), uri)) != null) {
                    exists = true;
                }
            }
        }
        catch (ProviderException providerException) {
            // empty catch block
        }
        return exists;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String jsp = this.getStringProperty("contentPage");
        boolean showExceptions = this.getBooleanProperty("showExceptions");
        if (jsp.length() == 0 || jsp == null) {
            return super.getContent(req, res);
        }
        try {
            Response jres;
            if (this.contentWrapper == null || this.contentWrapper.expired() || !this.contentWrapper.getURI().equals(jsp)) {
                this.contentWrapper = this.getJspWrapper(jsp);
            }
            if ((jres = this.processJspFile(this.contentWrapper, req, res)).getStatus() == 200) {
                return jres.getBody();
            }
            throw new ProviderException(this.getName() + ": contentPage JSP=" + jsp + ", status code=" + jres.getStatus());
        }
        catch (ProviderException pe) {
            return this.handleException(pe);
        }
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String jsp = this.getStringProperty("editPage");
        if (jsp.length() == 0 || jsp == null) {
            return super.getEdit(req, res);
        }
        try {
            Response jres;
            if (this.editWrapper == null || this.editWrapper.expired() || !this.editWrapper.getURI().equals(jsp)) {
                this.editWrapper = this.getJspWrapper(jsp);
            }
            if ((jres = this.processJspFile(this.editWrapper, req, res)).getStatus() == 200) {
                return jres.getBody();
            }
            throw new ProviderException(this.getName() + ": editPage JSP=" + jsp + ", status code=" + jres.getStatus());
        }
        catch (ProviderException pe) {
            return this.handleException(pe);
        }
    }

    private StringBuffer handleException(ProviderException pe) throws ProviderException {
        if (this.getBooleanProperty("showExceptions")) {
            ProviderException e = pe;
            StringWriter swriter = new StringWriter(256);
            PrintWriter buf = new PrintWriter((Writer)swriter, true);
            buf.println("<div align=left><b>");
            buf.println(e.getMessage());
            buf.println("</b><p><pre>");
            ((Throwable)e).printStackTrace(buf);
            buf.println("</pre></div>");
            buf.flush();
            return swriter.getBuffer();
        }
        throw pe;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Response jres;
        String jsp = this.getStringProperty("processPage");
        if (jsp.length() == 0 || jsp == null) {
            return super.processEdit(req, res);
        }
        if (this.processWrapper == null || this.processWrapper.expired() || !this.processWrapper.getURI().equals(jsp)) {
            this.processWrapper = this.getJspWrapper(jsp);
        }
        if ((jres = this.processJspFile(this.processWrapper, req, res)).getStatus() == 302) {
            try {
                return jres.getLocation();
            }
            catch (MalformedURLException mue) {
                throw new ProviderException(this.getName() + ": invalid URL from processPage JSP", mue);
            }
        }
        if (jres.getStatus() == 200) {
            return null;
        }
        throw new ProviderException(this.getName() + ": processPage JSP=" + jsp + ", status code: " + jres.getStatus());
    }

    private JspServletWrapper getJspWrapper(String jsp) throws ProviderException {
        int index = jsp.indexOf(63);
        String uri = jsp;
        if (index != -1) {
            uri = jsp.substring(0, index);
        }
        try {
            String fullJspPath = this.jspEnv.getRealPath(uri);
            String mostSpecificJspPath = this.getMostSpecificJSPPath(this.getProviderContext(), this.getName(), uri).toString();
            if (fullJspPath == null) {
                throw new ProviderException("JSP file not found: " + uri);
            }
            ProviderClassLoader pcl = ProviderClassLoader.getInstance(this.providerClassDir);
            JspServletWrapper wrapper = (JspServletWrapper)cachedJsps.get(mostSpecificJspPath);
            if (wrapper != null && wrapper.getProviderClassLoader() != pcl) {
                wrapper = null;
            }
            if (wrapper == null) {
                int scanInterval = 0;
                if (DesktopAppContextThreadLocalizer.exists()) {
                    DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
                    scanInterval = dac.getTemplateScanInterval();
                }
                HashMap hashMap = cachedJsps;
                synchronized (hashMap) {
                    wrapper = (JspServletWrapper)cachedJsps.get(mostSpecificJspPath);
                    if (wrapper != null && wrapper.getProviderClassLoader() != pcl) {
                        wrapper = null;
                    }
                    if (wrapper == null) {
                        wrapper = new JspServletWrapper(jsp, uri, fullJspPath, mostSpecificJspPath, this.jspEnv, scanInterval, pcl);
                        cachedJsps.put(mostSpecificJspPath, wrapper);
                    }
                }
            } else {
                wrapper.setFullJspFile(fullJspPath);
            }
            return wrapper;
        }
        catch (Throwable t) {
            throw new ProviderException("JSPProvider.getJspWrapper(): jsp=" + jsp + ", ", t);
        }
    }

    private Response processJspFile(JspServletWrapper jsp, HttpServletRequest hsreq, HttpServletResponse hsres) throws ProviderException {
        Hashtable<String, String[]> parameters = new Hashtable<String, String[]>();
        Enumeration pe = hsreq.getParameterNames();
        while (pe.hasMoreElements()) {
            String pname = (String)pe.nextElement();
            parameters.put(pname, hsreq.getParameterValues(pname));
        }
        return this.processJspFile(jsp, hsreq, hsres, parameters, hsreq.getCookies(), new HashMap());
    }

    private Response processJspFile(JspServletWrapper wrapper, HttpServletRequest origReq, HttpServletResponse origRes, Hashtable params, Cookie[] ca, Map attributes) throws ProviderException {
        String pathInfo = origReq.getPathInfo();
        String origURI = origReq.getRequestURI();
        int start = origURI.indexOf(59);
        String semiData = null;
        if (start != -1) {
            semiData = origURI.substring(start);
        }
        String jsp = wrapper.getURI();
        if (semiData != null) {
            jsp = jsp + semiData;
        }
        if (pathInfo != null) {
            jsp = jsp + pathInfo;
        }
        Request req = new Request(origReq, this.jspsession, params, ca, attributes, jsp);
        Response res = new Response(req, origRes, this.getProviderContext());
        req.setAttribute("com.sun.portal.providers.jsp.JSPProvider", this);
        JspFactory deffact = JspFactory.getPsFactory();
        if (deffact != theJspFactory) {
            JspFactory.setPsFactory((JspFactory)theJspFactory);
        }
        try {
            wrapper.service(req, res);
        }
        catch (RuntimeException e) {
            throw new ProviderException("JSPProvider.getName(): ", e);
        }
        catch (ServletException e) {
            Throwable t = e.getRootCause();
            if (t == null) {
                t = e;
            }
            if (t instanceof ProviderException) {
                ProviderException pe = (ProviderException)t;
                throw pe;
            }
            throw new ProviderException("JSPProvider.processJSPFile(): jsp=" + jsp + ", ", t);
        }
        catch (Throwable t) {
            throw new ProviderException("JSPProvider.processJSPFile(): jsp=" + jsp + ", ", t);
        }
        return res;
    }

    protected StringBuffer includeJspPage(String jsp, Hashtable parameters, HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        if (jsp.length() == 0 || jsp == null) {
            return new StringBuffer();
        }
        try {
            Request request = (Request)req;
            Response jres = this.processJspFile(this.getJspWrapper(jsp), req, res, parameters, req.getCookies(), request.getAttributes());
            if (jres.getStatus() == 200) {
                return jres.getBody();
            }
            throw new ProviderException(this.getName() + ": include JSP=" + jsp + ", status code=" + jres.getStatus());
        }
        catch (ProviderException pe) {
            return this.handleException(pe);
        }
    }

    protected File getMostSpecificJSPPath(ProviderContext pc, String channel, String file) throws ProviderException {
        try {
            return pc.getTemplateMostSpecificPath(channel, file);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPProvider.getTemplateMostSpecificPath(): file= " + file + ", ", pce);
        }
    }

    protected File getExistingJSPPath(ProviderContext pc, String channel, String file) throws ProviderException {
        try {
            return pc.getTemplatePath(channel, file);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPProvider.getTemplatePath(): file= " + file + ", ", pce);
        }
    }
}

