/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.common.pool.PartitionObject;
import com.sun.common.util.LockWithMemory;
import com.sun.portal.desktop.DesktopThreadLocalManager;
import com.sun.portal.desktop.PerfData;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.context.ProviderGetterPool;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.context.ContainerProviderContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReusableProviderGetter
extends Thread
implements PartitionObject {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private HttpServletRequest origRequest = null;
    private HttpServletResponse origResponse = null;
    private ContainerProviderContext providerContext = null;
    private Provider provider = null;
    private String providerName = null;
    private String parent = null;
    private Monitor monitor = null;
    private boolean initialized = false;
    private boolean running = true;
    private LockWithMemory begin = new LockWithMemory();
    private LockWithMemory end = new LockWithMemory();
    private boolean executing = false;
    private ProviderGetterPool pool = null;
    private DesktopAppContext desktopAppContext = null;
    private DesktopContext desktopContext = null;
    private ServletConfig servletConfig = null;
    private PerfData perfData = null;
    private int partition = 0;

    public ReusableProviderGetter() {
        this.setDaemon(true);
        this.desktopAppContext = DesktopAppContextThreadLocalizer.get();
    }

    void init(DesktopAppContext dac, DesktopContext dc, ContainerProviderContext cpc, String parent, String providerName, Monitor m, HttpServletRequest req, HttpServletResponse res, HttpServletRequest origReq, HttpServletResponse origRes, ServletConfig sc, PerfData pd, ProviderGetterPool getterPool) {
        this.providerContext = cpc;
        this.monitor = m;
        this.request = req;
        this.response = res;
        this.origRequest = origReq;
        this.origResponse = origRes;
        this.parent = parent;
        this.providerName = providerName;
        this.desktopAppContext = dac;
        this.desktopContext = dc;
        this.servletConfig = this.servletConfig;
        this.perfData = this.perfData;
        this.pool = getterPool;
        this.initialized = true;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public int getPartition() {
        return this.partition;
    }

    void clear() {
        this.initialized = false;
        this.providerContext = null;
        this.monitor = null;
        this.parent = null;
        this.providerName = null;
        this.request = null;
        this.response = null;
        this.origRequest = null;
        this.origResponse = null;
        this.desktopAppContext = null;
        this.desktopContext = null;
        this.servletConfig = null;
        this.perfData = null;
    }

    public void execute() {
        this.begin.signal();
        this.executing = true;
    }

    void finish() {
        this.running = false;
        this.begin.signal();
    }

    public void run() {
        while (true) {
            try {
                if (!this.running) break;
                try {
                    try {
                        this.begin.waitFor();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    if (!this.running) {
                        return;
                    }
                    Object name = null;
                    DesktopThreadLocalManager.init(this.desktopAppContext, this.request, this.response, this.origRequest, this.origResponse, this.servletConfig, this.perfData);
                    DesktopThreadLocalManager.init(this.desktopContext, this.providerContext);
                    try {
                        if (!this.initialized) {
                            throw new ContextError("ProviderGetter.run(): attmpted un-initialized loop!");
                        }
                        ProviderContextThreadLocalizer.set(this.providerContext);
                        this.provider = this.providerContext.getProvider(this.request, this.parent, this.providerName);
                        this.monitor.put(this.providerName, this.provider);
                        this.providerContext.debugMessage("ProviderGetter.run(): finished " + this.providerName);
                    }
                    catch (Throwable e) {
                        this.providerContext.debugError("ProviderGetter.run(): failed providerName=" + this.providerName, e);
                        this.monitor.put(this.providerName, null);
                    }
                    this.end.signal();
                    DesktopThreadLocalManager.release();
                    this.executing = false;
                    this.pool.releaseGetter(this);
                }
                catch (Throwable t1) {
                    throw new ContextError("ProviderGetter.run()", t1);
                }
            }
            catch (Throwable t2) {
                throw new ContextError("ProviderGetter.run()", t2);
            }
        }
    }
}

