/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.transport;

import com.sun.portal.netfile.shared.NetFileException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class NetFileRequest
implements Serializable {
    private String userId;
    private int requestType;
    private String sessionId;
    private Hashtable nfReqParams;
    private String requestId;
    private Object reqObject;

    public void setParameters(Hashtable params) throws NetFileException {
        if (params == null) {
            throw new NetFileException(3, "Request Parameters is null");
        }
        this.nfReqParams = params;
    }

    public Object getRequestObject() {
        return this.reqObject;
    }

    public Enumeration getRequestParamNames() {
        return this.nfReqParams.keys();
    }

    public Enumeration getRequestParamVals() {
        return this.nfReqParams.elements();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestParams(Hashtable params) {
        this.nfReqParams = params;
    }

    public void setSessionId(String sessId) {
        if (sessId != null) {
            this.sessionId = sessId;
        }
    }

    public Object getRequestParams() {
        return this.nfReqParams;
    }

    public NetFileRequest(String reqId, String sess, String uid, int reqType) {
        if (reqId != null && sess != null) {
            this.requestId = reqId;
            this.sessionId = sess;
            this.userId = uid;
            this.requestType = reqType;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setParameter(String name, Object value) throws NetFileException {
        if (name != null && value != null) {
            if (this.nfReqParams == null) {
                this.nfReqParams = new Hashtable();
            }
        } else {
            throw new NetFileException(3, "Null value in request parameter key and/or value");
        }
        this.nfReqParams.put(name, value);
    }

    public void setRequestId(String reqId) {
        if (reqId != null) {
            this.requestId = reqId;
        }
    }

    public Object getParameter(String key) throws NetFileException {
        if (key != null) {
            return this.nfReqParams.get(key);
        }
        throw new NetFileException(3, "Null value in key");
    }

    public void setRequestType(int reqType) {
        if (reqType > 0) {
            this.requestType = reqType;
        }
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setUserId(String user) {
        if (user != null) {
            this.userId = user;
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setRequestObject(Object obj) throws NetFileException {
        if (obj == null) {
            throw new NetFileException(3, "Additional request object cannot be set to null");
        }
        this.reqObject = obj;
    }
}

