/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPLocale;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPProperty;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XMLDPLocale
extends XMLDPCollection
implements DPLocale,
XMLDPTags {
    XMLDPLocale(DPContext dpc, DPRoot r, Document d, String name) {
        this(dpc, r, XMLDPObject.createElement(dpc, d, name));
    }

    XMLDPLocale(DPContext dpc, DPRoot r, Document d, String lang, String country, String variant) {
        this(dpc, r, XMLDPLocale.createElement(dpc, d, lang, country, variant));
    }

    XMLDPLocale(DPContext dpc, DPRoot r, Document d, String lang, String country, String variant, Map m) {
        this(dpc, r, XMLDPLocale.createElement(dpc, r, d, lang, country, variant, m));
    }

    XMLDPLocale(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
    }

    public short getType() {
        return 15;
    }

    public String getTag() {
        return "Locale";
    }

    public String getLanguage() {
        return this.getElement().getAttribute("language");
    }

    public String getCountry() {
        return this.getElement().getAttribute("country");
    }

    public String getVariant() {
        return this.getElement().getAttribute("variant");
    }

    protected Element getMergedElement() {
        Map map = this.getCollectionValue();
        Element e = XMLDPLocale.createElement(this.getContext(), this.getRoot(), this.getDocument(), this.getLanguage(), this.getCountry(), this.getVariant(), map);
        return e;
    }

    static Element createElement(DPContext dpc, Document d, String lang, String country, String variant) {
        Element e = XMLDPObject.createElement(dpc, d, "Locale");
        if (lang == null || lang.length() <= 0) {
            throw new DPError("XMLDPLocale.createElement(): language was null in Locale");
        }
        e.setAttribute("language", lang);
        if (country != null) {
            e.setAttribute("country", country);
        }
        if (variant != null) {
            e.setAttribute("variant", variant);
        }
        XMLDPCollection.setDefaultsElement(e);
        return e;
    }

    private static Element createElement(DPContext dpc, DPRoot r, Document d, String lang, String country, String variant, Map m) {
        Element e = XMLDPLocale.createElement(dpc, d, lang, country, variant);
        XMLDPFactory factory = XMLDPFactory.getInstance();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object o = m.get(name);
            DPProperty dpp = factory.createProperty(dpc, r, d, name, o);
            XMLDPProperty xmlDPP = (XMLDPProperty)dpp;
            Element newElement = xmlDPP.getElement();
            e.appendChild(newElement);
        }
        XMLDPCollection.setDefaultsElement(e);
        return e;
    }

    public void appendLanguageAttr(StringBuffer b) {
        b.append(" language=\"").append(this.getLanguage()).append("\"");
    }

    public void appendCountryAttr(StringBuffer b) {
        b.append(" country=\"").append(this.getCountry()).append("\"");
    }

    public void appendVariantAttr(StringBuffer b) {
        if (!this.getVariant().equals("")) {
            b.append(" variant=\"").append(this.getVariant()).append("\"");
        }
    }

    public void toXML(StringBuffer b, int indent) {
        if (this.isDummy()) {
            return;
        }
        this.indentBuffer(b, indent);
        this.appendStartTag(b);
        this.appendLanguageAttr(b);
        this.appendCountryAttr(b);
        this.appendVariantAttr(b);
        this.appendMergeAttr(b);
        this.appendLockAttr(b);
        this.appendAdvancedAttr(b);
        this.appendPropagateAttr(b);
        b.append(">\n");
        this.appendChildProperty(b, indent);
        this.indentBuffer(b, indent);
        this.appendEndTag(b);
    }
}

