/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.calendar;

import com.iplanet.sso.SSOToken;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.calendar.CalendarApplicationHelper;
import com.sun.portal.providers.calendar.CalendarProvider;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NotesCalendarHelper
implements CalendarApplicationHelper {
    public CalendarProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public Properties adapterProperties = null;
    protected String appName = "";
    protected String containerName = "";

    public void init(CalendarProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
    }

    public String getStartURL(CalendarProvider provider, HttpServletRequest request) {
        String url = null;
        try {
            url = this.getApplicationURL(provider, request);
            ProviderContext pc = provider.getProviderContext();
            url = pc.escape(url);
        }
        catch (Exception e) {
            SSOAdapterDebug.logWarning((String)(this.getClass().getName() + ".getStartURL(): could not determine start url "), (Throwable)e);
        }
        return url;
    }

    public String getApplicationURL(CalendarProvider provider, HttpServletRequest request) throws Exception {
        String clientProtocol = this.adapterProperties.getProperty("clientProtocol", "http");
        String clientPort = this.adapterProperties.getProperty("clientPort", this.adapterProperties.getProperty("port", "80"));
        String host = this.adapterProperties.getProperty("host");
        String clientURL = clientProtocol + "://" + host + ":" + clientPort;
        SSOToken tok = this.ssoAdapter.getSSOToken();
        if (tok != null) {
            clientURL = clientURL + "/mail/" + this.adapterProperties.getProperty("uid") + ".nsf";
        }
        return clientURL;
    }

    public String getEventURL(CalendarProvider provider, HttpServletRequest request, VEvent event) throws Exception {
        return null;
    }

    public String getTaskURL(CalendarProvider provider, HttpServletRequest request, VTodo task) throws Exception {
        return null;
    }

    public void error(ProviderContext pc, String msg) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg);
        }
    }

    public void warning(ProviderContext pc, String msg) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg);
        }
    }

    public void message(ProviderContext pc, String msg) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg);
        }
    }

    public void error(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg, t);
        }
    }

    public void warning(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg, t);
        }
    }

    public void message(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg, t);
        }
    }

    public StringBuffer getAppPrefsEdit(CalendarProvider cprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = cprov.getProviderContext();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(cprov.getName(), "dpEditAttributes", pflist);
            fontTag = pc.getStringProperty(cprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
            ProviderEditUtility.setDefaultPresentation((String)cprov.getName(), (ProviderContext)cprov.getProviderContext(), tagTable);
        }
        catch (ProviderContextException pce) {
            pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            try {
                content.append((Object)pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append((Object)ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)cprov.getName(), (ProviderContext)pc, (boolean)true));
                }
            }
            try {
                content.append((Object)pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
        }
        return content;
    }

    public String getSSOProperty(String key) {
        String tmp = this.adapterProperties.getProperty(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public String getRequestParameter(String key, HttpServletRequest req) {
        String tmp = req.getParameter(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public StringBuffer createEditContent(String type, String header, String key, String pName, ProviderContext pc, boolean useDP) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer content = new StringBuffer();
        try {
            tagTable.put("iwtDesktop-fontFace1", pc.getStringProperty(pName, "fontFace1", "Sans-serif"));
        }
        catch (ProviderContextException pce) {
            this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
        }
        if (type.equals("string")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            try {
                if (useDP) {
                    tagTable.put("attValue", pc.getStringProperty(pName, key, ""));
                } else {
                    tagTable.put("attValue", this.getSSOProperty(key));
                }
                content.append((Object)pc.getTemplate(pName, "edit-string.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("select")) {
            Map selectMap = null;
            String selectedValue = "";
            try {
                selectedValue = useDP ? pc.getStringProperty(pName, key, "") : this.getSSOProperty(key);
                List pflist = null;
                try {
                    pflist = pc.getClientAndLocalePropertiesFilters();
                    selectMap = pc.getCollectionProperty(pName, key + "SelectOptions", pflist);
                }
                catch (ProviderContextException pce) {
                    selectMap = pc.getCollectionProperty(pName, key + "SelectOptions");
                }
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
            Set selEntries = selectMap.entrySet();
            Iterator selIter = selEntries.iterator();
            StringBuffer options = new StringBuffer();
            while (selIter.hasNext()) {
                Map.Entry selEntry = selIter.next();
                String selKey = (String)selEntry.getKey();
                String selValue = (String)selEntry.getValue();
                tagTable.put("attValue", selKey);
                tagTable.put("string", selValue);
                if (selKey.equals(selectedValue)) {
                    tagTable.put("selected", "SELECTED");
                } else {
                    tagTable.put("selected", "");
                }
                try {
                    options.append((Object)pc.getTemplate(pName, "edit-selectoption.template", tagTable));
                }
                catch (ProviderContextException pce) {
                    this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
                }
            }
            tagTable.put("header", header);
            tagTable.put("attName", key);
            tagTable.put("options", options.toString());
            try {
                content.append((Object)pc.getTemplate(pName, "edit-select.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("check")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            String selected = "";
            boolean isSelected = false;
            try {
                if (useDP) {
                    isSelected = pc.getBooleanProperty(pName, key);
                } else {
                    Boolean bool = new Boolean(this.getSSOProperty(key));
                    isSelected = bool;
                }
                this.error(pc, key + "=" + this.getSSOProperty(key) + " isSelected=" + isSelected);
                selected = isSelected ? "CHECKED" : "";
                tagTable.put("attSelected", selected);
                content.append((Object)pc.getTemplate(pName, "edit-checkbox.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("password")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            String pwd = "";
            try {
                pwd = useDP ? pc.getStringProperty(pName, key, "") : this.getSSOProperty(key);
                tagTable.put("attValue", pwd);
                content.append((Object)pc.getTemplate(pName, "edit-password.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        } else if (type.equals("int")) {
            tagTable.put("header", header);
            tagTable.put("attName", key);
            try {
                if (useDP) {
                    tagTable.put("attValue", Integer.toString(pc.getIntegerProperty(pName, key)));
                } else {
                    tagTable.put("attValue", this.getSSOProperty(key));
                }
                content.append((Object)pc.getTemplate(pName, "edit-string.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        }
        return content;
    }

    protected boolean isEmpty(String line) {
        return line == null || line.equals("");
    }

    public URL processAppPrefsEdit(CalendarProvider cprov, HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = cprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        try {
            url = this.getAppHelperProcessURL(request, cprov);
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(cprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("NotesCalendarHelper.processAppPrefsEdit():\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqString.equals("")) continue;
                        pc.setStringProperty(cprov.getName(), key, reqString);
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqNumber.equals("")) continue;
                        pc.setIntegerProperty(cprov.getName(), key, Integer.parseInt(reqNumber));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    pc.setBooleanProperty(cprov.getName(), key, bool.booleanValue());
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("NotesCalendarHelper.processAppPrefsEdit():\n", (Throwable)pce);
                }
            }
        }
        pc.debugMessage((Object)("MesengerExpressHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, CalendarProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("CalendarExpressHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("CalendarExpressHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("LDAPABApplicationHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }
}

