/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DocumentFactory {
    public static Document createDOMDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.newDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public static Element getDocumentElement(InputStream is) {
        Element element = null;
        try {
            Document doc = DocumentFactory.openDocumentFromStreamAsDOM(is);
            element = doc.getDocumentElement();
        }
        catch (Exception e) {
            System.err.println("ERROR WITH Stream");
            e.printStackTrace();
        }
        return element;
    }

    public static Element getDocumentElement(File path) {
        Element element = null;
        try {
            Document doc = DocumentFactory.openDocumentFromFileAsDOM(path);
            element = doc.getDocumentElement();
        }
        catch (Exception e) {
            System.err.println("ERROR WITH PATH : " + path);
            e.printStackTrace();
        }
        return element;
    }

    public static Document openDocumentFromFileAsDOM(File file) {
        Document document = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            document = DocumentFactory.openDocumentFromStreamAsDOM(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        return document;
    }

    public static Document openDocumentFromFileAsDOM(String documentLocation) {
        Document document = null;
        try {
            FileInputStream inputStream = new FileInputStream(documentLocation);
            document = DocumentFactory.openDocumentFromStreamAsDOM(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        return document;
    }

    public static Document openDocumentFromStreamAsDOM(InputStream inputStream) {
        Document document = null;
        try {
            InputSource inputSource = new InputSource(inputStream);
            document = DocumentFactory.openDocumentAsDOM(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        return document;
    }

    public static Document openDocumentAsDOM(InputSource inputSource) {
        Document document = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        return document;
    }

    public static Document openStringAsDom(String string) {
        Document document = null;
        if (string != null) {
            document = DocumentFactory.openDocumentAsDOM(new StringReader(string));
        }
        return document;
    }

    public static Document openDocumentAsDOM(Reader reader) {
        Document document = null;
        try {
            InputSource inputSource = new InputSource(reader);
            document = DocumentFactory.openDocumentAsDOM(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        return document;
    }
}

