/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSParser;
import com.sun.comclient.calendar.socs.SOCSResponse;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;
import org.xml.sax.SAXException;

public class SOCSRequest {
    private URL serviceURL;
    private SOCSSession session;
    private static String EVENT = "event";
    private static String TODO = "todo";
    private static String ALL = "all";
    private static String WCAP_ERROR_ICAL_FORMAT = "X-NSCP-WCAP-ERRNO:";
    private static String WCAP_ERROR_XML_FORMAT_START_TAG = "<X-NSCP-WCAP-ERRNO>";
    private static String WCAP_ERROR_HTMLJS_FORMAT = "var errno=";
    private static String WCAP_ERROR_XML_FORMAT_END_TAG = "</X-NSCP-WCAP-ERRNO>";
    private static String BOUNDARY = "---------------------------jcapiset001";
    private static int READ_AHEAD_LIMIT = 700;
    private static int MAXIMUM_BYTES_TO_CHECK_FOR_ERROR = 500;

    SOCSRequest(SOCSCalendarStore sOCSCalendarStore) {
        this(sOCSCalendarStore.getServiceURL(), null);
    }

    SOCSRequest(SOCSSession sOCSSession) {
        this(sOCSSession.getCalStore().getServiceURL(), sOCSSession);
    }

    SOCSRequest(URL uRL, SOCSSession sOCSSession) {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        this.serviceURL = uRL;
        this.session = sOCSSession;
    }

    HttpURLConnection postRequest(String string, ArrayList arrayList) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection = null;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("?");
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                stringBuffer.append((String)arrayList.get(n) + "&");
                ++n;
            }
        }
        stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        try {
            httpURLConnection = this.makePostRequest(this.serviceURL, string + stringBuffer);
            if (httpURLConnection != null) {
                return httpURLConnection;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return httpURLConnection;
    }

    private HttpURLConnection setExportMIMEHeaders(HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.setRequestProperty("Content-type", "multipart/form-data; boundary=" + BOUNDARY);
        DataOutputStream dataOutputStream = null;
        dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
        dataOutputStream.writeBytes("--" + BOUNDARY + "\r\n");
        return httpURLConnection;
    }

    private HttpURLConnection setImportMIMEHeadersAndData(HttpURLConnection httpURLConnection, String string, InputStream inputStream) throws IOException {
        httpURLConnection.setRequestProperty("Content-type", "multipart/form-data; boundary=" + BOUNDARY);
        DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
        dataOutputStream.writeBytes("--" + BOUNDARY + "\r\n");
        dataOutputStream.writeBytes("Content-type: " + string + "; ");
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.writeBytes("Content-disposition: form-data; ");
        dataOutputStream.writeBytes("filename=\"jcapi-import\" ");
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.writeBytes("\r\n");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            dataOutputStream.writeBytes(string2 + "\r\n");
        }
        dataOutputStream.writeBytes("\r\n--" + BOUNDARY + "--" + "\r\n");
        return httpURLConnection;
    }

    private int obtainWCAPError(BufferedReader bufferedReader) throws IOException {
        String string = null;
        int n = -1;
        int n2 = 0;
        bufferedReader.mark(READ_AHEAD_LIMIT);
        while ((string = bufferedReader.readLine()) != null) {
            if ((n2 += string.length()) <= MAXIMUM_BYTES_TO_CHECK_FOR_ERROR) {
                if (string.startsWith(WCAP_ERROR_ICAL_FORMAT)) {
                    n = Integer.parseInt(string.substring(WCAP_ERROR_ICAL_FORMAT.length()));
                    break;
                }
                if (string.startsWith(WCAP_ERROR_XML_FORMAT_START_TAG)) {
                    String string2 = string.substring(WCAP_ERROR_XML_FORMAT_START_TAG.length());
                    n = Integer.parseInt(string2.substring(0, string2.indexOf(WCAP_ERROR_XML_FORMAT_END_TAG)));
                    break;
                }
                if (!string.startsWith(WCAP_ERROR_HTMLJS_FORMAT)) continue;
                n = Integer.parseInt(string.substring(WCAP_ERROR_HTMLJS_FORMAT.length()));
                break;
            }
            if (n != -1) break;
            n = 0;
            break;
        }
        bufferedReader.reset();
        return n;
    }

    private HttpURLConnection makePostRequest(URL uRL, String string) throws MalformedURLException, IOException {
        URL uRL2 = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL2 = new URL(uRL, string);
            httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return httpURLConnection;
    }

    private BufferedReader sendPostCommand(HttpURLConnection httpURLConnection) throws IOException {
        BufferedReader bufferedReader = null;
        if (httpURLConnection != null) {
            httpURLConnection.connect();
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        }
        return bufferedReader;
    }

    SOCSResponse request(String string, ArrayList arrayList) throws SOCSException {
        SOCSResponse sOCSResponse;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("?");
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                stringBuffer.append((String)arrayList.get(n) + "&");
                ++n;
            }
        }
        stringBuffer.append("fmt-out=text/xml");
        try {
            SOCSParser sOCSParser = new SOCSParser(this.session);
            URL uRL = new URL(this.serviceURL, string + stringBuffer);
            sOCSResponse = sOCSParser.parse(uRL);
        }
        catch (ConnectException connectException) {
            throw new SOCSException("Invalid Calendar Server name or port", 108);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SOCSException("Invalid Calendar Server name or port", 100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SOCSException(" Unauthorized access to resource ", 101);
        }
        catch (SAXException sAXException) {
            throw new SOCSException("Parse error: " + string + stringBuffer + ": " + sAXException, 113);
        }
        catch (Exception exception) {
            throw new SOCSException("SOCS request failed: " + string + stringBuffer + ": " + exception, 104);
        }
        return sOCSResponse;
    }

    SOCSResponse login(String string, String string2, String string3) throws SOCSException {
        SOCSResponse sOCSResponse;
        if (string == null) {
            throw new SOCSException("null username", 105);
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("user=" + SOCSUtils.urlEncode(string));
        if (string2 != null) {
            arrayList.add("password=" + SOCSUtils.urlEncode(string2));
        }
        if (string3 != null) {
            arrayList.add("proxyauth=" + SOCSUtils.urlEncode(string3));
        }
        if ((sOCSResponse = this.request("login.wcap", arrayList)).getErrorNum() != 0 && sOCSResponse.getErrorNum() != 2) {
            throw new SOCSException(" login.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse logout() throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("id=" + this.session.getID());
        SOCSResponse sOCSResponse = this.request("logout.wcap", arrayList);
        if (sOCSResponse.getErrorNum() != 0 && sOCSResponse.getErrorNum() != -1) {
            throw new SOCSException("logout.wcap failed " + sOCSResponse.getErrorNum(), 106);
        }
        return sOCSResponse;
    }

    SOCSResponse isSOCSSessionValid() throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("id=" + this.session.getID());
        SOCSResponse sOCSResponse = this.request("check_id.wcap", arrayList);
        if (sOCSResponse.getErrorNum() > -1 && sOCSResponse.getErrorNum() != 0) {
            throw new SOCSException("check_id.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse getUserPrefs() throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("id=" + this.session.getID());
        SOCSResponse sOCSResponse = this.request("get_userprefs.wcap", arrayList);
        if (sOCSResponse.getErrorNum() != 0) {
            throw new SOCSException("get_userprefs.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse setUserPrefs(Properties properties) throws SOCSException {
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("id=" + this.session.getID());
        SOCSResponse sOCSResponse = this.request("set_userprefs.wcap", arrayList);
        if (sOCSResponse.getErrorNum() != 0) {
            throw new SOCSException("set_userprefs.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse getCalProps(String string) throws SOCSException {
        SOCSResponse sOCSResponse;
        if (this.session.getID() == null && string == null) {
            throw new SOCSException("null session.getID() & calid", 109);
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        if (string != null) {
            arrayList.add("calid=" + string);
        }
        if ((sOCSResponse = this.request("get_calprops.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException("get_calprops.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse setCalProps(String string, Properties properties) throws SOCSException {
        Object object;
        if (this.session.getID() == null) {
            throw new SOCSException("null session.getID()", 109);
        }
        if (null == string) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("id=" + this.session.getID());
        arrayList.add("calid=" + string);
        if (null != properties) {
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                arrayList.add(string2 + "=" + SOCSUtils.urlEncode(properties.getProperty(string2)));
            }
        }
        if (((SOCSResponse)(object = this.request("set_calprops.wcap", arrayList))).getErrorNum() != 0) {
            throw new SOCSException("set_calprops.wcap failed", ((SOCSResponse)object).getErrorNum());
        }
        return object;
    }

    public SOCSResponse fetchEventsTodos(String string, DateTime dateTime, DateTime dateTime2, int n) throws SOCSException {
        SOCSResponse sOCSResponse;
        if (null == dateTime || null == dateTime2) {
            throw new SOCSException("null time range", 105);
        }
        if (null == string) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != this.session.getID()) {
            arrayList.add("id=" + this.session.getID());
        }
        if (null != string) {
            arrayList.add("calid=" + SOCSUtils.urlEncode(string));
        }
        arrayList.add("dtstart=" + dateTime.toISO8601());
        arrayList.add("dtend=" + dateTime2.toISO8601());
        if (this.isBitSet(n, 1) && this.isBitSet(n, 2)) {
            arrayList.add("component-type=3");
        } else if (this.isBitSet(n, 1)) {
            arrayList.add("component-type=1");
        } else if (this.isBitSet(n, 2)) {
            arrayList.add("component-type=2");
        } else {
            throw new SOCSException(": requested fetch component types \"" + n + "\" found to be invalid. -- Not a mask of ICalendar.VEVENT or ICalendar.VTODO or both", 105);
        }
        String string2 = this.session.getCalStore().getSession().getProperty("cal.socs.compressed");
        if (null != string2 && string2.equalsIgnoreCase("true")) {
            arrayList.add("compressed=1");
        }
        if ((sOCSResponse = this.request("fetchcomponents_by_range.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException(" fetchcomponents_by_range.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    public SOCSResponse fetchEventsTodos(String string, String string2, String string3, String string4, boolean bl) throws SOCSException {
        String string5;
        if (null == string) {
            throw new SOCSException("null calid", 110);
        }
        if (null == string2) {
            throw new SOCSException("null uid", 105);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != this.session.getID()) {
            arrayList.add("id=" + this.session.getID());
        }
        if (null != string) {
            arrayList.add("calid=" + string);
        }
        if (null != string2) {
            arrayList.add("uid=" + string2);
        }
        if (null != string3) {
            arrayList.add("rid=" + string3);
        }
        if (null != string4) {
            arrayList.add("mod=" + this.getModifierValue(string4));
        }
        if (null != (string5 = this.session.getCalStore().getSession().getProperty("cal.socs.compressed")) && string5.equalsIgnoreCase("true")) {
            arrayList.add("compressed=1");
        }
        SOCSResponse sOCSResponse = null;
        sOCSResponse = bl ? this.request("fetchevents_by_id.wcap", arrayList) : this.request("fetchtodos_by_id.wcap", arrayList);
        if (sOCSResponse.getErrorNum() != 0) {
            throw new SOCSException(" fetchcomponents_by_range.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    public SOCSResponse fetchFreeBusy(String string, DateTime dateTime, DateTime dateTime2) throws SOCSException {
        SOCSResponse sOCSResponse;
        if (null == dateTime || null == dateTime2) {
            throw new SOCSException("null time range", 105);
        }
        if (null == string) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != this.session.getID()) {
            arrayList.add("id=" + this.session.getID());
        }
        if (null != string) {
            arrayList.add("calid=" + SOCSUtils.urlEncode(string));
        }
        arrayList.add("dtstart=" + dateTime.toISO8601());
        arrayList.add("dtend=" + dateTime2.toISO8601());
        String string2 = this.session.getCalStore().getSession().getProperty("cal.socs.busyonly");
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            arrayList.add("busyonly=1");
        }
        if ((sOCSResponse = this.request("get_freebusy.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException(" get_freebusy.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    BufferedReader exportCalendar(String string, DateTime dateTime, DateTime dateTime2, String string2) throws SOCSException {
        int n = -1;
        if (string == null) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        arrayList.add("calid=" + SOCSUtils.urlEncode(string));
        if (dateTime == null) {
            arrayList.add("dtstart=0");
        } else {
            arrayList.add("dtstart=" + dateTime.toISO8601());
        }
        if (dateTime2 == null) {
            arrayList.add("dtend=0");
        } else {
            arrayList.add("dtend=" + dateTime2.toISO8601());
        }
        arrayList.add("content-out=" + string2);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.postRequest("export.wcap", arrayList);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SOCSException(malformedURLException.getMessage(), 103);
        }
        catch (IOException iOException) {
            throw new SOCSException(iOException.getMessage(), 107);
        }
        try {
            httpURLConnection = this.setExportMIMEHeaders(httpURLConnection);
        }
        catch (ConnectException connectException) {
            throw new SOCSException("Invalid Calendar Server name or port.", 108);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SOCSException("Invalid Calendar Server name or port.", 100);
        }
        catch (IOException iOException) {
            throw new SOCSException(iOException.getMessage(), 107);
        }
        try {
            bufferedReader = this.sendPostCommand(httpURLConnection);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SOCSException(" Could not access the resource ", 101);
        }
        catch (IOException iOException) {
            throw new SOCSException("Input/Output Error: " + iOException.getMessage(), 107);
        }
        catch (Exception exception) {
            throw new SOCSException("SOCS request failed: ", 104);
        }
        if (bufferedReader == null) {
            throw new SOCSException("Could not export calendar ", 104);
        }
        try {
            n = this.obtainWCAPError(bufferedReader);
        }
        catch (IOException iOException) {
            throw new SOCSException(iOException.getMessage(), 107);
        }
        if (n != 0) {
            throw new SOCSException(" Failed to export calendar ", n);
        }
        if (bufferedReader == null) {
            throw new SOCSException(" Failed to export calendar " + string, 104);
        }
        return bufferedReader;
    }

    public void importCalendar(String string, DateTime dateTime, DateTime dateTime2, String string2, InputStream inputStream) throws SOCSException {
        int n = -1;
        if (string == null) {
            throw new SOCSException("null calid", 110);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        arrayList.add("calid=" + SOCSUtils.urlEncode(string));
        if (dateTime == null) {
            arrayList.add("dtstart=0");
        } else {
            arrayList.add("dtstart=" + dateTime.toISO8601());
        }
        if (dateTime2 == null) {
            arrayList.add("dtend=0");
        } else {
            arrayList.add("dtend=" + dateTime2.toISO8601());
        }
        arrayList.add("content-in=" + string2);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.postRequest("import.wcap", arrayList);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SOCSException(malformedURLException.getMessage(), 103);
        }
        catch (IOException iOException) {
            throw new SOCSException(iOException.getMessage(), 104);
        }
        try {
            httpURLConnection = this.setImportMIMEHeadersAndData(httpURLConnection, string2, inputStream);
        }
        catch (ConnectException connectException) {
            throw new SOCSException("Invalid Calendar Server name or port", 108);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SOCSException("Invalid Calendar Server name or port", 100);
        }
        catch (IOException iOException) {
            throw new SOCSException("Unable to read the data to be imported.", 107);
        }
        try {
            bufferedReader = this.sendPostCommand(httpURLConnection);
        }
        catch (IOException iOException) {
            throw new SOCSException("Input/Output Error: " + iOException.getMessage(), 107);
        }
        catch (Exception exception) {
            throw new SOCSException("SOCS request failed. ", 104);
        }
        if (bufferedReader == null) {
            throw new SOCSException("Could not Import calendar ", 104);
        }
        try {
            n = this.obtainWCAPError(bufferedReader);
        }
        catch (IOException iOException) {
            throw new SOCSException(iOException.getMessage(), 107);
        }
        if (n != 0) {
            throw new SOCSException(" Failed to Import calendar ", n);
        }
        if (bufferedReader == null) {
            throw new SOCSException(" Failed to Import calendar to " + string, 104);
        }
    }

    SOCSResponse fetch(String string, String string2) throws SOCSException {
        if (string2 == null) {
            throw new SOCSException("null uid", 105);
        }
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        if (string != null) {
            arrayList.add("calid=" + string);
        }
        arrayList.add("uid=" + string2);
        SOCSResponse sOCSResponse = this.request("fetchevents_by_id.wcap", arrayList);
        if (sOCSResponse.getErrorNum() != 0) {
            throw new SOCSException("fetchevents_by_id.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse storeEvent(String string, VEvent vEvent, String string2, boolean bl) throws SOCSException {
        SOCSResponse sOCSResponse;
        TimeZone timeZone;
        if (string == null) {
            throw new SOCSException("null calid", 110);
        }
        if (vEvent == null) {
            throw new SOCSException("null event", 105);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        if ((timeZone = this.session.getCalStore().getSession().getTimeZone()) != null) {
            arrayList.add("tzid=" + timeZone.getID());
        }
        arrayList.add("calid=" + string);
        arrayList.add("mod=" + this.getModifierValue(string2));
        SOCSEvent sOCSEvent = (SOCSEvent)vEvent;
        sOCSEvent.parseToSOCS(arrayList, string);
        if (bl) {
            arrayList.add("notify=1");
        }
        if ((sOCSResponse = this.request("storeevents.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException("storeevents.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse storeTodo(String string, VTodo vTodo, String string2, boolean bl) throws SOCSException {
        SOCSResponse sOCSResponse;
        TimeZone timeZone;
        if (string == null) {
            throw new SOCSException("null calid", 110);
        }
        if (vTodo == null) {
            throw new SOCSException("null todo", 105);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        if ((timeZone = this.session.getCalStore().getSession().getTimeZone()) != null) {
            arrayList.add("tzid=" + timeZone.getID());
        }
        arrayList.add("calid=" + string);
        arrayList.add("mod=" + this.getModifierValue(string2));
        SOCSTodo sOCSTodo = (SOCSTodo)vTodo;
        sOCSTodo.parseToSOCS(arrayList, string);
        if (bl) {
            arrayList.add("notify=1");
        }
        if ((sOCSResponse = this.request("storetodos.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException("storetodos.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse deleteevents(String string, VEvent vEvent, String string2, boolean bl) throws SOCSException {
        SOCSResponse sOCSResponse;
        if (string == null) {
            throw new SOCSException("null calid", 110);
        }
        if (vEvent == null) {
            throw new SOCSException("null event", 105);
        }
        ArrayList<String> arrayList = new ArrayList<String>(6);
        String string3 = null;
        try {
            if (vEvent.hasProperty("RECURRENCE-ID")) {
                string3 = vEvent.getRecurrenceID().toISOString();
            }
            if (this.session.getID() != null) {
                arrayList.add("id=" + this.session.getID());
            }
            arrayList.add("calid=" + string);
            arrayList.add("uid=" + vEvent.getID());
            arrayList.add("rid=" + (string3 != null ? string3 : "0"));
            arrayList.add("mod=" + this.getModifierValue(string2));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
        }
        catch (CalendarComponentException calendarComponentException) {
            throw new SOCSException(calendarComponentException.getError());
        }
        if (bl) {
            arrayList.add("notify=1");
        }
        if ((sOCSResponse = this.request("deleteevents_by_id.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException("deleteevents_by_id.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse deletetodos(String string, VTodo vTodo, String string2, boolean bl) throws SOCSException {
        SOCSResponse sOCSResponse;
        if (string == null) {
            throw new SOCSException("null calid", 110);
        }
        if (vTodo == null) {
            throw new SOCSException("null todo", 105);
        }
        ArrayList<String> arrayList = new ArrayList<String>(6);
        String string3 = null;
        try {
            if (vTodo.hasProperty("RECURRENCE-ID")) {
                string3 = vTodo.getRecurrenceID().toISOString();
            }
            if (this.session.getID() != null) {
                arrayList.add("id=" + this.session.getID());
            }
            arrayList.add("calid=" + string);
            arrayList.add("uid=" + vTodo.getID());
            arrayList.add("rid=" + (string3 != null ? string3 : "0"));
            arrayList.add("mod=" + this.getModifierValue(string2));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
        }
        catch (CalendarComponentException calendarComponentException) {
            throw new SOCSException(calendarComponentException.getError());
        }
        if (bl) {
            arrayList.add("notify=1");
        }
        if ((sOCSResponse = this.request("deletetodos_by_id.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException("deletetodos_by_id.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse searchCalendars(String string, int n, int n2) throws SOCSException {
        SOCSResponse sOCSResponse;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        arrayList.add("search-string=" + string);
        if (n > 0) {
            arrayList.add("searchOpts=" + Integer.toString(n));
        }
        if (n2 > 0) {
            arrayList.add("maxResults=" + Integer.toString(n2));
        }
        if ((sOCSResponse = this.request("search_calprops.wcap", arrayList)).getErrorNum() != 0) {
            throw new SOCSException("searchcalendar.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    SOCSResponse createCalendar(String string, Properties properties) throws SOCSException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        arrayList.add("calid=" + SOCSUtils.urlEncode(string));
        if (properties != null && !properties.isEmpty()) {
            arrayList.add("set_calprops=1");
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                arrayList.add(string2 + "=" + SOCSUtils.urlEncode(properties.getProperty(string2)));
            }
        }
        if (((SOCSResponse)(object = this.request("createcalendar.wcap", arrayList))).getErrorNum() != 0) {
            throw new SOCSException("createcalendar.wcap failed", ((SOCSResponse)object).getErrorNum());
        }
        return object;
    }

    SOCSResponse deleteCalendar(String string) throws SOCSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.session.getID() != null) {
            arrayList.add("id=" + this.session.getID());
        }
        arrayList.add("calid=" + SOCSUtils.urlEncode(string));
        SOCSResponse sOCSResponse = this.request("deletecalendar.wcap", arrayList);
        if (sOCSResponse.getErrorNum() != 0) {
            throw new SOCSException(" deletecalendar.wcap failed", sOCSResponse.getErrorNum());
        }
        return sOCSResponse;
    }

    private boolean isBitSet(int n, int n2) {
        return 0 != (n & n2);
    }

    private int getModifierValue(String string) throws SOCSException {
        if (null == string) {
            return 1;
        }
        if (string.equals("THIS_INSTANCE")) {
            return 1;
        }
        if (string.equals("THIS_AND_FUTURE")) {
            return 2;
        }
        if (string.equals("THIS_AND_PRIOR")) {
            return 3;
        }
        if (string.equals("THIS_AND_ALL")) {
            return 4;
        }
        throw new SOCSException(": recurrence modifier \"" + string + "\" found to be invalid", 105);
    }
}

