/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

public class DaysOfWeek {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 4;
    public static final int WEDNESDAY = 8;
    public static final int THURSDAY = 16;
    public static final int FRIDAY = 32;
    public static final int SATURDAY = 64;
    public static final DaysOfWeek MON_WED_FRI = new DaysOfWeek(42);
    public static final DaysOfWeek TUE_THUR = new DaysOfWeek(20);
    public static final DaysOfWeek WEEKEND = new DaysOfWeek(65);
    public static final DaysOfWeek WEEKDAYS = new DaysOfWeek(62);
    public static final DaysOfWeek ALL = new DaysOfWeek(127);
    private int dayMask = 0;
    private static final String[] days = new String[]{"SUN", "MON", "TUE", "WED", "THUR", "FRI", "SAT"};

    public DaysOfWeek(int n) {
        this.dayMask = n & 0x7F;
    }

    public DaysOfWeek() {
        this.dayMask = 0;
    }

    public void add(int n) {
        this.dayMask |= n & 0x7F;
    }

    public void remove(int n) {
        this.dayMask ^= n & 0x7F;
    }

    public boolean contains(int n) {
        return (this.dayMask & n) != 0;
    }

    public int getDayMask() {
        return this.dayMask;
    }

    public void clear() {
        this.dayMask = 0;
    }

    public String toString() {
        int n = this.dayMask & 0x7F;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < 7) {
            stringBuffer.append(":");
            if ((n & 1) == 1) {
                stringBuffer.append(days[n2]);
            }
            n >>= 1;
            ++n2;
        }
        return stringBuffer.substring(1);
    }
}

