/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.markup;

import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.TranslatorHelper;
import com.sun.portal.rewriter.engines.markup.TagContext;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.xml.Tag;
import com.sun.portal.rewriter.util.xml.TagParser;
import java.util.List;

final class MarkupRewriterHelper {
    private static final boolean commentBaseHREF = ConfigManager.getBoolean("IS_COMMENT_BASE_HREF");
    private static final boolean commentBodyBackGround = ConfigManager.getBoolean("IS_COMMENT_BODY_BACKGROUND");

    MarkupRewriterHelper() {
    }

    static boolean isEmptyTag(String aContent, int aEndIndex) {
        char backByTwo;
        return aContent.charAt(aEndIndex - 1) == '/' && (Character.isWhitespace(backByTwo = aContent.charAt(aEndIndex - 2)) || backByTwo == '\"' || backByTwo == '\'' || backByTwo == '\\');
    }

    static void commentAttributes(String aTagName, StringBuffer aTagResultBuffer, String aEndedWith) {
        if (commentBaseHREF && aTagName.equalsIgnoreCase("base")) {
            MarkupRewriterHelper.commentBaseHREF(aTagResultBuffer, aEndedWith);
        } else if (commentBodyBackGround && aTagName.equalsIgnoreCase("body")) {
            MarkupRewriterHelper.commentAttribute(aTagResultBuffer, "background", aEndedWith);
        }
    }

    static void commentBaseHREF(StringBuffer aTagBuff, String aEndedWith) {
        Tag lBaseTag = TagParser.parse(aTagBuff.toString());
        String lHREF = lBaseTag.get("href");
        if (lHREF != null && lHREF.trim().length() != 0) {
            if (lBaseTag.get("target") == null) {
                aTagBuff.insert(0, "!-- ");
                aTagBuff.append(" --");
            } else {
                aTagBuff.setLength(0);
                aTagBuff.append(lBaseTag.getName());
                aTagBuff.append(" ");
                aTagBuff.append("target");
                aTagBuff.append("=");
                aTagBuff.append(lBaseTag.get("target"));
                aTagBuff.append(" ");
                aTagBuff.append(aEndedWith);
                aTagBuff.append(" <!-- ");
                aTagBuff.append("href");
                aTagBuff.append("=");
                aTagBuff.append(lHREF);
                aTagBuff.append(" --");
            }
        }
    }

    private static void commentAttribute(StringBuffer aTagBuff, String aAttributeName, String aEndedWith) {
        Tag lTag = TagParser.parse(aTagBuff.toString());
        String lBackGround = lTag.get(aAttributeName);
        if (lBackGround != null && lBackGround.trim().length() != 0) {
            aTagBuff.setLength(0);
            aTagBuff.append(lTag.getName());
            aTagBuff.append(" ");
            List lAttributeList = lTag.getAttributeMap().keyList();
            int i = 0;
            while (i < lAttributeList.size()) {
                String bAttName = lAttributeList.get(i).toString();
                if (!bAttName.equalsIgnoreCase(aAttributeName)) {
                    aTagBuff.append(bAttName);
                    aTagBuff.append("=");
                    aTagBuff.append(lTag.get(bAttName));
                    aTagBuff.append(" ");
                }
                ++i;
            }
            aTagBuff.append(aEndedWith);
            aTagBuff.append(" <!-- ");
            aTagBuff.append(aAttributeName);
            aTagBuff.append("=");
            aTagBuff.append(lBackGround);
            aTagBuff.append(" --");
        }
    }

    static void rewriteMetaTag(StringBuffer aTagBuff, String aAttributeValue, Translator aTranslator) {
        int index = aAttributeValue.indexOf(";");
        if (index == -1) {
            aTagBuff.append(aAttributeValue);
        } else {
            index = aAttributeValue.toLowerCase().indexOf("url=", index);
            if (index == -1) {
                aTagBuff.append(aAttributeValue);
            } else {
                aTagBuff.append(aAttributeValue.substring(0, index + 4));
                aTagBuff.append(aTranslator.translate(aAttributeValue.substring(index + 4)));
            }
        }
    }

    static String setBaseSpec(Translator aTranslator, String aAttributeValue) {
        String lAbsoluteBASE = TranslatorHelper.convert2Absolute(aTranslator.getPageSpec(), aAttributeValue);
        aTranslator.getPageSpec().setBase(lAbsoluteBASE);
        return lAbsoluteBASE;
    }

    static void setLookAheadCodeBaseInfo(Translator aTranslator, Tag aTag) {
        String lCodeBaseValue = aTag.get("codebase");
        if (lCodeBaseValue != null) {
            if (!lCodeBaseValue.trim().regionMatches(true, 0, "javascript:", 0, 11)) {
                lCodeBaseValue = TranslatorHelper.convert2Absolute(aTranslator.getPageSpec(), lCodeBaseValue);
            }
            aTranslator.getLookAheadInfo().setAppletCodeBase(lCodeBaseValue);
        }
    }

    static void checkAndSetAppletBegin(TagContext aTagParam, Translator aTranslator) {
        if (aTagParam.attributeName.equals("codebase")) {
            aTagParam.enableCodeBase();
        }
        if (aTagParam.attributeName.equals("code") || aTagParam.attributeName.equals("archive") || aTagParam.attributeName.equals("classid")) {
            aTranslator.getLookAheadInfo().setInAppletAttributeBegin();
        }
    }

    static String getBlockTag(String aContent, StringBuffer aBlockBuff) {
        String tmptag;
        int index = aContent.lastIndexOf(60);
        if (index != -1) {
            tmptag = aContent.substring(index + 1);
            aBlockBuff.append(aContent.substring(0, index + 1));
        } else {
            tmptag = aContent;
        }
        return tmptag;
    }

    static int skip2EndOfTag(String aLowerCaseContent, int aLookFromIndex, String aTagName) {
        int length = aTagName.length();
        int k = aLowerCaseContent.indexOf(aTagName, aLookFromIndex);
        if (k == -1) {
            return -1;
        }
        int l = aLowerCaseContent.indexOf(62, k + length);
        if (l == -1) {
            return -1;
        }
        String gap = aLowerCaseContent.substring(k + length, l);
        if (gap.trim().length() == 0) {
            return l + 1;
        }
        return -1;
    }

    static boolean isValidNextTagChar(String aPrevContent, String aTag) {
        int lPrevContentLength = aPrevContent.length();
        int lTagLength = aTag.length();
        char charNext2Tag = '>';
        if (lPrevContentLength > lTagLength) {
            charNext2Tag = aPrevContent.charAt(lTagLength);
        }
        return charNext2Tag == '>' || Character.isWhitespace(charNext2Tag);
    }

    static final StringBuffer createBuffer() {
        return new StringBuffer(200);
    }
}

