/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeRecipient;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimItems;
import com.aligo.pim.exchange.ExchangePimRecipientItem;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.interfaces.PimRecipientItems;

public class ExchangePimRecipientItems
extends ExchangePimItems
implements PimRecipientItems {
    private ExchangeRecipients _oRecipients;

    public ExchangePimRecipientItems(ExchangeRecipients _oRecipients, ExchangePimSession pimSession) {
        super(pimSession);
        this._oRecipients = _oRecipients;
    }

    public void setExchangeRecipients(ExchangeRecipients _oRecipients) {
        this._oRecipients = _oRecipients;
    }

    public PimRecipientItem addRecipientItem() throws ExchangePimException {
        try {
            ExchangeRecipient _oRecipient = this.getExchangeRecipients().add();
            if (_oRecipient == null) {
                return null;
            }
            return new ExchangePimRecipientItem(_oRecipient, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeRecipients().delete();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public ExchangeRecipients getExchangeRecipients() {
        return this._oRecipients;
    }

    public int getCount() throws ExchangePimException {
        try {
            return this.getExchangeRecipients().getCount();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getRecipientItem(int itemNumber) throws ExchangePimException {
        try {
            ExchangeRecipient _oRecipient = this.getExchangeRecipients().getItem(itemNumber + 1);
            if (_oRecipient == null) {
                return null;
            }
            return new ExchangePimRecipientItem(_oRecipient, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getRecipientItem(String id) throws ExchangePimException {
        try {
            ExchangeRecipient _oRecipient = this.getExchangeRecipients().getItem(this.getFirstIndex());
            while (_oRecipient != null) {
                if (_oRecipient.getId().equals(id)) {
                    return new ExchangePimRecipientItem(_oRecipient, this.getPimSession());
                }
                _oRecipient = this.getExchangeRecipients().getItem(this.getNextIndex());
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return null;
    }

    public PimRecipientItem getFirstRecipientItem() throws ExchangePimException {
        try {
            ExchangeRecipient _oMessage = this.getExchangeRecipients().getItem(this.getFirstIndex());
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimRecipientItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getNextRecipientItem() throws ExchangePimException {
        try {
            ExchangeRecipient _oMessage = this.getExchangeRecipients().getItem(this.getNextIndex());
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimRecipientItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getLastRecipientItem() throws ExchangePimException {
        try {
            ExchangeRecipient _oMessage = this.getExchangeRecipients().getItem(this.getLastIndex());
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimRecipientItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItem getPreviousRecipientItem() throws ExchangePimException {
        try {
            ExchangeRecipient _oMessage = this.getExchangeRecipients().getItem(this.getPreviousIndex());
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimRecipientItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getRecipientItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getRecipientItem(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addRecipientItem();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstRecipientItem();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextRecipientItem();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastRecipientItem();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousRecipientItem();
    }
}

