/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimAddressEntryItem;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFieldItems;
import com.aligo.pim.exchange.ExchangePimMessageItem;
import com.aligo.pim.exchange.ExchangePimRecipientItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMailAttachmentItems;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import java.util.Date;

public abstract class ExchangePimMailMessageItem
extends ExchangePimMessageItem
implements PimMailMessageItem {
    protected ExchangePimAddressEntryItem m_oPimAddressEntryItem;
    protected ExchangeAddressEntry _oAddressEntry;

    public ExchangePimMailMessageItem(Object _oMessage, ExchangePimSession pimSession) {
        super(_oMessage, pimSession);
    }

    public void setExchangeMailMessage(Object _oMessage) {
        this.setExchangeMessage(_oMessage);
    }

    public ExchangeMessage getExchangeMailMessage() {
        return (ExchangeMessage)this.getMessageObject();
    }

    public String getSubject() throws ExchangePimException {
        try {
            return this.getExchangeMailMessage().getSubject();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getBody() throws ExchangePimException {
        try {
            return this.getExchangeMailMessage().getText();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimImportanceType getImportance() throws ExchangePimException {
        try {
            int importance = this.getExchangeMailMessage().getImportance();
            switch (importance) {
                case 0: {
                    return PimImportanceType.LOW;
                }
                case 1: {
                    return PimImportanceType.NORMAL;
                }
                case 2: {
                    return PimImportanceType.HIGH;
                }
            }
            return PimImportanceType.NORMAL;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean getUnread() throws ExchangePimException {
        try {
            return this.getExchangeMailMessage().getUnread();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setUnread(boolean flag) throws ExchangePimException {
        try {
            this.getExchangeMailMessage().setUnread(flag);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    private ExchangeAddressEntry getExchangeAddressEntry() throws ExchangePimException {
        try {
            this._oAddressEntry = this.getExchangeMailMessage().getSender();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return this._oAddressEntry;
    }

    public PimAddressEntryItem getSender() throws ExchangePimException {
        try {
            if (this.m_oPimAddressEntryItem == null) {
                this.m_oPimAddressEntryItem = new ExchangePimAddressEntryItem(this.getExchangeAddressEntry(), this.getPimSession());
            } else {
                this.m_oPimAddressEntryItem.setExchangeAddressEntry(this.getExchangeAddressEntry());
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.m_oPimAddressEntryItem;
    }

    public int getClassType() throws ExchangePimException {
        try {
            return this.getExchangeMailMessage().getClassType();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getID() throws ExchangePimException {
        try {
            return this.getExchangeMailMessage().getId();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getTimeReceived() throws ExchangePimException {
        try {
            return this.getExchangeMailMessage().getTimeReceived();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeMailMessage().delete(true);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        try {
            this.getExchangeMailMessage().delete(flag);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        try {
            ExchangeFields _oFields = this.getExchangeMailMessage().getFields();
            if (_oFields == null) {
                return null;
            }
            return new ExchangePimFieldItems(_oFields, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExchangePimException {
        try {
            ExchangeRecipients _oRecipients = this.getExchangeMailMessage().getRecipients();
            if (_oRecipients == null) {
                return null;
            }
            return new ExchangePimRecipientItems(_oRecipients, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public abstract boolean hasAttachment() throws PimException;

    public abstract PimMailMessageItem replyAll() throws PimException;

    public abstract PimMailMessageItem reply() throws PimException;

    public abstract PimMailAttachmentItems getAttachmentItems() throws PimException;
}

