/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimFieldItems;
import com.aligo.pim.lotus.LotusPimItem;
import com.aligo.pim.lotus.LotusPimRecipientItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public abstract class LotusPimMessageItem
extends LotusPimItem
implements PimMessageItem {
    public static final String SEND_TO = "SendTo";
    public static final String COPY_TO = "CopyTo";
    public static final String BLIND_COPY_TO = "BlindCopyTo";
    private ViewEntry _oViewEntry;
    private ViewEntryCollection _oViewEntryCollection;
    private LotusPimFieldItems m_oPimFieldItems;
    private Document _oDocument;
    private boolean createNewDocument = false;
    private LotusPimRecipientItems m_oPimRecipientItems;

    public LotusPimMessageItem(ViewEntry viewEntry, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._oViewEntry = viewEntry;
    }

    public LotusPimMessageItem(Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._oDocument = document;
    }

    public LotusPimMessageItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._oViewEntryCollection = viewEntryCollection;
        this.createNewDocument = true;
    }

    public void setLotusMessageItem(ViewEntry viewEntry) {
        this._oViewEntry = viewEntry;
    }

    public Document createDocument() throws LotusPimException {
        try {
            View view = this.getLotusViewEntryCollection().getParent();
            Database database = view.getParent();
            this._oDocument = database.createDocument();
            this.getRecycle().add(this._oDocument);
            return this._oDocument;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public ViewEntry getLotusViewEntry() {
        return this._oViewEntry;
    }

    public Session getLotusSession() throws LotusPimException {
        try {
            return this.getLotusPimSession().getLotusSession();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    protected boolean isThisItemNew() {
        return this.getLotusViewEntryCollection() != null;
    }

    public ViewEntryCollection getLotusViewEntryCollection() {
        return this._oViewEntryCollection;
    }

    private Database getLotusDatabaseFromViewEntry() throws LotusPimException {
        try {
            Database database = ((ViewEntryCollection)this.getLotusViewEntry().getParent()).getParent().getParent();
            return database;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Document getLotusDocument() throws LotusPimException {
        try {
            if (this._oDocument == null) {
                ViewEntry viewEntry = this.getLotusViewEntry();
                if (this.createNewDocument) {
                    this.createDocument();
                    this.createNewDocument = false;
                } else if (viewEntry != null) {
                    String string = viewEntry.getNoteID();
                    this._oDocument = this.getLotusDatabaseFromViewEntry().getDocumentByID(string);
                    this.getRecycle().add(this._oDocument);
                }
            }
            return this._oDocument;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Database getLotusDatabase() throws LotusPimException {
        try {
            Database database = this.getLotusDocument().getParentDatabase();
            return database;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getID() throws LotusPimException {
        try {
            return this.getLotusDocument().getUniversalID();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        try {
            Vector vector = this.getLotusDocument().getItems();
            if (vector == null) {
                return null;
            }
            if (this.m_oPimFieldItems == null) {
                this.m_oPimFieldItems = new LotusPimFieldItems(vector, this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
            } else {
                this.m_oPimFieldItems.setLotusFields(vector, this.getLotusDocument());
            }
            return this.m_oPimFieldItems;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
        this.update(true, false);
    }

    private void update(boolean bl, boolean bl2) throws LotusPimException {
        try {
            if (this.getLotusDocument() == null) {
                return;
            }
            this.getLotusDocument().save(bl, true);
            if (this.getLotusViewEntryCollection() != null) {
                this.getLotusViewEntryCollection().addEntry((Object)this.getLotusDocument());
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(10L);
        }
    }

    public void delete() throws LotusPimException {
        try {
            if (this.getLotusDocument() == null) {
                return;
            }
            this.getLotusDocument().remove(true);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete(boolean bl) throws PimException {
        this.delete();
    }

    public String getName() throws LotusPimException {
        return "MessageItem";
    }

    public void clearRedundantAddresses(Document document) throws LotusPimException {
        try {
            String string;
            int n;
            Vector<String> vector;
            Vector vector2;
            HashSet<String> hashSet = new HashSet<String>();
            if (document.hasItem(SEND_TO)) {
                vector2 = document.getItemValue(SEND_TO);
                vector = new Vector<String>();
                n = 0;
                while (n < vector2.size()) {
                    string = (String)vector2.elementAt(n);
                    if (!hashSet.contains(string)) {
                        vector.add(string);
                        hashSet.add(string);
                    }
                    ++n;
                }
                document.replaceItemValue(SEND_TO, vector);
            }
            if (document.hasItem(COPY_TO)) {
                vector2 = document.getItemValue(COPY_TO);
                vector = new Vector();
                n = 0;
                while (n < vector2.size()) {
                    string = (String)vector2.elementAt(n);
                    if (!hashSet.contains(string)) {
                        vector.add(string);
                        hashSet.add(string);
                    }
                    ++n;
                }
                document.replaceItemValue(COPY_TO, vector);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (this.m_oPimRecipientItems == null) {
                if (document.hasItem(SEND_TO)) {
                    this.clearRedundantAddresses(document);
                    document.send(document.getItemValue(SEND_TO));
                    return;
                }
                throw new LotusPimException(18L);
            }
            Vector vector = this.m_oPimRecipientItems.getSendToVector();
            Vector vector2 = this.m_oPimRecipientItems.getCopyToVector();
            Vector vector3 = this.m_oPimRecipientItems.getBlindCopyToVector();
            if (vector.size() == 0) {
                throw new LotusPimException(19L);
            }
            document.replaceItemValue(SEND_TO, (Object)vector);
            document.replaceItemValue(COPY_TO, (Object)vector2);
            document.replaceItemValue(BLIND_COPY_TO, (Object)vector3);
            if (document.hasItem("$UpdatedBy")) {
                document.removeItem("$UpdatedBy");
            }
            this.clearRedundantAddresses(document);
            document.send(vector);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public LotusPimRecipientItems getLotusPimRecipientItems() {
        return this.m_oPimRecipientItems;
    }

    public Vector verifyEmails(Document document, String string) throws Exception {
        Vector vector = new Vector();
        if (document.hasItem(string)) {
            vector = document.getItemValue(string);
        }
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            String string2;
            String string3 = (String)vector.elementAt(n);
            if (string3.indexOf(string2 = "\u00fe") != -1) {
                vector2 = this.getLotusPimSession().getLotusSession().evaluate(string, document);
                break;
            }
            if (!string3.equals("")) {
                vector2.add(string3);
            }
            ++n;
        }
        return vector2;
    }

    public PimRecipientItems getRecipientItems() throws LotusPimException {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Document document = this.getLotusDocument();
            Recycle recycle = this.getRecycle();
            vector = this.verifyEmails(document, SEND_TO);
            vector2 = this.verifyEmails(document, COPY_TO);
            vector3 = this.verifyEmails(document, BLIND_COPY_TO);
            this.m_oPimRecipientItems = new LotusPimRecipientItems(this.getLotusSession(), this.getLotusPimSession(), this.getRecycle());
            this.m_oPimRecipientItems.setSendTo(vector);
            this.m_oPimRecipientItems.setCopyTo(vector2);
            this.m_oPimRecipientItems.setBlindCopyTo(vector3);
            return this.m_oPimRecipientItems;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    protected Document returnForwardDocument() throws LotusPimException {
        try {
            Document document;
            Document document2 = this.getLotusDocument();
            Recycle recycle = this.getRecycle();
            if (!document2.hasItem("From")) {
                document = document2.replaceItemValue("From", (Object)this.getLotusSession().getUserName());
            }
            if ((document = document2.createReplyMessage(false)) != null) {
                recycle.add(document);
                Vector vector = new Vector();
                document.replaceItemValue(SEND_TO, vector);
            }
            return document;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Date getStartTime() throws LotusPimException {
        return null;
    }

    public Date getEndTime() throws LotusPimException {
        return null;
    }

    public String getSubject() throws LotusPimException {
        return null;
    }

    public abstract PimMessageItem forward() throws PimException;
}

