/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimDeletedItem;
import com.aligo.pim.interfaces.PimMailAttachmentItems;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimMailAttachmentItems;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimUtility;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimMailMessageItem
extends LotusPimMessageItem
implements PimMailMessageItem,
PimDeletedItem {
    private LotusPimMailAttachmentItems lotusPimMailAttachmentItems;
    public static final String SUBJECT = "Subject";
    public static final String IMPORTANCE = "Importance";
    public static final String FROM = "From";
    public static final String DELIVERED_DATE = "DeliveredDate";
    public static final String BODY = "Body";
    public static final String FORM = "Form";
    public static final String MEMO = "Memo";
    public static final String PRINCIPAL = "Principal";
    public static final String NON_DELIVERY = "NonDelivery Report";
    public static final String REPLY = "Reply";

    public LotusPimMailMessageItem(ViewEntry viewEntry, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
    }

    public LotusPimMailMessageItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntryCollection, lotusPimSession, recycle);
    }

    public LotusPimMailMessageItem(Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
    }

    public void setLotusMailMessageItem(ViewEntry viewEntry) {
        this.setLotusMessageItem(viewEntry);
    }

    public String getSubject() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(SUBJECT)) {
                return document.getItemValueString(SUBJECT);
            }
            return "";
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimImportanceType getImportance() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(IMPORTANCE)) {
                String string = document.getItemValueString(IMPORTANCE);
                if (string.equals("0")) {
                    return PimImportanceType.NORMAL;
                }
                if (string.equals("1")) {
                    return PimImportanceType.HIGH;
                }
                if (string.equals("2")) {
                    return PimImportanceType.LOW;
                }
                return PimImportanceType.NORMAL;
            }
            return PimImportanceType.NORMAL;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public boolean getUnread() throws LotusPimException {
        try {
            return true;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private String getLotusAddressEntry() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(FROM)) {
                return document.getItemValueString(FROM);
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getSender() throws LotusPimException {
        try {
            return LotusPimUtility.getAddressEntryItem(this.getLotusSession(), this.getLotusAddressEntry(), this.getLotusPimSession(), this.getRecycle());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getTimeReceived() throws LotusPimException {
        try {
            Vector vector = this.getLotusDocument().getItemValue(DELIVERED_DATE);
            if (vector.size() != 0) {
                DateTime dateTime = (DateTime)vector.elementAt(0);
                Date date = dateTime.toJavaDate();
                return date;
            }
            DateTime dateTime = this.getLotusDocument().getCreated();
            return dateTime.toJavaDate();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getBody() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document.hasItem(BODY)) {
                return document.getItemValueString(BODY);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public void send() throws LotusPimException {
        try {
            Item item;
            Document document = this.getLotusDocument();
            if (!document.hasItem(FORM)) {
                item = document.replaceItemValue(FORM, (Object)MEMO);
            }
            item = document.replaceItemValue(PRINCIPAL, (Object)this.getLotusSession().getUserName());
            super.send();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void sendMeetingResponse() throws LotusPimException {
        try {
            Item item = this.getLotusDocument().replaceItemValue(FORM, (Object)"Notice");
            super.send();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMailMessageItem reply() throws LotusPimException {
        try {
            Document document = this.getLotusDocument().createReplyMessage(false);
            if (document == null) {
                return null;
            }
            this.getRecycle().add(document);
            LotusPimMailMessageItem lotusPimMailMessageItem = new LotusPimMailMessageItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimMailMessageItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMailMessageItem replyAll() throws LotusPimException {
        try {
            Document document = this.getLotusDocument().createReplyMessage(true);
            if (document == null) {
                return null;
            }
            this.getRecycle().add(document);
            LotusPimMailMessageItem lotusPimMailMessageItem = new LotusPimMailMessageItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimMailMessageItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            if (document == null) {
                return;
            }
            document.putInFolder("($Trash)");
            document.removeFromFolder("($Inbox)");
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete(boolean bl) throws PimException {
        try {
            Document document = this.getLotusDocument();
            if (document == null) {
                return;
            }
            if (bl) {
                document.putInFolder("($Trash)");
            }
            document.removeFromFolder("($Inbox)");
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            return this;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        return "MailMessageItem";
    }

    public PimMailAttachmentItems getAttachmentItems() throws LotusPimException {
        if (this.lotusPimMailAttachmentItems == null) {
            this.lotusPimMailAttachmentItems = new LotusPimMailAttachmentItems(this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
        }
        return this.lotusPimMailAttachmentItems;
    }

    public void setUnread(boolean bl) throws LotusPimException {
    }

    public boolean hasAttachment() throws PimException {
        if (this.lotusPimMailAttachmentItems == null) {
            this.lotusPimMailAttachmentItems = new LotusPimMailAttachmentItems(this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
        }
        return this.lotusPimMailAttachmentItems.getCount() > 0;
    }
}

