/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.ab;

import com.iplanet.sso.SSOToken;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.ab.AddressBookApplicationHelper;
import com.sun.portal.providers.ab.AddressBookProvider;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExchangeABHelper
implements AddressBookApplicationHelper {
    public AddressBookProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public Properties adapterProperties = null;
    protected String appName = "";
    protected String containerName = "";

    public void init(AddressBookProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
    }

    public String getStartURL(AddressBookProvider provider, HttpServletRequest request) {
        String url = null;
        try {
            url = this.getApplicationURL(provider, request);
            ProviderContext pc = provider.getProviderContext();
            url = pc.escape(url);
        }
        catch (Exception me) {
            SSOAdapterDebug.logWarning((String)(this.getClass().getName() + ".getStartURL(): could not determine start url "), (Throwable)me);
        }
        return url;
    }

    public String getApplicationURL(AddressBookProvider provider, HttpServletRequest request) throws Exception {
        String exchangeOperation;
        String host = this.adapterProperties.getProperty("host");
        String clientPort = this.adapterProperties.getProperty("clientPort", this.adapterProperties.getProperty("port", "80"));
        String clientProtocol = this.adapterProperties.getProperty("clientProtocol", "http");
        String exchangeContextPath = this.adapterProperties.getProperty("exchangeContextPath", "/exchange");
        String clientURL = clientProtocol + "://" + host + ":" + clientPort + exchangeContextPath;
        SSOToken tok = this.ssoAdapter.getSSOToken();
        if (tok != null && (exchangeOperation = this.adapterProperties.getProperty("exchangeOperation")) != null) {
            clientURL = clientURL + "/" + this.adapterProperties.getProperty("uid") + "/" + exchangeOperation;
        }
        return clientURL;
    }

    public void error(ProviderContext pc, String msg) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg);
        }
    }

    protected boolean isEmpty(String line) {
        return line == null || line.equals("");
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, AddressBookProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("CalendarExpressHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("CalendarExpressHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(this.getRequestParameter("provider", req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(this.getRequestParameter("containerName", req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("LDAPABApplicationHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }

    public void warning(ProviderContext pc, String msg) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg);
        }
    }

    public void message(ProviderContext pc, String msg) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg);
        }
    }

    public void error(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg, t);
        }
    }

    public void warning(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg, t);
        }
    }

    public void message(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg, t);
        }
    }

    public StringBuffer getAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = aprov.getProviderContext();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(aprov.getName(), "dpEditAttributes", pflist);
            fontTag = pc.getStringProperty(aprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
            ProviderEditUtility.setDefaultPresentation((String)aprov.getName(), (ProviderContext)aprov.getProviderContext(), tagTable);
        }
        catch (ProviderContextException pce) {
            this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
        }
        if (dpEditMap != null) {
            try {
                content.append((Object)pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append((Object)ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)aprov.getName(), (ProviderContext)pc, (boolean)true));
                }
            }
            try {
                content.append((Object)pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        }
        return content;
    }

    public String getSSOProperty(String key) {
        String tmp = this.adapterProperties.getProperty(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public String getRequestParameter(String key, HttpServletRequest req) {
        String tmp = req.getParameter(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public URL processAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = aprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        try {
            url = this.getAppHelperProcessURL(request, aprov);
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(aprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ExchangeABHelper.processAppPrefsEdit(): \n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = this.getRequestParameter(key, request);
                        if (reqString.equals("")) continue;
                        pc.setStringProperty(aprov.getName(), key, reqString);
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = this.getRequestParameter(key, request);
                        if (reqNumber.equals("")) continue;
                        pc.setIntegerProperty(aprov.getName(), key, Integer.parseInt(reqNumber));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = this.getRequestParameter(key, request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    pc.setBooleanProperty(aprov.getName(), key, bool.booleanValue());
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("ExchangeABHelper.processAppPrefsEdit(): \n", (Throwable)pce);
                }
            }
        }
        pc.debugMessage((Object)("ExchangeABApplicationHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }
}

