/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import java.io.FileNotFoundException;
import java.lang.reflect.Method;

public class BrowserType {
    private String browserName;
    private boolean netscapeBrowser = true;
    private boolean appleBrowser = false;
    private boolean ieBrowser = false;
    private boolean privDenied;
    private int version = 1;
    public static final int NETSCAPE_UNIVERSAL_CONNECT = 0;
    public static final int NETSCAPE_UNIVERSAL_LISTEN = 1;
    public static final int NETSCAPE_UNIVERSAL_ACCEPT = 3;
    public static final int NETSCAPE_UNIVERSAL_PREFERENCES_READ = 4;
    public static final int NETSCAPE_UNIVERSAL_PREFERENCES_WRITE = 5;
    public static final int NETSCAPE_UNIVERSAL_FILE_ACCESS = 6;
    public static final int NETSCAPE = 50;
    public static final int MICROSOFT = 51;
    public static final int OTHER = 52;
    static /* synthetic */ Class class$java$lang$String;

    public BrowserType() {
        String string;
        char c = System.getProperty("java.version").charAt(0);
        if (c > '1') {
            this.version = 2;
        }
        if ((c = System.getProperty("java.version").charAt(2)) > '2') {
            this.version = 2;
        }
        if ((string = System.getProperty("java.vendor").toUpperCase()).startsWith("APPLE")) {
            this.browserName = new String("MRJ");
            this.appleBrowser = true;
            this.netscapeBrowser = false;
        } else if (string.startsWith("NETSCAPE")) {
            this.browserName = new String("Netscape");
            this.netscapeBrowser = true;
        } else if (string.startsWith("MICROSOFT")) {
            this.browserName = new String("IE");
            this.ieBrowser = true;
            this.netscapeBrowser = false;
        } else {
            this.netscapeBrowser = false;
            if (this.version == 2) {
                this.browserName = "Java 2 Enabled browser";
            }
        }
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public boolean getNetscapeBrowser() {
        return this.netscapeBrowser;
    }

    public boolean getAppleBrowser() {
        return this.appleBrowser;
    }

    public boolean getIEBrowser() {
        return this.ieBrowser;
    }

    public boolean getPrivEnabled() {
        return this.privDenied;
    }

    public int getJavaVMVersion() {
        return this.version;
    }

    public SecurityCall enablePermission(int n) throws Exception {
        if (System.getProperty("os.name").toUpperCase().startsWith("MAC")) {
            return new SecurityCall(52);
        }
        if (this.version == 2) {
            return new SecurityCall(52);
        }
        try {
            Method method = null;
            if (this.getNetscapeBrowser()) {
                Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
                method = clazz.getMethod("enablePrivilege", class$java$lang$String == null ? (class$java$lang$String = BrowserType.class$("java.lang.String")) : class$java$lang$String);
                String string = null;
                switch (n) {
                    case 0: {
                        string = "UniversalConnect";
                        break;
                    }
                    case 1: {
                        string = "UniversalListen";
                        break;
                    }
                    case 3: {
                        string = "UniversalAccept";
                        break;
                    }
                    case 4: {
                        string = "UniversalPreferencesRead";
                        break;
                    }
                    case 5: {
                        string = "UniversalPreferencesWrite";
                        break;
                    }
                    case 6: {
                        string = "UniversalFileAccess";
                        break;
                    }
                    default: {
                        string = "UniversalConnect";
                    }
                }
                return new SecurityCall(50, method, new String[]{string});
            }
            return new SecurityCall();
        }
        catch (Exception exception) {
            if (!(exception instanceof ClassNotFoundException) && !(exception instanceof FileNotFoundException)) {
                throw exception;
            }
            return new SecurityCall();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new SecurityCall();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class SecurityCall {
        private int vendor;
        private Method method;
        private Object[] args;

        public SecurityCall() {
            this.vendor = 52;
            this.method = null;
            this.args = null;
        }

        public SecurityCall(int n) {
            this.vendor = n;
            this.method = null;
            this.args = null;
        }

        public SecurityCall(int n, Method method, Object[] objectArray) {
            this.vendor = n;
            this.method = method;
            this.args = objectArray;
        }

        public int getVendor() {
            return this.vendor;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }
}

