/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.pctest;

import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import com.sun.portal.providers.context.PropertiesFilterFactory;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PCTestProvider
extends ProfileProviderAdapter {
    private static String getParamString(String key, Map p) {
        String[] a = (String[])p.get(key);
        if (a == null) {
            return null;
        }
        return a[0];
    }

    public StringBuffer getContent(Map params) throws ProviderException {
        Hashtable<String, Object> tags = new Hashtable<String, Object>();
        tags.put("message", this.getStringProperty("message", true));
        tags.put("properties", this.getClientProperties());
        String cmd = PCTestProvider.getParamString(this.getName() + ".cmd", params);
        if (cmd != null) {
            String dpname;
            String pcname;
            String name;
            if (cmd.equals("get")) {
                tags.put("properties", this.getProperties());
            } else if (cmd.equals("getstring")) {
                name = PCTestProvider.getParamString("name", params);
                String l = PCTestProvider.getParamString("language", params);
                String c = PCTestProvider.getParamString("country", params);
                String v = PCTestProvider.getParamString("variant", params);
                tags.put("properties", this.getStringProperty(name));
            } else if (cmd.equals("getboolean")) {
                pcname = PCTestProvider.getParamString("name", params);
                tags.put("properties", new Boolean(this.getBooleanProperty(pcname)));
            } else if (cmd.equals("getlist")) {
                pcname = PCTestProvider.getParamString("name", params);
                tags.put("properties", this.getListProperty(pcname));
            } else if (cmd.equals("setstring")) {
                name = PCTestProvider.getParamString("name", params);
                String value = PCTestProvider.getParamString("value", params);
                this.setStringProperty(name, value);
                tags.put("properties", this.getProperties());
            } else if (cmd.equals("setlist")) {
                String dpval;
                ArrayList<String> vals = new ArrayList<String>();
                String dpname2 = PCTestProvider.getParamString("name", params);
                int i = 0;
                while ((dpval = PCTestProvider.getParamString("val" + i, params)) != null) {
                    vals.add(dpval);
                    ++i;
                }
                this.setListProperty(dpname2, vals);
                tags.put("properties", this.getProperties());
            } else if (cmd.equals("setboolean")) {
                dpname = PCTestProvider.getParamString("name", params);
                boolean dpval = new Boolean(PCTestProvider.getParamString("val", params));
                this.setBooleanProperty(dpname, dpval);
                tags.put("properties", this.getProperties());
            } else if (cmd.equals("setinteger")) {
                dpname = PCTestProvider.getParamString("name", params);
                int dpval = Integer.parseInt(PCTestProvider.getParamString("val", params));
                this.setIntegerProperty(dpname, dpval);
                tags.put("properties", this.getProperties());
            } else if (cmd.equals("setcollection")) {
                name = PCTestProvider.getParamString("name", params);
                String val = PCTestProvider.getParamString("value", params);
                StringTokenizer vals = new StringTokenizer(val, ",");
                HashMap<String, String> c = new HashMap<String, String>();
                while (vals.hasMoreTokens()) {
                    String v = vals.nextToken();
                    StringTokenizer pair = new StringTokenizer(v, ":");
                    String pairName = pair.nextToken();
                    String pairVal = pair.nextToken();
                    c.put(pairName, pairVal);
                }
                this.setMapProperty(name, c);
            } else if (cmd.equals("getcollection")) {
                name = PCTestProvider.getParamString("name", params);
                tags.put("properties", this.getMapProperty(name, true));
            } else if (cmd.equals("putcollection")) {
                name = PCTestProvider.getParamString("name", params);
                String val = PCTestProvider.getParamString("value", params);
                StringTokenizer pair = new StringTokenizer(val, ":");
                String pairName = pair.nextToken();
                String pairVal = pair.nextToken();
                ProviderContext pc = this.getProviderContext();
                Map m = this.getMapProperty(name);
                pc.debugError("PCTestProvider.getContent(): m=" + m);
                m.put(pairName, pairVal);
                pc.debugError("PCTestProvider.getContent(): after put, m=" + m);
                this.setMapProperty(name, m);
                pc.debugError("PCTestProvider.getContent(): after set, m=" + m);
            } else if (cmd.equals("getpfstring")) {
                name = PCTestProvider.getParamString("name", params);
                String filters = PCTestProvider.getParamString("filter", params);
                List pflist = this.getFilters(filters);
                tags.put("properties", "name=" + name + "<br> filters=" + pflist + "<br> value=" + this.getStringProperty(name, pflist));
            } else if (cmd.equals("getpfinteger")) {
                name = PCTestProvider.getParamString("name", params);
                String filters = PCTestProvider.getParamString("filter", params);
                List pflist = this.getFilters(filters);
                tags.put("properties", "name=" + name + "<br> filters=" + pflist + "<br> value=" + this.getIntegerProperty(name, pflist));
            } else if (cmd.equals("getpfboolean")) {
                name = PCTestProvider.getParamString("name", params);
                String filters = PCTestProvider.getParamString("filter", params);
                List pflist = this.getFilters(filters);
                tags.put("properties", "name=" + name + "<br> filters=" + pflist + "<br> value=" + this.getBooleanProperty(name, pflist));
            } else if (cmd.equals("getpfcollection")) {
                name = PCTestProvider.getParamString("name", params);
                String filters = PCTestProvider.getParamString("filter", params);
                List pflist = this.getFilters(filters);
                tags.put("properties", "name=" + name + "<br> filters=" + pflist + "<br> value=" + this.getMapProperty(name, pflist));
            } else if (cmd.equals("setpfstring")) {
                name = PCTestProvider.getParamString("name", params);
                String value = PCTestProvider.getParamString("value", params);
                String filters = PCTestProvider.getParamString("filter", params);
                List pflist = this.getFilters(filters);
                try {
                    this.getProviderContext().setStringProperty(this.getName(), name, value, pflist);
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("PCTestProvider.getContent(): ", pce);
                }
                tags.put("properties", "name=" + name + ", filters=" + pflist + ", value=" + this.getStringProperty(name, pflist));
            } else if (cmd.equals("setpfinteger")) {
                name = PCTestProvider.getParamString("name", params);
                String value = PCTestProvider.getParamString("value", params);
                String filters = PCTestProvider.getParamString("filter", params);
                List pflist = this.getFilters(filters);
                try {
                    this.getProviderContext().setIntegerProperty(this.getName(), name, Integer.parseInt(value), pflist);
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("PCTestProvider.getContent(): ", pce);
                }
                tags.put("properties", "name=" + name + ", filters=" + pflist + ", value=" + this.getIntegerProperty(name, pflist));
            } else if (cmd.equals("setpfboolean")) {
                name = PCTestProvider.getParamString("name", params);
                String value = PCTestProvider.getParamString("value", params);
                String filters = PCTestProvider.getParamString("filter", params);
                List pflist = this.getFilters(filters);
                try {
                    this.getProviderContext().setBooleanProperty(this.getName(), name, Boolean.getBoolean(value), pflist);
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("PCTestProvider.getContent(): ", pce);
                }
                tags.put("properties", "name=" + name + ", filters=" + pflist + ", value=" + this.getBooleanProperty(name, pflist));
            } else if (cmd.equals("setpfcollection")) {
                name = PCTestProvider.getParamString("name", params);
                String value = PCTestProvider.getParamString("value", params);
                String filters = PCTestProvider.getParamString("filter", params);
                StringTokenizer vals = new StringTokenizer(value, ",");
                HashMap<String, String> c = new HashMap<String, String>();
                while (vals.hasMoreTokens()) {
                    String v = vals.nextToken();
                    StringTokenizer pair = new StringTokenizer(v, ":");
                    String pairName = pair.nextToken();
                    String pairVal = pair.nextToken();
                    c.put(pairName, pairVal);
                }
                List pflist = this.getFilters(filters);
                try {
                    this.getProviderContext().setCollectionProperty(this.getName(), name, c, pflist);
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("PCTestProvider.getContent(): ", pce);
                }
                tags.put("properties", "name=" + name + ", filters=" + pflist + ", value=" + this.getMapProperty(name, pflist));
            }
        }
        StringBuffer b = this.getTemplate("content.template", tags);
        b.append("<br><br>").append((Object)this.testSession());
        return b;
    }

    protected StringBuffer getClientProperties() throws ProviderException {
        StringBuffer b = new StringBuffer();
        String val = null;
        ProviderContext ctx = this.getProviderContext();
        String countStr = ctx.getClientProperty("count");
        val = ctx.getClientType();
        b.append("clientType=" + val + "<br>");
        val = ctx.getContentType();
        b.append("contentType=" + val + "<br>");
        val = ctx.getClientPath();
        b.append("clientPath=" + val + "<br>");
        val = ctx.getCharset();
        b.append("charset=" + val + "<br>");
        val = ctx.getClientTypeProperty("cookieSupport");
        b.append("client property/cookieSupport=" + val + "<br>");
        return b;
    }

    protected StringBuffer getProperties() throws ProviderException {
        StringBuffer b = new StringBuffer();
        try {
            Iterator i = this.getProviderContext().getNames(this.getName());
            while (i.hasNext()) {
                String name = (String)i.next();
                Object val = this.getProviderContext().getProperty(this.getName(), name);
                b.append(name + "=" + val.toString() + "<br>");
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("PCTestProvider.getProperties(): ", pce);
        }
        return b;
    }

    protected StringBuffer testSession() throws ProviderException {
        StringBuffer buf = new StringBuffer();
        ProviderContext ctx = this.getProviderContext();
        String countStr = ctx.getClientProperty("count");
        int count = 0;
        if (countStr != null && countStr.length() > 0) {
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException nfe) {
                ctx.debugError("PCTestProvider.testSession()", nfe);
            }
        }
        buf.append("This number should increment by 1 everytime you load this page:  <b>").append(Integer.toString(++count)).append("</b><br>");
        if (count > 1) {
            buf.append("Your last visit was at ").append(ctx.getClientProperty("timestamp"));
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.US);
        String timestamp = dateFormat.format(new Date());
        ctx.setClientProperty("count", Integer.toString(count));
        ctx.setClientProperty("timestamp", timestamp);
        return buf;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Hashtable<String, String> tags = new Hashtable<String, String>();
        tags.put("message", this.getStringProperty("message"));
        tags.put("properties", "");
        StringBuffer b = this.getTemplate("content.template", tags);
        return b;
    }

    public List getFilters(String filters) throws ProviderException {
        ArrayList<PropertiesFilter> pflist = new ArrayList<PropertiesFilter>();
        StringTokenizer st = new StringTokenizer(filters, ";");
        while (st.hasMoreTokens()) {
            String filter = st.nextToken();
            StringTokenizer stz = new StringTokenizer(filter, ":");
            String type = stz.nextToken();
            String value = stz.nextToken();
            boolean exact = stz.nextToken().toLowerCase().equals("true");
            PropertiesFilter pf = null;
            try {
                pf = PropertiesFilterFactory.get(type, value, exact);
            }
            catch (PropertiesFilterException pfe) {
                throw new ProviderException("PCTestProvider.getFilters(): ", pfe);
            }
            pflist.add(pf);
        }
        return pflist;
    }
}

