/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp.jasper3.jasper.servlet;

import com.sun.portal.providers.jsp.jasper3.jasper.Constants;
import com.sun.portal.providers.jsp.jasper3.jasper.EmbededServletOptions;
import com.sun.portal.providers.jsp.jasper3.jasper.JasperException;
import com.sun.portal.providers.jsp.jasper3.jasper.JspCompilationContext;
import com.sun.portal.providers.jsp.jasper3.jasper.JspEngineContext;
import com.sun.portal.providers.jsp.jasper3.jasper.JspFactory;
import com.sun.portal.providers.jsp.jasper3.jasper.Options;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.Compiler;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.JspMangler;
import com.sun.portal.providers.jsp.jasper3.jasper.runtime.HttpJspBase;
import com.sun.portal.providers.jsp.jasper3.jasper.runtime.JspFactoryImpl;
import com.sun.portal.providers.jsp.jasper3.jasper.servlet.JasperLoader;
import com.sun.portal.providers.jsp.jasper3.tomcat.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JspServlet
extends HttpServlet {
    protected ServletContext context = null;
    protected Hashtable jsps = new Hashtable();
    protected ServletConfig config;
    protected JasperLoader loader;
    protected Options options;
    protected ClassLoader parentClassLoader;
    protected String serverInfo;
    protected boolean loadPrecompiledJsps = false;
    protected long reloadInterval = 0L;
    static boolean firstTime = true;
    static boolean jdk12 = false;

    public void init(ServletConfig config) throws ServletException {
        String usePrecompiled;
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        int reloadIntervalInSec = (Integer)this.context.getAttribute("com.iplanet.server.http.servlet.reload-interval");
        if (reloadIntervalInSec > 0) {
            this.reloadInterval = reloadIntervalInSec * 1000;
        }
        this.options = new EmbededServletOptions(config, this.context);
        this.parentClassLoader = (ClassLoader)this.context.getAttribute("com.iplanet.server.http.servlet.classloader");
        if (this.parentClassLoader == null) {
            this.parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()}, 4);
        } else {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{"<none>"}, 4);
        }
        if (this.loader == null) {
            this.createJasperLoader();
        }
        if (firstTime) {
            firstTime = false;
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()}, 3);
            Constants.message("jsp.message.dont.modify.servlets", 3);
            JspFactory.setPsFactory(new JspFactoryImpl());
        }
        if ((usePrecompiled = config.getInitParameter("use-precompiled")) != null && usePrecompiled.equalsIgnoreCase("true")) {
            this.loadPrecompiledJsps = true;
            Constants.message("jsp.message.precompiled_jsps", 3);
        }
    }

    private void createJasperLoader() throws JasperException {
        if (jdk12) {
            try {
                Class<?> ld = Class.forName("com.sun.portal.providers.jsp.jasper3.jasper.servlet.JasperLoader12");
                this.loader = (JasperLoader)ld.newInstance();
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
        }
        if (this.loader == null) {
            this.loader = new JasperLoader();
        }
        if (this.loader != null) {
            this.loader.setParentClassLoader(this.parentClassLoader);
            this.loader.setOptions(this.options);
            Object pd = this.context.getAttribute("com.sun.portal.providers.jsp.jasper3.tomcat.protection_domain");
            this.loader.setProtectionDomain(pd);
        }
    }

    private void unloadJsps() {
        Enumeration servlets = this.jsps.elements();
        while (servlets.hasMoreElements()) {
            ((JspServletWrapper)servlets.nextElement()).tryDestroy();
        }
        this.jsps.clear();
    }

    private synchronized void reloadJsps() throws JasperException {
        this.unloadJsps();
        this.createJasperLoader();
    }

    private JspServletWrapper getWrapper(String jspUri) {
        JspServletWrapper wrapper = (JspServletWrapper)this.jsps.get(jspUri);
        if (wrapper != null) {
            wrapper.incrementRefCount();
        }
        return wrapper;
    }

    private void releaseWrapper(JspServletWrapper wrapper) {
        if (wrapper != null) {
            wrapper.decrementRefCount();
        }
    }

    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        Object object;
        String accordingto;
        boolean isErrorPage = exception != null;
        String classpath = (String)this.context.getAttribute("com.iplanet.server.http.servlet.classpath");
        if (classpath == null || classpath.equals("")) {
            accordingto = "according to the init parameter";
            classpath = this.options.getClassPath();
        } else {
            accordingto = "according to the Servlet Engine";
        }
        Constants.message("jsp.message.cp_is", new Object[]{accordingto, classpath == null ? "" : classpath}, 3);
        JspEngineContext ctxt = new JspEngineContext(this.loader, classpath, this.context, jspUri, isErrorPage, this.options, request, response);
        JspServletWrapper wrapper = this.getWrapper(jspUri);
        boolean error = false;
        if (wrapper == null) {
            object = this;
            synchronized (object) {
                wrapper = this.getWrapper(jspUri);
                if (wrapper == null) {
                    String jspFileName = ctxt.getRealPath(ctxt.getJspFile());
                    if (this.loadPrecompiledJsps || jspFileName != null) {
                        wrapper = new JspServletWrapper(jspUri, jspFileName, isErrorPage);
                        wrapper.incrementRefCount();
                        this.jsps.put(jspUri, wrapper);
                    } else {
                        try {
                            response.sendError(404);
                        }
                        catch (IllegalStateException ise) {
                            // empty catch block
                        }
                        Constants.message("jsp.error.file.not.found", new Object[]{ctxt.getJspFile()}, 1);
                        error = true;
                    }
                }
            }
        }
        if (error) {
            return;
        }
        try {
            if (!wrapper.servletLoaded()) {
                object = wrapper;
                synchronized (object) {
                    if (!wrapper.servletLoaded()) {
                        try {
                            wrapper.loadJSP(ctxt);
                        }
                        catch (FileNotFoundException ex) {
                            try {
                                response.sendError(404);
                            }
                            catch (IllegalStateException ise) {
                                // empty catch block
                            }
                            Constants.jasperLog.log(Constants.getString("jsp.error.file.not.found", new Object[]{ex.getMessage()}), ex, 1);
                            error = true;
                        }
                    }
                }
            }
            if (!this.loadPrecompiledJsps && wrapper.isJspFileModified()) {
                boolean doReload = false;
                if (wrapper.isValid()) {
                    JspServletWrapper jspServletWrapper = wrapper;
                    synchronized (jspServletWrapper) {
                        if (wrapper.isValid()) {
                            wrapper.tryDestroy();
                            doReload = true;
                        }
                    }
                }
                if (doReload) {
                    this.reloadJsps();
                }
            }
            if (!precompile && !error) {
                wrapper.service(request, response);
            }
            Object var19_21 = null;
            this.releaseWrapper(wrapper);
            wrapper = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.releaseWrapper(wrapper);
            wrapper = null;
            throw throwable;
        }
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String precom;
        boolean precompile = false;
        String qString = request.getQueryString();
        if (qString != null && (qString.startsWith("jsp_precompile") || qString.indexOf("&jsp_precompile") != -1) && (precom = request.getParameter("jsp_precompile")) != null) {
            if (precom.equals("") || precom.equals("true") || precom.equals("\"true\"")) {
                precompile = true;
            } else if (precom.equals("false") || precom.equals("\"false\"")) {
                precompile = false;
            } else {
                throw new ServletException("Can't have request parameter jsp_precomile set to " + precom);
            }
        }
        return precompile;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String jspUri = includeUri == null ? request.getServletPath() : includeUri;
            boolean precompile = this.preCompile(request);
            Logger jasperLog = Constants.jasperLog;
            if (jasperLog != null && jasperLog.matchVerbosityLevel(3)) {
                jasperLog.log("JspEngine --> " + jspUri);
                jasperLog.log("\t     ServletPath: " + request.getServletPath());
                jasperLog.log("\t        PathInfo: " + request.getPathInfo());
                jasperLog.log("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(jspUri));
                jasperLog.log("\t      RequestURI: " + request.getRequestURI());
                jasperLog.log("\t     QueryString: " + request.getQueryString());
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        this.unloadJsps();
        this.loader = null;
    }

    static {
        try {
            Class.forName("java.security.PrivilegedAction");
            jdk12 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class JspServletWrapper {
        Servlet theServlet = null;
        String jspUri;
        boolean isErrorPage;
        Class servletClass;
        int refCount = 0;
        boolean markedForDestroy = false;
        volatile long lastCheckedTime = 0L;
        File jspFile;
        JasperException compileException = null;

        JspServletWrapper(String jspUri, String jspFileName, boolean isErrorPage) {
            this.jspUri = jspUri;
            this.isErrorPage = isErrorPage;
            if (!JspServlet.this.loadPrecompiledJsps) {
                this.jspFile = new File(jspFileName);
            }
        }

        private boolean servletLoaded() {
            return this.theServlet != null;
        }

        private boolean isValid() {
            return !this.markedForDestroy;
        }

        private void loadAndInit(JspCompilationContext ctxt) throws JasperException, ServletException {
            JspMangler mangler = new JspMangler(ctxt.getJspFile(), ctxt.getOutputDir());
            String fullClassName = mangler.getPackageName() + "." + mangler.getClassName();
            try {
                this.servletClass = JspServlet.this.loader.loadClass(fullClassName);
            }
            catch (ClassNotFoundException cex) {
                Constants.message("jsp.warning.load_failure", new Object[]{fullClassName}, 2);
                throw new JasperException(Constants.getString("jsp.error.unable.load"), cex);
            }
            Constants.message("jsp.debug.load_success", new Object[]{fullClassName}, 4);
            try {
                this.theServlet = (Servlet)this.servletClass.newInstance();
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
            this.theServlet.init(JspServlet.this.config);
            if (this.theServlet instanceof HttpJspBase) {
                HttpJspBase h = (HttpJspBase)this.theServlet;
                h.setClassLoader(JspServlet.this.parentClassLoader);
            }
        }

        private void loadJSP(JspCompilationContext ctxt) throws JasperException, FileNotFoundException, ServletException {
            if (JspServlet.this.loadPrecompiledJsps) {
                if (!this.servletLoaded()) {
                    try {
                        this.loadAndInit(ctxt);
                        return;
                    }
                    catch (JasperException e) {}
                } else {
                    Constants.message("jsp.debug.precompiled.no_reload", 4);
                    return;
                }
            }
            if (this.compileException != null && !this.isJspFileModified()) {
                throw this.compileException;
            }
            try {
                this.lastCheckedTime = System.currentTimeMillis();
                Compiler compiler = ctxt.createCompiler();
                compiler.compile();
                this.loadAndInit(ctxt);
                this.compileException = null;
            }
            catch (FileNotFoundException ex) {
                this.compileException = null;
                throw ex;
            }
            catch (JasperException ex) {
                this.compileException = ex;
                throw this.compileException;
            }
            catch (Exception ex) {
                this.compileException = new JasperException(Constants.getString("jsp.error.unable.compile"), ex);
                throw this.compileException;
            }
        }

        boolean isJspFileModified() {
            boolean res = false;
            long currTime = System.currentTimeMillis();
            if (currTime > JspServlet.this.reloadInterval + this.lastCheckedTime) {
                long jspLastModTime = this.jspFile.lastModified();
                if (jspLastModTime == 0L || jspLastModTime > this.lastCheckedTime) {
                    res = true;
                }
                this.lastCheckedTime = currTime;
            }
            return res;
        }

        private void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (this.theServlet instanceof SingleThreadModel) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                this.theServlet.service((ServletRequest)request, (ServletResponse)response);
            }
        }

        private synchronized void incrementRefCount() {
            ++this.refCount;
        }

        private synchronized void decrementRefCount() {
            --this.refCount;
            if (this.refCount == 0 && this.markedForDestroy) {
                this.destroy();
            }
        }

        private void tryDestroy() {
            if (this.refCount == 0) {
                this.destroy();
            }
            this.markedForDestroy = true;
        }

        private void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
                this.servletClass = null;
                this.theServlet = null;
            }
        }
    }
}

