/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter;

import com.sun.portal.rewriter.AbstractTranslator;
import com.sun.portal.rewriter.JSFunctionSpec;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rewriter.util.uri.PageSpec;
import com.sun.portal.rproxy.rewriter.SRAPJSFunctionSpec;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import com.sun.portal.rproxy.rewriter.util.uri.SRAPGatewayURI;

public class SRAPTranslator
extends AbstractTranslator {
    private JSFunctionSpec srapJSFunctionSpec;
    private SRAPGatewayURI gatewayURI;

    public SRAPTranslator(SRAPGatewayURI sRAPGatewayURI, PageSpec pageSpec) {
        super(pageSpec);
        this.init(sRAPGatewayURI);
    }

    private void init(SRAPGatewayURI sRAPGatewayURI) {
        this.gatewayURI = sRAPGatewayURI;
        this.srapJSFunctionSpec = new SRAPJSFunctionSpec(this.gatewayURI);
    }

    public JSFunctionSpec getJSFunctionSpec() {
        return this.srapJSFunctionSpec;
    }

    public String hook4Translate(DecoratedURI decoratedURI, DecoratedURI decoratedURI2) {
        if (!this.needs2Translate(decoratedURI) || SRAPConfigManager.isNot2RewriteURI(decoratedURI)) {
            return decoratedURI.getInputString();
        }
        return SRAPTranslatorHelper.prefixGateway(this.gatewayURI, decoratedURI2);
    }

    public SRAPGatewayURI getGatewayURI() {
        return this.gatewayURI;
    }

    private boolean needs2Translate(DecoratedURI decoratedURI) {
        String string = decoratedURI.getProtocol().toLowerCase();
        String string2 = decoratedURI.getHost().toLowerCase();
        if (!string.equals("http") && !string.equals("https") || string2.equals("localhost") || string2.equals("127.0.0.1")) {
            return false;
        }
        if (SRAPConfigManager.isIntranet(string2)) {
            return true;
        }
        return SRAPConfigManager.isRewriteSRCValue() && this.getLookAheadInfo().getTagContext().isSRC() && string.equals("http") && this.gatewayURI.getProtocol().equalsIgnoreCase("https");
    }
}

