/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.rproxy.cert.CertAdminPasswordCallback;
import com.sun.portal.util.GWDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.PasswordCallback;

public class GWNSSInit {
    public static String nickname = "server-cert";
    public static final int[] cipherSuites128BitSSL2 = new int[]{65287, 65283, 65281};
    public static final int[] cipherSuites128BitSSL3 = new int[]{10, 4, 5, 30, 65279};
    public static final int[] cipherSuites40BitSSL2 = new int[]{65284, 65282};
    public static final int[] cipherSuites40BitSSL3 = new int[]{3, 6};
    public static final int[] cipherSuitesOthersSSL2 = new int[]{65286};
    public static final int[] cipherSuitesOthersSSL3 = new int[]{9, 29, 65278};
    public static final int[] cipherSuitesSSL3Null = new int[]{1, 28};
    public static final int[] cipherSuites128BitTLS = new int[0];
    public static final int[] cipherSuitesOthersTLS = new int[]{98, 100};
    private static final int[] cipherSuitesNotSupported = new int[]{102};

    public static void enableAllCiphers() {
        GWNSSInit.enableCipher(cipherSuites40BitSSL2);
        GWNSSInit.enableCipher(cipherSuites40BitSSL3);
        GWNSSInit.enableCipher(cipherSuitesOthersSSL2);
        GWNSSInit.enableCipher(cipherSuitesOthersSSL3);
        GWNSSInit.enableCipher(cipherSuites128BitSSL2);
        GWNSSInit.enableCipher(cipherSuites128BitSSL3);
        GWNSSInit.enableCipher(cipherSuitesOthersTLS);
        GWNSSInit.enableCipher(cipherSuites128BitTLS);
        GWNSSInit.enableCipher(cipherSuitesSSL3Null);
    }

    public static void disableAllCiphers() {
        GWNSSInit.disableCipher(cipherSuites40BitSSL2);
        GWNSSInit.disableCipher(cipherSuites40BitSSL3);
        GWNSSInit.disableCipher(cipherSuitesOthersSSL2);
        GWNSSInit.disableCipher(cipherSuitesOthersSSL3);
        GWNSSInit.disableCipher(cipherSuites128BitSSL2);
        GWNSSInit.disableCipher(cipherSuites128BitSSL3);
        GWNSSInit.disableCipher(cipherSuitesOthersTLS);
        GWNSSInit.disableCipher(cipherSuites128BitTLS);
        GWNSSInit.disableCipher(cipherSuitesSSL3Null);
    }

    public static void enableCipher(int[] nArray) {
        GWNSSInit.setCipherState(nArray, true);
    }

    public static void disableCipher(int[] nArray) {
        GWNSSInit.setCipherState(nArray, false);
    }

    private static void setCipherState(int[] nArray, boolean bl) {
        int n = 0;
        while (n < nArray.length) {
            SSLSocket.setCipherPreference((int)nArray[n], (boolean)bl);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static boolean initialize() {
        String string;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        String string2;
        block20: {
            string2 = System.getProperty("gateway.keybase", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps"));
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: certdbDir = " + string2);
            }
            try {
                JSSUtil.setDefaultDecoder((String)string2);
            }
            catch (SRADecoderException sRADecoderException) {
                GWDebug.debug.error("GWNSSInit: Unable to initialize the password encryption module : " + sRADecoderException.getMessage());
            }
            String string3 = System.getProperty("gateway.nickname", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps") + File.separatorChar + "cert" + File.separatorChar + ".nickname");
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: nicknamefile = " + string3);
            }
            if (string3 != null) {
                try {
                    fileInputStream = new FileInputStream(string3);
                    inputStreamReader = new InputStreamReader(fileInputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    nickname = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("GWNSSInit: Unable to read jss nickname from file " + string3);
                    }
                    break block20;
                }
            }
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("GWNSSInit: Unable to get nickname file name");
            }
        }
        String string4 = System.getProperty("gateway.pass", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps") + File.separatorChar + "cert" + File.separatorChar + ".jsspass");
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("GWNSSInit: pwfile = " + string4);
        }
        if (string4 == null) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Unable to get password file name");
            return false;
        }
        try {
            fileInputStream = new FileInputStream(string4);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            Password password = JSSUtil.decryptPassword((String)string);
            string = password.getPassword();
            if (password.isEncrypted() && GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: Found encrypted password");
            }
        }
        catch (Exception exception) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Unable to read jss password from file " + string4);
            return false;
        }
        try {
            fileInputStream = new CryptoManager.InitializationValues(string2);
            CryptoManager.initialize((CryptoManager.InitializationValues)fileInputStream);
            CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new CertAdminPasswordCallback(string));
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("GWNSSInit: NSSInit initialization done successfully");
            }
        }
        catch (KeyDatabaseException keyDatabaseException) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Couldn't open the key database." + (Object)((Object)keyDatabaseException));
            return false;
        }
        catch (CertDatabaseException certDatabaseException) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Couldn't open the certificate database." + (Object)((Object)certDatabaseException));
            return false;
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            if (!GWDebug.debug.warningEnabled()) return true;
            GWDebug.debug.warning("GWNSSInit: CryptoManager already initialized." + (Object)((Object)alreadyInitializedException));
            return true;
        }
        catch (Exception exception) {
            if (!GWDebug.debug.errorEnabled()) return false;
            GWDebug.debug.error("GWNSSInit: Exception occurred: " + exception.getMessage());
            return false;
        }
        GWNSSInit.disableCipher(cipherSuitesNotSupported);
        GWNSSInit.enableAllCiphers();
        return true;
    }
}

