/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.connectionhandler.DomainWebProxyConfig;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.PingServiceRequest;
import com.sun.portal.util.ProxyAuthFailedException;
import com.sun.portal.util.ProxyAuthNeededException;
import com.sun.portal.util.ProxyUnreachableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sun.misc.BASE64Decoder;

public class ApplicationLoginHostChooser
extends HostAvailabilityListener {
    private LinkedList serverList = null;
    private Iterator serverListIterator = null;
    private int serverListSize = 0;
    private static ApplicationLoginHostChooser instance = new ApplicationLoginHostChooser();
    private boolean isInitialised = false;
    private static final int PROXY_HTTP_PORT = 8080;
    private URL currentHostInUse = null;

    private ApplicationLoginHostChooser() {
    }

    public static ApplicationLoginHostChooser getInstance() {
        return instance;
    }

    private void populatePlatformHosts() {
        List list = GatewayProfile.getStringList("PortalServerList");
        this.serverList = new LinkedList(list);
        this.serverListIterator = this.serverList.iterator();
        this.serverListSize = this.serverList.size();
        this.isInitialised = true;
        this.addHostAvailabilityListener(this);
    }

    private boolean isServerAlive(String string) {
        block20: {
            try {
                URL uRL = new URL(string);
                String string2 = DomainWebProxyConfig.getWebProxy(uRL.getProtocol(), uRL.getHost());
                String string3 = null;
                int n = -1;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                PingServiceRequest pingServiceRequest = null;
                if (string2 == null) {
                    pingServiceRequest = new PingServiceRequest(uRL);
                } else {
                    block19: {
                        int n2 = string2.indexOf(58);
                        if (n2 == -1) {
                            n = 8080;
                            string3 = string2;
                        } else {
                            string3 = string2.substring(0, string2.indexOf(58));
                            n = Integer.parseInt(string2.substring(string2.indexOf(58) + 1));
                        }
                        string4 = HTTPRetriever.getProxyPassword(string3);
                        if (string4 != null) {
                            BASE64Decoder bASE64Decoder = new BASE64Decoder();
                            try {
                                string4 = new String(bASE64Decoder.decodeBuffer(string4));
                            }
                            catch (Exception exception) {
                                if (!GWDebug.debug.errorEnabled()) break block19;
                                GWDebug.debug.error("Password decode failed:", exception);
                            }
                        }
                    }
                    if (string4 == null) {
                        pingServiceRequest = new PingServiceRequest(uRL, string3, n);
                    } else {
                        string5 = string4.substring(0, string4.indexOf(58)).trim();
                        string6 = string4.substring(string4.indexOf(58) + 1).trim();
                        pingServiceRequest = new PingServiceRequest(uRL, string3, n, string5, string6);
                    }
                }
                return pingServiceRequest.isServiceAlive();
            }
            catch (NumberFormatException numberFormatException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Bad Proxy Port", numberFormatException);
                }
            }
            catch (ProxyUnreachableException proxyUnreachableException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Proxy used for reaching Portal Server Proxy is down:", proxyUnreachableException);
                }
            }
            catch (ProxyAuthNeededException proxyAuthNeededException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Proxy password not found for authentication", proxyAuthNeededException);
                }
            }
            catch (ProxyAuthFailedException proxyAuthFailedException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Proxy Authentication Failed", proxyAuthFailedException);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!GWDebug.debug.errorEnabled()) break block20;
                GWDebug.debug.error("Malformed URL", malformedURLException);
            }
        }
        return false;
    }

    private String getPlatFormServerURL() {
        if (!this.serverListIterator.hasNext()) {
            this.serverListIterator = this.serverList.iterator();
        }
        return this.serverListIterator.next().toString();
    }

    public synchronized URL getAlivePlatFormServerURL() {
        URL uRL = null;
        String string = null;
        if (!this.isInitialised && PlatformProfile.isInitialised()) {
            this.populatePlatformHosts();
        }
        if (this.isInitialised) {
            int n = 0;
            while (n < this.serverListSize && string == null) {
                ++n;
                string = this.getPlatFormServerURL();
                String string2 = string = this.isServerAlive(string) ? string : null;
            }
        } else {
            String string3 = System.getProperty("gateway.dsame.agent");
            string = string3.substring(0, string3.indexOf("/", string3.indexOf("://") + 3));
        }
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                uRL = null;
            }
        }
        this.currentHostInUse = uRL;
        return uRL;
    }

    public void hostAvailabilityChanged(HostAvailabilityEvent hostAvailabilityEvent) {
        boolean bl = false;
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Host avaliability changed : " + hostAvailabilityEvent.getEventType() + " for " + hostAvailabilityEvent.getHost());
        }
        if (!this.isInitialised || this.currentHostInUse == null) {
            bl = true;
        } else if (hostAvailabilityEvent.getEventType() == 2) {
            try {
                URL uRL = new URL(hostAvailabilityEvent.getHost());
                if (uRL.getHost().equalsIgnoreCase(this.currentHostInUse.getHost()) && uRL.getPort() == this.currentHostInUse.getPort()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Host avaliability changed -> Host : " + hostAvailabilityEvent.getHost() + " needRecreate app session : " + bl);
        }
        if (bl) {
            this.recreateLoginSession();
        }
    }

    private void recreateLoginSession() {
        GWLogManager.createNewAppSession();
    }

    static {
        instance = new ApplicationLoginHostChooser();
    }
}

