/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange.test;

import com.aligo.messaging.exchange.auth.AligoAuthFactory;
import com.aligo.messaging.exchange.cdo.AddressEntryProxy;
import com.aligo.messaging.exchange.cdo.FieldProxy;
import com.aligo.messaging.exchange.cdo.FieldsProxy;
import com.aligo.messaging.exchange.cdo.Session;
import com.linar.jintegra.AuthInfo;
import com.linar.jintegra.Cleaner;
import com.linar.jintegra.Log;
import com.linar.ocxhost.Container;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Test
extends JFrame {
    private JPanel settingsPanel;
    private JLabel userNameLabel;
    private JTextField userNameTextField;
    private JLabel passwordLabel;
    private JTextField passwordTextField;
    private JLabel domainLabel;
    private JTextField domainTextField;
    private JLabel exchangeServerLabel;
    private JTextField exchangeServerTextField;
    private JLabel mailBoxLabel;
    private JTextField mailBoxTextField;
    private JLabel ocxHostLocation;
    private JTextField ocxHostTextField;
    private JLabel aligoAuthLocation;
    private JTextField aligoAuthTextField;
    private JLabel logsLocation;
    private JTextField logsTextField;
    private JPanel buttonsPanel;
    private JButton connectButton;
    private JButton cancelButton;

    public Test() {
        this.initComponents();
        this.defineListeners();
        this.pack();
        ((Component)this).setSize(400, 375);
        this.setTitle("Exchange Connection Test Editor");
        this.centerComponent(this);
    }

    public void defineListeners() {
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Test.this.processConnect();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Test.this.processExit();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processConnect() {
        StringBuffer strb;
        block16: {
            System.out.println("Trying to Connect");
            strb = new StringBuffer();
            try {
                block15: {
                    try {
                        Log.logImmediately((int)3, (String)this.logsTextField.getText());
                        AuthInfo.setDefault((String)this.domainTextField.getText(), (String)this.userNameTextField.getText(), (String)this.passwordTextField.getText());
                        Container container = new Container(this.ocxHostTextField.getText());
                        Session s = new Session(container.create("MAPI.Session.1"));
                        s.logon(null, null, null, null, null, null, this.exchangeServerTextField.getText() + "\n" + this.userNameTextField.getText());
                        strb.append("The Application is =" + s.getApplication() + "\n");
                        System.out.println("The Application is =" + s.getApplication());
                        strb.append("The current user is =" + s.getCurrentUser() + "\n");
                        System.out.println("The current user is =" + s.getCurrentUser());
                        AddressEntryProxy addEntry = new AddressEntryProxy(s.getCurrentUser());
                        strb.append("The current user name is =" + addEntry.getName() + "\n");
                        System.out.println("The current user name is =" + addEntry.getName());
                        strb.append("The class is  =" + s.getClass() + "\n");
                        System.out.println("The class is  =" + s.getClass());
                        strb.append("The name of the profile is =" + s.getName() + "\n");
                        System.out.println("The name of the profile is =" + s.getName());
                        strb.append("The version of CDO is=" + s.getVersion() + "\n");
                        System.out.println("The version of CDO is=" + s.getVersion());
                        strb.append("The operating system is=" + s.getOperatingSystem() + "\n");
                        System.out.println("The operating system is=" + s.getOperatingSystem());
                        String authenticationLocation = this.aligoAuthTextField.getText();
                        boolean authDebug = true;
                        boolean isAuthSuccess = true;
                        if (authenticationLocation.equals("")) {
                            authDebug = false;
                        }
                        if (authDebug) {
                            String szNTLMAuthenticate;
                            StringTokenizer ntlmTokenizer;
                            isAuthSuccess = false;
                            AddressEntryProxy _oAddressEntry = new AddressEntryProxy(s.getCurrentUser());
                            FieldsProxy _oFields = new FieldsProxy(_oAddressEntry.getFields());
                            FieldProxy _oField = new FieldProxy(_oFields.getItem(new Integer(-2144927486), null));
                            String _oSid = (String)_oField.getValue();
                            AligoAuthFactory _oAligoAuthFactory = new AligoAuthFactory(this.aligoAuthTextField.getText());
                            String[] userNameAuth = new String[]{this.userNameTextField.getText()};
                            String[] passwordAuth = new String[]{this.passwordTextField.getText()};
                            String[] domainAuth = new String[]{this.domainTextField.getText()};
                            String[] mailboxAuth = new String[]{this.userNameTextField.getText()};
                            String[] sidAuth = new String[]{_oSid};
                            int iErrorCode = 0;
                            String returnCode = _oAligoAuthFactory.authenticateDebug(userNameAuth, passwordAuth, domainAuth, mailboxAuth, sidAuth);
                            strb.append("Return Code From AuthModule =" + returnCode + "\n");
                            System.out.println("Return Code From AuthModule =" + returnCode);
                            strb.append("SID of " + userNameAuth[0] + " =" + sidAuth[0] + "\n");
                            System.out.println("SID of " + userNameAuth[0] + " =" + sidAuth[0]);
                            StringTokenizer returnCodeTokenizer = new StringTokenizer(returnCode, ",");
                            if (returnCodeTokenizer.hasMoreTokens() && (ntlmTokenizer = new StringTokenizer(szNTLMAuthenticate = returnCodeTokenizer.nextToken(), "=")).hasMoreTokens()) {
                                ntlmTokenizer.nextToken();
                                iErrorCode = Integer.parseInt(ntlmTokenizer.nextToken());
                            }
                            if (iErrorCode != 0) {
                                switch (iErrorCode) {
                                    case 1: {
                                        strb.append("ERROR:  Authenticating module has problems launching. The user need to have user level access in the machine. No authenticating authority available to launch. Please enable user level access in Win95/Win98. It can be set in control panel/network/access control/user level access control..");
                                        System.out.println("ERROR: Authenticating module has problems launching. The user need to have user level access in the machine. No authenticating authority available to launch. Please enable user level access in Win95/Win98. It can be set in control panel/network/access control/user level access control..");
                                        break;
                                    }
                                    case 2: {
                                        strb.append("ERROR: Incorrect username, password or domain");
                                        System.out.println("ERROR: Incorrect username, password or domain");
                                        break;
                                    }
                                    case 3: {
                                        strb.append("ERROR: Dcom unsupported in this machine. If you are running Win95/Win98 but haven't installed DCOM95/DCOM98, please do so and try again.");
                                        System.out.println("ERROR: Dcom unsupported in this machine. If you are running Win95/Win98 but haven't installed DCOM95/DCOM98, please do so and try again.");
                                        break;
                                    }
                                    case 4: {
                                        strb.append("ERROR: Unknown error occured in the Authentication Module while looking up information.");
                                        System.out.println("ERROR: Unknown error occured in the Authentication Module while looking up information.");
                                        break;
                                    }
                                    default: {
                                        strb.append("ERROR: Unknown error occured");
                                        System.out.println("ERROR: Unknown error occured");
                                        break;
                                    }
                                }
                            } else {
                                isAuthSuccess = true;
                            }
                        }
                        if (!isAuthSuccess && authDebug) break block15;
                        s.getOutOfOffice();
                        strb.append("GetOutOfOffice() method executed successfully !!\n");
                        System.out.println("GetOutOfOffice() method executed successfully !!");
                        s.getInbox();
                        strb.append("GetInbox() method executed successfully !!\n");
                        System.out.println("GetInbox() method executed successfully !!");
                        s.logoff();
                        strb.append("Logged out successfully\n");
                        System.out.println("Logged out successfully");
                    }
                    catch (Exception e) {
                        strb.append(e.toString());
                        e.printStackTrace();
                        Object var24_25 = null;
                        System.out.println("cleaning up everything..");
                        Cleaner.releaseAll();
                        break block16;
                    }
                }
                Object var24_24 = null;
                System.out.println("cleaning up everything..");
            }
            catch (Throwable throwable) {
                Object var24_26 = null;
                System.out.println("cleaning up everything..");
                Cleaner.releaseAll();
                throw throwable;
            }
            Cleaner.releaseAll();
        }
        JOptionPane.showMessageDialog(this, strb.toString());
    }

    public void centerComponent(Component component) {
        Dimension size = component.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point();
        p.x = screenSize.width / 2 - size.width / 2;
        if (p.x < 0) {
            p.x = 0;
        }
        p.y = screenSize.height / 2 - size.height / 2;
        if (p.y < 0) {
            p.y = 0;
        }
        component.setLocation(p);
    }

    private void initComponents() {
        this.settingsPanel = new JPanel();
        this.userNameLabel = new JLabel();
        this.userNameTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JTextField();
        this.domainLabel = new JLabel();
        this.domainTextField = new JTextField();
        this.exchangeServerLabel = new JLabel();
        this.exchangeServerTextField = new JTextField();
        this.mailBoxLabel = new JLabel();
        this.mailBoxTextField = new JTextField();
        this.ocxHostLocation = new JLabel();
        this.ocxHostTextField = new JTextField();
        this.aligoAuthLocation = new JLabel();
        this.aligoAuthTextField = new JTextField();
        this.logsLocation = new JLabel();
        this.logsTextField = new JTextField();
        this.buttonsPanel = new JPanel();
        this.connectButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Test.this.exitForm(evt);
            }
        });
        this.settingsPanel.setLayout(new GridBagLayout());
        this.userNameLabel.setText("User Name:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(15, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.userNameLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(15, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.userNameTextField, gridBagConstraints2);
        this.passwordLabel.setText("Password:");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.passwordLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.passwordTextField, gridBagConstraints2);
        this.domainLabel.setText("Domain:");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(0, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.domainLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.domainTextField, gridBagConstraints2);
        this.exchangeServerLabel.setText("Exchange Server:");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(0, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.exchangeServerLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.exchangeServerTextField, gridBagConstraints2);
        this.mailBoxLabel.setText("MailBox:");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.insets = new Insets(0, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.mailBoxLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.mailBoxTextField, gridBagConstraints2);
        this.ocxHostLocation.setText("OCX Host Location:");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.insets = new Insets(0, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.ocxHostLocation, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.ocxHostTextField, gridBagConstraints2);
        this.aligoAuthLocation.setText("AligoAuth server Location:");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.insets = new Insets(0, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.aligoAuthLocation, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.aligoAuthTextField, gridBagConstraints2);
        this.logsLocation.setText("Logs location :");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.insets = new Insets(0, 15, 15, 15);
        gridBagConstraints2.anchor = 18;
        this.settingsPanel.add((Component)this.logsLocation, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 15);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.settingsPanel.add((Component)this.logsTextField, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.getContentPane().add((Component)this.settingsPanel, gridBagConstraints1);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.connectButton.setText("Connect");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.weightx = 1.0;
        this.buttonsPanel.add((Component)this.connectButton, gridBagConstraints3);
        this.cancelButton.setText("Cancel");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints1);
    }

    private void exitForm(WindowEvent evt) {
        this.processExit();
    }

    private void processExit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        new Test().show();
    }
}

