/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.ExchangeRecurrencePattern;
import com.aligo.pim.PimRecurrencePatternDayType;
import com.aligo.pim.PimRecurrencePatternMonthType;
import com.aligo.pim.PimRecurrencePatternNthType;
import com.aligo.pim.PimRecurrencePatternType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimAppointmentItem;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimItem;
import com.aligo.pim.exchange.ExchangePimMonthlyRecurParameter;
import com.aligo.pim.exchange.ExchangePimRecurrencePatternDayTypeMapper;
import com.aligo.pim.exchange.ExchangePimRecurrencePatternMonthTypeMapper;
import com.aligo.pim.exchange.ExchangePimRecurrencePatternNthTypeMapper;
import com.aligo.pim.exchange.ExchangePimRecurrencePatternTypeMapper;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.ExchangePimYearlyRecurParameter;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class ExchangePimRecurrencePatternItem
extends ExchangePimItem
implements PimRecurrencePatternItem {
    private ExchangeRecurrencePattern oRecurrencePattern;
    private ExchangePimAppointmentItem oPimAppointmentItem;
    private PimRecurrencePatternType oPimRecurrencePatternType;
    private int oInterval;
    private int oDaysOfWeekMask;
    private int weekSize = 1;
    private Vector oDaysOfMonth;
    private int oNoOfOccurrences;
    private Date oRecurrenceEndDate;
    private Date oStartTime;
    private Date oEndTime;
    private boolean isUpdateCalled;
    private boolean createWeeklyEveryNWeeksFlag = false;
    int m_iTalOccurences;
    int m_iTalMonthInstance;
    int m_iTalDayInstance;
    int m_iTalInterval;
    Date m_oTalRecurrenceEndDate;
    boolean m_bTalSpecialMonthlyRecurrence = false;
    Vector m_vExceptionDates = new Vector();
    int m_iSunYearInstance;
    boolean m_bSunSpecialYearlyRecurrence = false;

    public ExchangePimRecurrencePatternItem(ExchangePimSession pimSession) {
        super(pimSession);
    }

    public ExchangePimRecurrencePatternItem(ExchangeRecurrencePattern m_oRecurrencePattern, ExchangePimSession pimSession) {
        super(pimSession);
        this.oRecurrencePattern = m_oRecurrencePattern;
    }

    public ExchangePimRecurrencePatternItem(ExchangeRecurrencePattern m_oRecurrencePattern, ExchangePimAppointmentItem m_oPimAppointmentItem, ExchangePimSession pimSession) {
        super(pimSession);
        this.oRecurrencePattern = m_oRecurrencePattern;
        this.oPimAppointmentItem = m_oPimAppointmentItem;
    }

    public void setExchangeRecurrencePattern(ExchangeRecurrencePattern m_oRecurrencePattern) {
        this.oRecurrencePattern = m_oRecurrencePattern;
    }

    public ExchangeRecurrencePattern getExchangeRecurrencePattern() throws ExchangePimException {
        return this.oRecurrencePattern;
    }

    public Date getEndDate() throws ExchangePimException {
        try {
            return this.getExchangeRecurrencePattern().getPatternEndDate();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getEndTime() throws ExchangePimException {
        try {
            return this.getExchangeRecurrencePattern().getEndTime();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getStartTime() throws ExchangePimException {
        try {
            return this.getExchangeRecurrencePattern().getStartTime();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public int getDuration() throws ExchangePimException {
        try {
            return this.getExchangeRecurrencePattern().getDuration();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setType(PimRecurrencePatternType pimRecurrencePatternType) throws PimException {
        try {
            if (pimRecurrencePatternType != null) {
                this.oPimRecurrencePatternType = pimRecurrencePatternType;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setInterval(int interval) throws PimException {
        try {
            if (interval > 0) {
                this.oInterval = interval;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setDaysOfWeek(Vector daysOfWeek) throws PimException {
        this.weekSize = daysOfWeek.size();
        int dayOfWeekMask = 0;
        try {
            if (daysOfWeek == null) {
                throw new ExchangePimException(55L);
            }
            if (daysOfWeek.size() > 0) {
                Vector tempVector = new Vector();
                int i = 0;
                while (i < daysOfWeek.size()) {
                    Object obj = daysOfWeek.elementAt(i);
                    if (!(obj instanceof PimRecurrencePatternDayType)) {
                        throw new ExchangePimException(55L);
                    }
                    int repeatIndex = daysOfWeek.lastIndexOf(obj);
                    if (i == repeatIndex) {
                        dayOfWeekMask += ExchangePimRecurrencePatternDayTypeMapper.getType((PimRecurrencePatternDayType)obj);
                    }
                    ++i;
                }
                this.oDaysOfWeekMask = dayOfWeekMask;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(55L);
        }
    }

    public void setDaysOfMonth(Vector daysOfMonth) throws PimException {
        try {
            if (daysOfMonth == null) {
                throw new ExchangePimException(56L);
            }
            if (daysOfMonth.size() > 0) {
                Vector<Integer> tempVector = new Vector<Integer>();
                int i = 0;
                while (i < daysOfMonth.size()) {
                    int dayOfMonth = (Integer)daysOfMonth.elementAt(i);
                    if (dayOfMonth <= 0 || dayOfMonth > 31) {
                        throw new ExchangePimException(56L);
                    }
                    int repeatIndex = daysOfMonth.lastIndexOf(new Integer(dayOfMonth));
                    if (i == repeatIndex) {
                        tempVector.add(new Integer(dayOfMonth));
                    }
                    ++i;
                }
                this.oDaysOfMonth = tempVector;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(56L);
        }
    }

    public void setNoOfOccurrences(int noOfOccurrences) throws PimException {
        try {
            this.createWeeklyEveryNWeeksFlag = true;
            if (noOfOccurrences > 0) {
                this.oNoOfOccurrences = noOfOccurrences;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setNoOfInstances(int noOfInstances) throws PimException {
        try {
            this.createWeeklyEveryNWeeksFlag = false;
            if (noOfInstances > 0) {
                this.oNoOfOccurrences = noOfInstances;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setRecurrenceEndDate(Date endDate) throws PimException {
        try {
            if (endDate != null) {
                this.oRecurrenceEndDate = endDate;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createDailyEveryNDays(Date recurrenceEndDate, int nDays) throws ExchangePimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setInterval(nDays);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createDailyEveryNDays(int noOfOccurrences, int nDays) throws ExchangePimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nDays);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createWeeklyEveryNWeeks(Date recurrenceEndDate, int nWeeks, Vector daysOfWeek) throws ExchangePimException {
        try {
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setInterval(nWeeks);
            this.setDaysOfWeek(daysOfWeek);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createWeeklyEveryNWeeks(int noOfOccurrences, int nWeeks, Vector daysOfWeek) throws ExchangePimException {
        try {
            this.createWeeklyEveryNWeeksFlag = true;
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nWeeks);
            this.setDaysOfWeek(daysOfWeek);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createWeeklyNoOfInstances(int noOfOccurrences, int nWeeks, Vector daysOfWeek) throws PimException {
        this.createWeeklyEveryNWeeksFlag = false;
        this.setType(PimRecurrencePatternType.WEEKLY);
        this.setNoOfOccurrences(noOfOccurrences);
        this.setInterval(nWeeks);
        this.setDaysOfWeek(daysOfWeek);
    }

    public void createMonthlyEveryNMonths(Date recurrenceEndDate, int nMonths, Vector daysOfMonth) throws ExchangePimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setInterval(nMonths);
            this.setDaysOfMonth(daysOfMonth);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createMonthlyEveryNMonths(int noOfOccurrences, int nMonths, Vector daysOfMonth) throws ExchangePimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nMonths);
            this.setDaysOfMonth(daysOfMonth);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createYearlyEveryNYears(Date recurrenceEndDate, int nYears) throws ExchangePimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setInterval(nYears);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createYearlyEveryNYears(int noOfOccurrences, int nYears) throws ExchangePimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nYears);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createYearly(int noOfOccurences, ExchangePimMonthlyRecurParameter monthInstance, PimRecurrencePatternDayType dayInstance, ExchangePimYearlyRecurParameter yearInstance) throws ExchangePimException {
        try {
            this.m_iTalOccurences = noOfOccurences;
            this.m_iTalMonthInstance = monthInstance.getType();
            this.m_iTalDayInstance = ExchangePimRecurrencePatternDayTypeMapper.getType(dayInstance);
            this.m_iSunYearInstance = yearInstance.getType();
            this.m_bSunSpecialYearlyRecurrence = true;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createYearly(Date recurrenceEndDate, ExchangePimMonthlyRecurParameter monthInstance, PimRecurrencePatternDayType dayInstance, ExchangePimYearlyRecurParameter yearInstance) throws ExchangePimException {
        try {
            this.m_oTalRecurrenceEndDate = recurrenceEndDate;
            this.m_iTalMonthInstance = monthInstance.getType();
            this.m_iTalDayInstance = ExchangePimRecurrencePatternDayTypeMapper.getType(dayInstance);
            this.m_iSunYearInstance = yearInstance.getType();
            this.m_bSunSpecialYearlyRecurrence = true;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean isItRecurringItem() throws ExchangePimException {
        return this.isUpdateCalled;
    }

    private void doValidityCheck() throws ExchangePimException {
        try {
            this.oStartTime = this.oPimAppointmentItem.m_oStartTime;
            if (this.oStartTime == null) {
                throw new ExchangePimException(59L);
            }
            if (!this.oPimAppointmentItem.isSetAllDayEvent()) {
                this.oEndTime = this.oPimAppointmentItem.m_oEndTime;
                if (this.oEndTime == null) {
                    throw new ExchangePimException(59L);
                }
                if (this.oEndTime.compareTo(this.oStartTime) < 0) {
                    throw new ExchangePimException(13L);
                }
            }
            if (this.oRecurrenceEndDate != null && this.oRecurrenceEndDate.compareTo(this.oEndTime) < 0) {
                throw new ExchangePimException(61L);
            }
            if (this.m_bTalSpecialMonthlyRecurrence || this.m_bSunSpecialYearlyRecurrence) {
                return;
            }
            if (this.oPimRecurrencePatternType == null) {
                throw new ExchangePimException(60L);
            }
            if (this.oDaysOfMonth == null) {
                this.oDaysOfMonth = new Vector();
            }
            if (this.oDaysOfWeekMask < 1) {
                this.oDaysOfWeekMask = 2;
            }
            if (this.oInterval < 1) {
                this.oInterval = 1;
            }
            if (this.oNoOfOccurrences < 1) {
                this.oNoOfOccurrences = 1;
            }
            if (this.weekSize > 1 && this.oNoOfOccurrences > 0 && this.createWeeklyEveryNWeeksFlag) {
                this.oNoOfOccurrences *= this.weekSize;
                this.createWeeklyEveryNWeeksFlag = false;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createMonthlyEveryNMonths(int noOfOccurences, ExchangePimMonthlyRecurParameter monthInstance, PimRecurrencePatternDayType dayInstance, int interval) {
        this.m_iTalOccurences = noOfOccurences;
        this.m_iTalMonthInstance = monthInstance.getType();
        this.m_iTalDayInstance = ExchangePimRecurrencePatternDayTypeMapper.getType(dayInstance);
        this.m_iTalInterval = interval;
        this.m_bTalSpecialMonthlyRecurrence = true;
    }

    public void createMonthlyEveryNMonths(Date recurrenceEndDate, ExchangePimMonthlyRecurParameter monthInstance, PimRecurrencePatternDayType dayInstance, int interval) {
        this.m_oTalRecurrenceEndDate = recurrenceEndDate;
        this.m_iTalMonthInstance = monthInstance.getType();
        this.m_iTalDayInstance = ExchangePimRecurrencePatternDayTypeMapper.getType(dayInstance);
        this.m_iTalInterval = interval;
        this.m_bTalSpecialMonthlyRecurrence = true;
    }

    public void update() throws ExchangePimException {
        try {
            this.doValidityCheck();
            if (this.m_bTalSpecialMonthlyRecurrence) {
                if (this.m_iTalMonthInstance < 0 || this.m_iTalDayInstance < 0 || this.m_iTalInterval < 0) {
                    throw new Exception("The parmeters set are invalid[MonthInsance=" + this.m_iTalMonthInstance + "] [DayInstance=" + this.m_iTalDayInstance + "] [Interval=" + this.m_iTalInterval + "]");
                }
                this.getExchangeRecurrencePattern().setRecurrenceType(3);
                this.getExchangeRecurrencePattern().setInstance(this.m_iTalMonthInstance);
                this.getExchangeRecurrencePattern().setDayOfWeekMask(this.m_iTalDayInstance);
                this.getExchangeRecurrencePattern().setInterval(this.m_iTalInterval);
                if (this.m_oTalRecurrenceEndDate != null) {
                    this.getExchangeRecurrencePattern().setPatternEndDate(this.m_oTalRecurrenceEndDate);
                } else if (this.m_iTalOccurences > 0) {
                    this.getExchangeRecurrencePattern().setOccurrences(this.m_iTalOccurences);
                }
                this.isUpdateCalled = true;
                return;
            }
            if (this.m_bSunSpecialYearlyRecurrence) {
                if (this.m_iTalMonthInstance < 0 || this.m_iTalDayInstance < 0 || this.m_iSunYearInstance < 0) {
                    throw new Exception("The parmeters set are invalid[MonthInsance=" + this.m_iTalMonthInstance + "] [DayInstance=" + this.m_iTalDayInstance + "] [Month=" + this.m_iSunYearInstance + "]");
                }
                this.getExchangeRecurrencePattern().setRecurrenceType(6);
                this.getExchangeRecurrencePattern().setInstance(this.m_iTalMonthInstance);
                this.getExchangeRecurrencePattern().setDayOfWeekMask(this.m_iTalDayInstance);
                this.getExchangeRecurrencePattern().setMonthOfYear(this.m_iSunYearInstance);
                if (this.m_oTalRecurrenceEndDate != null) {
                    this.getExchangeRecurrencePattern().setPatternEndDate(this.m_oTalRecurrenceEndDate);
                } else if (this.m_iTalOccurences > 0) {
                    this.getExchangeRecurrencePattern().setOccurrences(this.m_iTalOccurences);
                }
                this.isUpdateCalled = true;
                return;
            }
            if (this.oPimRecurrencePatternType == PimRecurrencePatternType.DAILY) {
                this.oRecurrencePattern.setRecurrenceType(0);
            } else if (this.oPimRecurrencePatternType == PimRecurrencePatternType.WEEKLY) {
                this.oRecurrencePattern.setRecurrenceType(1);
                this.oRecurrencePattern.setDayOfWeekMask(this.oDaysOfWeekMask);
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(this.oStartTime);
                int week = startCal.get(7);
                int startWeek = -1;
                String binaryString = Integer.toBinaryString(this.oDaysOfWeekMask);
                int i = 0;
                while (i < binaryString.length()) {
                    char c = binaryString.charAt(i);
                    if (c == '1') {
                        startWeek = binaryString.length() - i;
                    }
                    ++i;
                }
                startCal.add(7, startWeek);
            } else if (this.oPimRecurrencePatternType == PimRecurrencePatternType.MONTHLY) {
                this.oRecurrencePattern.setRecurrenceType(2);
                int day = (Integer)this.oDaysOfMonth.elementAt(0);
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(this.oStartTime);
                int startDay = startCal.get(5);
                if (startDay < day) {
                    startCal.set(5, day);
                } else if (startDay > day) {
                    startCal.set(5, day);
                    int startMonth = startCal.get(2);
                    startCal.roll(2, 1);
                    if (startMonth == 11) {
                        startCal.roll(1, 1);
                    }
                }
                this.oRecurrencePattern.setDayOfMonth(day);
            } else if (this.oPimRecurrencePatternType == PimRecurrencePatternType.YEARLY) {
                this.oRecurrencePattern.setRecurrenceType(5);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.oStartTime);
                this.oRecurrencePattern.setDayOfMonth(cal.get(5));
                this.oRecurrencePattern.setMonthOfYear(cal.get(2) + 1);
            }
            this.oRecurrencePattern.setInterval(this.oInterval);
            if (this.oRecurrenceEndDate != null) {
                this.oRecurrencePattern.setPatternEndDate(this.oRecurrenceEndDate);
            } else if (this.oNoOfOccurrences > 0) {
                this.oRecurrencePattern.setOccurrences(this.oNoOfOccurrences);
            }
            this.isUpdateCalled = true;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.isUpdateCalled = false;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public String getID() throws ExchangePimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getName() throws ExchangePimException {
        try {
            return "Recurrence Pattern Item";
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecurrencePatternType getType() throws PimException {
        try {
            int type = this.oRecurrencePattern.getRecurrenceType();
            if (type == 3) {
                type = 2;
            }
            if (type == 6) {
                type = 5;
            }
            return ExchangePimRecurrencePatternTypeMapper.getRecurrenceType(type);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public int getInterval() throws PimException {
        try {
            return this.oRecurrencePattern.getInterval();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Vector getDaysOfWeek() throws PimException {
        try {
            int days = this.oRecurrencePattern.getDayOfWeekMask();
            PimRecurrencePatternType type = this.getType();
            if ((days == 127 || days == 62 || days == 65) && (type.equals(PimRecurrencePatternType.MONTHLY) || type.equals(PimRecurrencePatternType.YEARLY))) {
                Vector<PimRecurrencePatternDayType> nthVect = new Vector<PimRecurrencePatternDayType>();
                nthVect.add(ExchangePimRecurrencePatternDayTypeMapper.getRecurrenceType(days));
                return nthVect;
            }
            Vector<PimRecurrencePatternDayType> daysOfWeek = new Vector<PimRecurrencePatternDayType>();
            String binaryString = Integer.toBinaryString(days);
            int i = 0;
            while (i < binaryString.length()) {
                char c = binaryString.charAt(i);
                if (c == '1') {
                    daysOfWeek.add(ExchangePimRecurrencePatternDayTypeMapper.getRecurrenceType(binaryString.length() - i));
                }
                ++i;
            }
            return daysOfWeek;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector getDaysOfMonth() throws PimException {
        try {
            int day = this.oRecurrencePattern.getDayOfMonth();
            Vector<Integer> daysOfMonth = new Vector<Integer>();
            daysOfMonth.add(new Integer(day));
            return daysOfMonth;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector getMonthsOfYear() throws PimException {
        try {
            int monthOfYear = this.oRecurrencePattern.getMonthOfYear();
            PimRecurrencePatternMonthType pimRecurrencePatternMonthType = ExchangePimRecurrencePatternMonthTypeMapper.getRecurrenceType(monthOfYear);
            if (pimRecurrencePatternMonthType != null) {
                Vector<PimRecurrencePatternMonthType> monthsOfYear = new Vector<PimRecurrencePatternMonthType>();
                monthsOfYear.add(pimRecurrencePatternMonthType);
                return monthsOfYear;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimRecurrencePatternNthType getNthType() throws PimException {
        try {
            int instance = this.oRecurrencePattern.getInstance();
            PimRecurrencePatternNthType pimRecurrencePatternNthType = ExchangePimRecurrencePatternNthTypeMapper.getRecurrenceType(instance);
            if (pimRecurrencePatternNthType != null) {
                return pimRecurrencePatternNthType;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getNoOfOccurrences() throws PimException {
        try {
            if (this.isNoEndDateTrue()) {
                return -1;
            }
            int noOfOccurences = this.oRecurrencePattern.getOccurrences();
            return noOfOccurences;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean isNoEndDateTrue() throws PimException {
        try {
            return this.oRecurrencePattern.getNoEndDate();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Date getRecurrenceEndDate() throws PimException {
        try {
            if (this.isNoEndDateTrue()) {
                return null;
            }
            return this.oRecurrencePattern.getPatternEndDate();
        }
        catch (Exception e) {
            return null;
        }
    }
}

