/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeFolder;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFilter;
import com.aligo.pim.exchange.ExchangePimInbox;
import com.aligo.pim.exchange.ExchangePimMailItem;
import com.aligo.pim.exchange.ExchangePimMailMessageItem;
import com.aligo.pim.exchange.ExchangePimMailMessageItemFilter;
import com.aligo.pim.exchange.ExchangePimMeetingItem;
import com.aligo.pim.exchange.ExchangePimMessageItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimInbox;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMailItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMailMessageItemFilter;
import com.aligo.pim.interfaces.PimMailMessageItems;
import com.aligo.pim.interfaces.PimMessageItem;

public class ExchangePimMailMessageItems
extends ExchangePimMessageItems
implements PimMailMessageItems {
    private ExchangePimMailMessageItemFilter m_oPimMailMessageItemFilter;

    public ExchangePimMailMessageItems(ExchangeMessages _oMessages, ExchangePimSession pimSession) {
        super(_oMessages, pimSession);
    }

    public void setExchangeMailMessages(ExchangeMessages _oMessages) {
        this.setExchangeMessages(_oMessages);
    }

    public PimMailMessageItemFilter getMailMessageItemFilter() throws ExchangePimException {
        if (this.m_oPimMailMessageItemFilter == null) {
            this.m_oPimMailMessageItemFilter = new ExchangePimMailMessageItemFilter(this.getExchangeMessageFilter(), this.getPimSession());
        } else {
            this.m_oPimMailMessageItemFilter.setExchangeMailMessageFilter(this.getExchangeMessageFilter());
        }
        return this.m_oPimMailMessageItemFilter;
    }

    public PimMailItem addMailItem() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeMessages().add();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimMailItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem getMailMessageItem(int itemNumber) throws ExchangePimException {
        try {
            Object obj = this.getExchangeMessages().getItem(itemNumber + 1);
            if (this.getExchangeMessages().isMessage(obj)) {
                ExchangePimMailItem mailItem = new ExchangePimMailItem((ExchangeMessage)obj, this.getPimSession());
                return mailItem;
            }
            if (this.getExchangeMessages().isMeeting(obj)) {
                ExchangePimMeetingItem meetingItem = new ExchangePimMeetingItem(obj, this.getPimSession());
                return meetingItem;
            }
            return null;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem getMailMessageItem(String id) throws ExchangePimException {
        try {
            PimInbox pimInbox = this.getFreshFolder();
            ExchangePimMailMessageItems pimMailMessageItems = (ExchangePimMailMessageItems)pimInbox.getMailMessageItems();
            ExchangePimFilter pimFilter = (ExchangePimFilter)pimMailMessageItems.getMailMessageItemFilter();
            pimFilter.setID(id);
            Object obj = pimMailMessageItems.getExchangeMessages().getFirst(null);
            while (obj != null) {
                ExchangePimMeetingItem meetingItem;
                if (pimMailMessageItems.getExchangeMessages().isMessage(obj)) {
                    ExchangePimMailItem mailItem = new ExchangePimMailItem((ExchangeMessage)obj, this.getPimSession());
                    if (mailItem.getID().equals(id)) {
                        return mailItem;
                    }
                } else if (pimMailMessageItems.getExchangeMessages().isMeeting(obj) && (meetingItem = new ExchangePimMeetingItem(obj, this.getPimSession())).getID().equals(id)) {
                    return meetingItem;
                }
                obj = pimMailMessageItems.getExchangeMessages().getNext();
            }
            return this.getMailMessageItemBackUpStrategy(id);
        }
        catch (Exception e) {
            return this.getMailMessageItemBackUpStrategy(id);
        }
    }

    private PimInbox getFreshFolder() throws AligoExchangeException {
        ExchangeFolder _oFolder = this.getExchangeMessages().getParent();
        return new ExchangePimInbox(_oFolder, this.getPimSession());
    }

    public PimMailMessageItem getMailMessageItemBackUpStrategy(String id) throws ExchangePimException {
        try {
            PimInbox pimInbox = this.getFreshFolder();
            PimMailMessageItems pimMailMessageItems = pimInbox.getMailMessageItems();
            PimMailMessageItem pimMailMessageItem = pimMailMessageItems.getFirstMailMessageItem();
            while (pimMailMessageItem != null) {
                if (pimMailMessageItem.getID().equals(id)) {
                    return pimMailMessageItem;
                }
                pimMailMessageItem = pimMailMessageItems.getNextMailMessageItem();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimMailMessageItem getFirstMailMessageItem() throws ExchangePimException {
        try {
            ExchangeMessages exchangeMessages = this.getExchangeMessages();
            if (exchangeMessages == null) {
                return null;
            }
            Object obj = exchangeMessages.getFirst(null);
            if (this.getExchangeMessages().isMessage(obj)) {
                ExchangePimMailItem mailItem = new ExchangePimMailItem((ExchangeMessage)obj, this.getPimSession());
                return mailItem;
            }
            if (this.getExchangeMessages().isMeeting(obj)) {
                ExchangePimMeetingItem meetingItem = new ExchangePimMeetingItem(obj, this.getPimSession());
                return meetingItem;
            }
            return null;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem getNextMailMessageItem() throws ExchangePimException {
        try {
            ExchangeMessages exchangeMessages = this.getExchangeMessages();
            if (exchangeMessages == null) {
                return null;
            }
            Object obj = exchangeMessages.getNext();
            if (this.getExchangeMessages().isMessage(obj)) {
                ExchangePimMailItem mailItem = new ExchangePimMailItem((ExchangeMessage)obj, this.getPimSession());
                return mailItem;
            }
            if (this.getExchangeMessages().isMeeting(obj)) {
                ExchangePimMeetingItem meetingItem = new ExchangePimMeetingItem(obj, this.getPimSession());
                return meetingItem;
            }
            return null;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem getLastMailMessageItem() throws ExchangePimException {
        try {
            ExchangeMessages exchangeMessages = this.getExchangeMessages();
            if (exchangeMessages == null) {
                return null;
            }
            Object obj = exchangeMessages.getLast(null);
            if (this.getExchangeMessages().isMessage(obj)) {
                ExchangePimMailItem mailItem = new ExchangePimMailItem((ExchangeMessage)obj, this.getPimSession());
                return mailItem;
            }
            if (this.getExchangeMessages().isMeeting(obj)) {
                ExchangePimMeetingItem meetingItem = new ExchangePimMeetingItem(obj, this.getPimSession());
                return meetingItem;
            }
            return null;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem getPreviousMailMessageItem() throws ExchangePimException {
        try {
            ExchangeMessages exchangeMessages = this.getExchangeMessages();
            if (exchangeMessages == null) {
                return null;
            }
            Object obj = exchangeMessages.getPrevious();
            if (this.getExchangeMessages().isMessage(obj)) {
                ExchangePimMailItem mailItem = new ExchangePimMailItem((ExchangeMessage)obj, this.getPimSession());
                return mailItem;
            }
            if (this.getExchangeMessages().isMeeting(obj)) {
                ExchangePimMeetingItem meetingItem = new ExchangePimMeetingItem(obj, this.getPimSession());
                return meetingItem;
            }
            return null;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExchangePimException {
        return this.getMailMessageItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExchangePimException {
        return this.getMailMessageItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExchangePimException {
        return this.getFirstMailMessageItem();
    }

    public PimMessageItem getNextMessageItem() throws ExchangePimException {
        return this.getNextMailMessageItem();
    }

    public PimMessageItem getLastMessageItem() throws ExchangePimException {
        return this.getLastMailMessageItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExchangePimException {
        return this.getPreviousMailMessageItem();
    }

    public PimMessageItem addMessageItem() throws ExchangePimException {
        return this.addMailItem();
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousMessageItem();
    }

    public void delete(String[] ids) throws ExchangePimException {
        int length = ids.length;
        int i = 0;
        while (i < length) {
            ExchangePimMailMessageItem exchangePimMailMessageItem = (ExchangePimMailMessageItem)this.getMailMessageItem(ids[i]);
            exchangePimMailMessageItem.delete();
            ++i;
        }
    }
}

