/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import java.util.Arrays;
import java.util.Comparator;

public class ExchangePimGlobalAddressEntryItemsProxy
extends ExchangePimItems
implements PimAddressEntryItems {
    private PimAddressEntryItems m_oPimAddressEntryItems;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private PimFieldType[] m_oPimOrderBy = new PimFieldType[]{PimFieldType.NAME};
    private boolean m_bIsInitializeCalled = false;
    private PimAddressEntryItem[] m_oPimAddressEntryItemArray;
    private boolean isOrderBySet = false;

    public ExchangePimGlobalAddressEntryItemsProxy(PimAddressEntryItems pimAddressEntryItems, ExchangePimSession pimSession) {
        super(pimSession);
        this.m_oPimAddressEntryItems = pimAddressEntryItems;
    }

    public PimAddressEntryItems getBackEndAddressEntryItems() {
        return this.m_oPimAddressEntryItems;
    }

    public void initialize() throws PimException {
        this.m_bIsInitializeCalled = false;
        int count = this.getCount();
        this.m_oPimAddressEntryItemArray = new PimAddressEntryItem[count];
        PimAddressEntryItem pimAddressEntryItem = this.m_oPimAddressEntryItems.getFirstAddressEntryItem();
        int addressEntryItemIndex = 0;
        while (pimAddressEntryItem != null) {
            this.m_oPimAddressEntryItemArray[addressEntryItemIndex] = pimAddressEntryItem;
            ++addressEntryItemIndex;
            pimAddressEntryItem = this.m_oPimAddressEntryItems.getNextAddressEntryItem();
        }
        Arrays.sort(this.m_oPimAddressEntryItemArray, new AddressEntryItemComparator());
        this.m_bIsInitializeCalled = true;
    }

    public PimAddressEntryItem addAddressEntryItem() throws PimException {
        return this.getBackEndAddressEntryItems().addAddressEntryItem();
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws PimException {
        this.getBackEndAddressEntryItems().addAddressEntryItem(pimAddressEntryItem);
    }

    public boolean isCacheTrue() {
        return this.isOrderBySet || this.m_oPimSortType.equals(PimSortType.DESCENDING);
    }

    public void setOrderBy(PimFieldType[] pimFieldType) throws PimException {
        if (pimFieldType != null) {
            this.isOrderBySet = true;
            this.m_oPimOrderBy = pimFieldType;
        }
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() throws PimException {
        return this.getBackEndAddressEntryItems().getAddressEntryItemFilter();
    }

    public int getCount() throws PimException {
        return this.getBackEndAddressEntryItems().getCount();
    }

    public PimAddressEntryItem getAddressEntryItem(int itemNumber) throws PimException {
        if (this.isCacheTrue()) {
            if (!this.m_bIsInitializeCalled) {
                this.initialize();
            }
            if (this.m_oPimAddressEntryItemArray != null && itemNumber < this.getCount() && itemNumber >= 0) {
                return this.m_oPimAddressEntryItemArray[itemNumber];
            }
        } else {
            return this.getBackEndAddressEntryItems().getAddressEntryItem(itemNumber);
        }
        return null;
    }

    public PimAddressEntryItem getAddressEntryItem(String id) throws PimException {
        return this.getBackEndAddressEntryItems().getAddressEntryItem(id);
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws PimException {
        if (this.isCacheTrue()) {
            return this.getAddressEntryItem(this.getFirstIndex() - 1);
        }
        return this.getBackEndAddressEntryItems().getFirstAddressEntryItem();
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws PimException {
        if (this.isCacheTrue()) {
            return this.getAddressEntryItem(this.getNextIndex() - 1);
        }
        return this.getBackEndAddressEntryItems().getNextAddressEntryItem();
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws PimException {
        if (this.isCacheTrue()) {
            return this.getAddressEntryItem(this.getLastIndex() - 1);
        }
        return this.getBackEndAddressEntryItems().getLastAddressEntryItem();
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws PimException {
        if (this.isCacheTrue()) {
            return this.getAddressEntryItem(this.getPreviousIndex() - 1);
        }
        return this.getBackEndAddressEntryItems().getPreviousAddressEntryItem();
    }

    public void delete() throws PimException {
        this.getBackEndAddressEntryItems().delete();
    }

    public void sort(PimSortType type) throws PimException {
        this.m_oPimSortType = type;
        if (type.equals(PimSortType.ASCENDING)) {
            this.getBackEndAddressEntryItems().sort(type);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws PimException {
        return this.getAddressEntryItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws PimException {
        return this.getAddressEntryItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws PimException {
        return this.getAddressEntryItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws PimException {
        return this.getFirstAddressEntryItem();
    }

    public PimMessageItem getNextMessageItem() throws PimException {
        return this.getNextAddressEntryItem();
    }

    public PimMessageItem getLastMessageItem() throws PimException {
        return this.getLastAddressEntryItem();
    }

    public PimMessageItem getPreviousMessageItem() throws PimException {
        return this.getPreviousAddressEntryItem();
    }

    public PimMessageItem addMessageItem() throws PimException {
        return this.addAddressEntryItem();
    }

    public PimItem getItem(int itemNumber) throws PimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws PimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws PimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws PimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws PimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws PimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws PimException {
        return this.getPreviousMessageItem();
    }

    private class AddressEntryItemComparator
    implements Comparator {
        PimFieldType[] pimFieldType;
        int noOfSortFields;
        PimSortType pimSortType;

        public AddressEntryItemComparator() throws PimException {
            this.pimFieldType = ExchangePimGlobalAddressEntryItemsProxy.this.m_oPimOrderBy;
            this.noOfSortFields = this.pimFieldType != null ? this.pimFieldType.length : 0;
            this.pimSortType = ExchangePimGlobalAddressEntryItemsProxy.this.m_oPimSortType;
        }

        public int compare(Object o1, Object o2) {
            try {
                PimAddressEntryItem pimAddrEntryItem1 = (PimAddressEntryItem)o1;
                PimAddressEntryItem pimAddrEntryItem2 = (PimAddressEntryItem)o2;
                if (this.pimSortType.equals(PimSortType.ASCENDING)) {
                    pimAddrEntryItem1 = (PimAddressEntryItem)o1;
                    pimAddrEntryItem2 = (PimAddressEntryItem)o2;
                } else {
                    pimAddrEntryItem1 = (PimAddressEntryItem)o2;
                    pimAddrEntryItem2 = (PimAddressEntryItem)o1;
                }
                int toCompareIndex = 0;
                while (toCompareIndex < this.noOfSortFields) {
                    PimFieldType pimField = this.pimFieldType[toCompareIndex];
                    String value1 = "";
                    String value2 = "";
                    if (pimField.equals(PimFieldType.FIRST_NAME)) {
                        value1 = pimAddrEntryItem1.getFirstName();
                        value2 = pimAddrEntryItem2.getFirstName();
                    } else if (pimField.equals(PimFieldType.LAST_NAME)) {
                        value1 = pimAddrEntryItem1.getLastName();
                        value2 = pimAddrEntryItem2.getLastName();
                    } else if (pimField.equals(PimFieldType.EMAIL_ADDRESS)) {
                        value1 = pimAddrEntryItem1.getEmailAddress();
                        value2 = pimAddrEntryItem2.getEmailAddress();
                    } else if (pimField.equals(PimFieldType.NAME)) {
                        value1 = pimAddrEntryItem1.getName();
                        value2 = pimAddrEntryItem2.getName();
                    } else if (pimField.equals(PimFieldType.TITLE)) {
                        value1 = pimAddrEntryItem1.getTitle();
                        value2 = pimAddrEntryItem2.getTitle();
                    }
                    int returnValue = value1.compareToIgnoreCase(value2);
                    if (returnValue != 0) {
                        return returnValue;
                    }
                    ++toCompareIndex;
                }
            }
            catch (Exception e) {
                return 0;
            }
            return 0;
        }
    }
}

