/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeFolder;
import com.aligo.messaging.exchange.ExchangeFolders;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.pim.PimFolderItemsType;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFieldItems;
import com.aligo.pim.exchange.ExchangePimFolders;
import com.aligo.pim.exchange.ExchangePimItem;
import com.aligo.pim.exchange.ExchangePimMailMessageItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.util.ExchangePimUtil;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimFolders;
import com.aligo.pim.interfaces.PimItems;

public class ExchangePimFolder
extends ExchangePimItem
implements PimFolder {
    private ExchangeFolder _oFolder;
    private ExchangeMessages _oMessages;
    private ExchangePimFolders m_oPimFolders;

    public ExchangePimFolder(ExchangeFolder folder, ExchangePimSession pimSession) {
        super(pimSession);
        this._oFolder = folder;
    }

    public void setExchangeFolder(ExchangeFolder _oFolder) {
        this._oFolder = _oFolder;
    }

    public ExchangeFolder getExchangeFolder() {
        return this._oFolder;
    }

    public ExchangeMessages getExchangeMessages() throws ExchangePimException {
        try {
            this._oMessages = this.getExchangeFolder().getMessages();
        }
        catch (AligoExchangeException e) {
            if (e.getCode() == -2147221246) {
                return null;
            }
            throw new ExchangePimException(e);
        }
        return this._oMessages;
    }

    public ExchangeMessages getHiddenExchangeMessages() throws ExchangePimException {
        try {
            this._oMessages = this.getExchangeFolder().getHiddenMessages();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return this._oMessages;
    }

    public String getID() throws ExchangePimException {
        try {
            return this.getExchangeFolder().getId();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getName() throws ExchangePimException {
        try {
            return this.getExchangeFolder().getName();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimItems getItems() throws ExchangePimException {
        try {
            ExchangeMessages exchangeMessages = this.getExchangeFolder().getMessages();
            return new ExchangePimMailMessageItems(exchangeMessages, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFolders getFolders() throws ExchangePimException {
        try {
            ExchangeFolders _oFolders = this.getExchangeFolder().getFolders();
            if (_oFolders == null) {
                return null;
            }
            if (this.m_oPimFolders == null) {
                this.m_oPimFolders = new ExchangePimFolders(_oFolders, this.getPimSession());
            } else {
                this.m_oPimFolders.setExchangeFolders(_oFolders);
            }
            return this.m_oPimFolders;
        }
        catch (AligoExchangeException e) {
            if (e.getCode() == -2147221246) {
                return new ExchangePimFolders(null, this.getPimSession());
            }
            throw new ExchangePimException(e);
        }
    }

    public PimFolderItemsType getFolderItemsType() throws ExchangePimException {
        return ExchangePimUtil.getFodlerType(this.getPimSession().getExchangeSession(), this.getExchangeFolder());
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeFolder().delete();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws ExchangePimException {
        this.delete();
    }

    public void update() throws ExchangePimException {
        try {
            this.getExchangeFolder().update(true, false);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        try {
            return new ExchangePimFieldItems(this.getExchangeFolder().getFields(), this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }
}

