/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAppointmentItem;
import com.aligo.messaging.exchange.ExchangeFolder;
import com.aligo.messaging.exchange.ExchangeMeetingItem;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeMessageFilter;
import com.aligo.messaging.exchange.cdo.AppointmentItemProxy;
import com.aligo.messaging.exchange.cdo.FolderProxy;
import com.aligo.messaging.exchange.cdo.MeetingItemProxy;
import com.aligo.messaging.exchange.cdo.MessageFilterProxy;
import com.aligo.messaging.exchange.cdo.MessageProxy;
import com.aligo.messaging.exchange.cdo.Messages;

public final class ExchangeMessages {
    private Messages _ocxMessages;

    ExchangeMessages(Messages messagesHandle) {
        this._ocxMessages = messagesHandle;
    }

    public boolean isMeeting(Object o) {
        return o instanceof ExchangeMeetingItem;
    }

    public boolean isAppointment(Object o) {
        return o instanceof ExchangeAppointmentItem;
    }

    public boolean isMessage(Object o) {
        return o instanceof ExchangeMessage;
    }

    public Object add(String messageType) throws AligoExchangeException {
        try {
            if (messageType.equals("IPM.Note")) {
                MessageProxy returnHandle = new MessageProxy(this._ocxMessages.add(null, null, messageType, null));
                return new ExchangeMessage(returnHandle);
            }
            if (messageType.equals("IPM.Appointment")) {
                AppointmentItemProxy aptHandle = new AppointmentItemProxy(this._ocxMessages.add(null, null, null, null));
                return new ExchangeAppointmentItem(aptHandle);
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage add() throws AligoExchangeException {
        Object out = this.add("IPM.Note");
        if (out != null) {
            return (ExchangeMessage)out;
        }
        return null;
    }

    public int getCount() throws AligoExchangeException {
        try {
            Integer iCount = (Integer)this._ocxMessages.getCount();
            int count = iCount;
            if (count >= 0x7FFFFFFE) {
                count = 0;
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AligoExchangeException(e);
        }
    }

    public void delete() throws AligoExchangeException {
        try {
            this._ocxMessages.delete();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Object getItem(int index) throws AligoExchangeException {
        try {
            Object obj = this._ocxMessages.getItem(new Integer(index));
            if (obj != null) {
                MessageProxy msgHandle = new MessageProxy(obj);
                ExchangeMessage msg = new ExchangeMessage(msgHandle);
                if (msg.getType().equals("IPM.Schedule.Meeting.Request")) {
                    MeetingItemProxy mtgHandle = new MeetingItemProxy(obj);
                    return new ExchangeMeetingItem(mtgHandle);
                }
                if (msg.getType().equals("IPM.Appointment")) {
                    AppointmentItemProxy aptHandle = new AppointmentItemProxy(obj);
                    return new ExchangeAppointmentItem(aptHandle);
                }
                return msg;
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage getMessage(int index) throws AligoExchangeException {
        Object out = this.getItem(index);
        if (out instanceof ExchangeMessage) {
            return (ExchangeMessage)out;
        }
        return null;
    }

    public ExchangeMeetingItem getMeeting(int index) throws AligoExchangeException {
        Object out = this.getItem(index);
        if (out instanceof ExchangeMeetingItem) {
            return (ExchangeMeetingItem)out;
        }
        return null;
    }

    public ExchangeAppointmentItem getAppointment(int index) throws AligoExchangeException {
        Object out = this.getItem(index);
        if (out instanceof ExchangeAppointmentItem) {
            return (ExchangeAppointmentItem)out;
        }
        return null;
    }

    public Object getFirst(String filterType) throws AligoExchangeException {
        try {
            Object obj = this._ocxMessages.getFirst(filterType);
            if (obj != null) {
                MessageProxy msgHandle = new MessageProxy(obj);
                ExchangeMessage msg = new ExchangeMessage(msgHandle);
                if (msg.getType().equals("IPM.Schedule.Meeting.Request")) {
                    MeetingItemProxy meetingHandle = new MeetingItemProxy(obj);
                    return new ExchangeMeetingItem(meetingHandle);
                }
                if (msg.getType().equals("IPM.Appointment")) {
                    AppointmentItemProxy apptHandle = new AppointmentItemProxy(obj);
                    return new ExchangeAppointmentItem(apptHandle);
                }
                return msg;
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage getFirstMessage() throws AligoExchangeException {
        Object out = this.getFirst("IPM.Note");
        if (out instanceof ExchangeMessage) {
            return (ExchangeMessage)out;
        }
        return null;
    }

    public ExchangeMeetingItem getFirstMeeting() throws AligoExchangeException {
        Object out = this.getFirst("IPM.Schedule.Meeting.Request");
        if (out instanceof ExchangeMeetingItem) {
            return (ExchangeMeetingItem)out;
        }
        return null;
    }

    public ExchangeAppointmentItem getFirstAppointment() throws AligoExchangeException {
        Object out = this.getFirst("IPM.Appointment");
        if (out instanceof ExchangeAppointmentItem) {
            return (ExchangeAppointmentItem)out;
        }
        return null;
    }

    public ExchangeMessage getLastMessage() throws AligoExchangeException {
        Object out = this.getLast("IPM.Note");
        if (out instanceof ExchangeMessage) {
            return (ExchangeMessage)out;
        }
        return null;
    }

    public ExchangeMeetingItem getLastMeeting() throws AligoExchangeException {
        Object out = this.getLast("IPM.Schedule.Meeting.Request");
        if (out instanceof ExchangeMeetingItem) {
            return (ExchangeMeetingItem)out;
        }
        return null;
    }

    public ExchangeAppointmentItem getLastAppointment() throws AligoExchangeException {
        Object out = this.getLast("IPM.Appointment");
        if (out instanceof ExchangeAppointmentItem) {
            return (ExchangeAppointmentItem)out;
        }
        return null;
    }

    public ExchangeMessage getNextMessage() throws AligoExchangeException {
        Object out = this.getNext();
        if (out instanceof ExchangeMessage) {
            return (ExchangeMessage)out;
        }
        return null;
    }

    public ExchangeMeetingItem getNextMeeting() throws AligoExchangeException {
        Object out = this.getNext();
        if (out instanceof ExchangeMeetingItem) {
            return (ExchangeMeetingItem)out;
        }
        return null;
    }

    public ExchangeAppointmentItem getNextAppointment() throws AligoExchangeException {
        Object out = this.getNext();
        if (out instanceof ExchangeAppointmentItem) {
            return (ExchangeAppointmentItem)out;
        }
        return null;
    }

    public ExchangeMessage getPreviousMessage() throws AligoExchangeException {
        Object out = this.getPrevious();
        if (out instanceof ExchangeMessage) {
            return (ExchangeMessage)out;
        }
        return null;
    }

    public ExchangeMeetingItem getPreviousMeeting() throws AligoExchangeException {
        Object out = this.getPrevious();
        if (out instanceof ExchangeMeetingItem) {
            return (ExchangeMeetingItem)out;
        }
        return null;
    }

    public ExchangeAppointmentItem getPreviousAppointment() throws AligoExchangeException {
        Object out = this.getPrevious();
        if (out instanceof ExchangeAppointmentItem) {
            return (ExchangeAppointmentItem)out;
        }
        return null;
    }

    public Object getLast(String filterType) throws AligoExchangeException {
        try {
            Object obj = this._ocxMessages.getLast(filterType);
            if (obj != null) {
                MessageProxy msgHandle = new MessageProxy(obj);
                ExchangeMessage msg = new ExchangeMessage(msgHandle);
                if (msg.getType().equals("IPM.Schedule.Meeting.Request")) {
                    MeetingItemProxy meetingHandle = new MeetingItemProxy(obj);
                    return new ExchangeMeetingItem(meetingHandle);
                }
                if (msg.getType().equals("IPM.Appointment")) {
                    AppointmentItemProxy apptHandle = new AppointmentItemProxy(obj);
                    return new ExchangeAppointmentItem(apptHandle);
                }
                return msg;
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Object getNext() throws AligoExchangeException {
        try {
            Object obj = this._ocxMessages.getNext();
            if (obj != null) {
                MessageProxy msgHandle = new MessageProxy(obj);
                ExchangeMessage msg = new ExchangeMessage(msgHandle);
                if (msg.getType().equals("IPM.Schedule.Meeting.Request")) {
                    MeetingItemProxy meetingHandle = new MeetingItemProxy(obj);
                    return new ExchangeMeetingItem(meetingHandle);
                }
                if (msg.getType().equals("IPM.Appointment")) {
                    AppointmentItemProxy apptHandle = new AppointmentItemProxy(obj);
                    return new ExchangeAppointmentItem(apptHandle);
                }
                return msg;
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Object getPrevious() throws AligoExchangeException {
        try {
            Object obj = this._ocxMessages.getPrevious();
            if (obj != null) {
                MessageProxy msgHandle = new MessageProxy(obj);
                ExchangeMessage msg = new ExchangeMessage(msgHandle);
                if (msg.getType().equals("IPM.Schedule.Meeting.Request")) {
                    MeetingItemProxy meetingHandle = new MeetingItemProxy(obj);
                    return new ExchangeMeetingItem(meetingHandle);
                }
                if (msg.getType().equals("IPM.Appointment")) {
                    AppointmentItemProxy apptHandle = new AppointmentItemProxy(obj);
                    return new ExchangeAppointmentItem(apptHandle);
                }
                return msg;
            }
            return null;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void sort(int sortOrder) throws AligoExchangeException {
        switch (sortOrder) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid sort value provided!");
            }
        }
        try {
            this._ocxMessages.sort(new Integer(sortOrder), null);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void sort(int sortOrder, Object propTag) throws AligoExchangeException {
        switch (sortOrder) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AligoExchangeException("Invalid sort value provided!");
            }
        }
        try {
            this._ocxMessages.sort(new Integer(sortOrder), propTag);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessageFilter getFilter() throws AligoExchangeException {
        try {
            MessageFilterProxy resultHandle = new MessageFilterProxy(this._ocxMessages.getFilter());
            return new ExchangeMessageFilter(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setFilter(ExchangeMessageFilter filter) throws AligoExchangeException {
        try {
            this._ocxMessages.setFilter(filter.getMessageFilterHandle());
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getApplication() {
        return "Collaboration Data Objects";
    }

    public ExchangeFolder getParent() throws AligoExchangeException {
        try {
            return new ExchangeFolder(new FolderProxy(this._ocxMessages.getParent()));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }
}

