/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimRecipientType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimRecipientItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItem;
import com.aligo.pim.lotus.LotusPimRecipientItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimUtility;
import com.aligo.pim.lotus.recycle.Recycle;
import lotus.domino.Session;

public class LotusPimRecipientItem
extends LotusPimItem
implements PimRecipientItem {
    private String m_oEmailAddress;
    private PimRecipientType m_oPimRecipientType;
    private LotusPimRecipientItems m_oPimRecipientItems;

    public LotusPimRecipientItem(LotusPimRecipientItems lotusPimRecipientItems, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this.m_oPimRecipientItems = lotusPimRecipientItems;
    }

    public void update() throws LotusPimException {
        this.m_oPimRecipientItems.addRecipient(this);
    }

    public String getEmailAddress() throws LotusPimException {
        return this.m_oEmailAddress;
    }

    public PimRecipientType getRecipientType() throws LotusPimException {
        return this.m_oPimRecipientType;
    }

    public void setEmailAddress(String string) throws LotusPimException {
        this.m_oEmailAddress = string;
    }

    public void setRecipientType(PimRecipientType pimRecipientType) throws LotusPimException {
        this.m_oPimRecipientType = pimRecipientType;
    }

    public void resolve() throws LotusPimException {
        this.checkEmailAddress();
    }

    public void checkEmailAddress() throws LotusPimException {
    }

    public PimAddressEntryItem getAddressEntryItem() throws LotusPimException {
        try {
            Session session = this.m_oPimRecipientItems.getLotusSession();
            if (session != null && this.getEmailAddress() != null) {
                return LotusPimUtility.getAddressEntryItem(session, "InternetAddress", this.getEmailAddress(), this.getLotusPimSession(), this.getRecycle());
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws LotusPimException {
        try {
            if (pimAddressEntryItem != null) {
                this.m_oEmailAddress = pimAddressEntryItem.getEmailAddress();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        this.m_oPimRecipientItems.deleteRecipient(this);
    }

    public void delete(boolean bl) throws PimException {
        this.delete();
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        return null;
    }

    public String getID() throws LotusPimException {
        return null;
    }

    public String getName() throws LotusPimException {
        return this.getEmailAddress();
    }
}

