/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAttachmentItem;
import com.aligo.pim.interfaces.PimAttachmentItems;
import com.aligo.pim.lotus.LotusPimAttachmentItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Vector;
import lotus.domino.Document;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.cso.RichTextItem;

public abstract class LotusPimAttachmentItems
extends LotusPimItems
implements PimAttachmentItems {
    private Vector m_oEmbeddedObjects;
    private Document _oDocument;

    public LotusPimAttachmentItems(Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._oDocument = document;
    }

    public PimAttachmentItem addAttachmentItem() throws LotusPimException {
        try {
            lotus.domino.RichTextItem richTextItem = this.getNewLotusRichTextItem();
            if (richTextItem == null) {
                return null;
            }
            return new LotusPimAttachmentItem(richTextItem, this.getLotusPimSession(), this.getRecycle());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public lotus.domino.RichTextItem getNewLotusRichTextItem() throws LotusPimException {
        try {
            lotus.domino.RichTextItem richTextItem = this.getLotusDocument().createRichTextItem("Body");
            return richTextItem;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Document getLotusDocument() {
        return this._oDocument;
    }

    public Vector getLotusEmbeddedObjects() throws LotusPimException {
        try {
            if (this.m_oEmbeddedObjects == null) {
                this.m_oEmbeddedObjects = new Vector();
                try {
                    RichTextItem richTextItem = (RichTextItem)this.getLotusDocument().getFirstItem("Body");
                    if (richTextItem != null) {
                        this.m_oEmbeddedObjects = richTextItem.getEmbeddedObjects();
                        if (this.m_oEmbeddedObjects.size() == 0) {
                            Vector vector = this.getLotusDocument().getItems();
                            int n = 0;
                            while (n < vector.size()) {
                                EmbeddedObject embeddedObject;
                                Item item = (Item)vector.elementAt(n);
                                if (item.getName().equalsIgnoreCase("$File") && (embeddedObject = this.getLotusDocument().getAttachment(item.getValueString())) != null) {
                                    this.m_oEmbeddedObjects.add(embeddedObject);
                                }
                                ++n;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    this.m_oEmbeddedObjects = new Vector();
                    return this.m_oEmbeddedObjects;
                }
            }
            return this.m_oEmbeddedObjects;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getCount() throws LotusPimException {
        try {
            return this.getLotusEmbeddedObjects().size();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
    }

    public abstract PimAttachmentItem getPreviousAttachmentItem() throws PimException;

    public abstract PimAttachmentItem getLastAttachmentItem() throws PimException;

    public abstract PimAttachmentItem getNextAttachmentItem() throws PimException;

    public abstract PimAttachmentItem getFirstAttachmentItem() throws PimException;

    public abstract PimAttachmentItem getAttachmentItem(String var1) throws PimException;

    public abstract PimAttachmentItem getAttachmentItem(int var1) throws PimException;
}

