/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimImportanceType;
import com.aligo.pim.interfaces.PimAppointmentItemFilter;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.lotus.LotusPimAppointmentItems;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimFilter;
import com.aligo.pim.lotus.LotusPimFilterFieldItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import java.util.Vector;
import lotus.domino.DateRange;
import lotus.domino.DateTime;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.domino.ViewEntryCollection;

public class LotusPimAppointmentItemFilter
extends LotusPimFilter
implements PimAppointmentItemFilter {
    private ViewEntryCollection _oViewEntryCollection;
    private LotusPimAppointmentItems m_oPimAppointmentItems;
    private DateRange _oDateRange;
    private Vector m_oKeysVector;

    public LotusPimAppointmentItemFilter(LotusPimAppointmentItems lotusPimAppointmentItems, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(lotusPimSession, recycle);
        try {
            this.m_oPimAppointmentItems = lotusPimAppointmentItems;
            View view = lotusPimAppointmentItems.getLotusView();
            Session session = view.getParent().getParent();
            this._oViewEntryCollection = view.getAllEntries();
            recycle.add(this._oViewEntryCollection);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private LotusPimAppointmentItems getPimAppointmentItems() {
        return this.m_oPimAppointmentItems;
    }

    public DateTime getStartDateTime() throws LotusPimException {
        try {
            return this.getDateRange().getStartDateTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public DateTime getEndDateTime() throws LotusPimException {
        try {
            return this.getDateRange().getEndDateTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void reset() throws LotusPimException {
        try {
            View view = this.m_oPimAppointmentItems.getLotusView();
            this._oViewEntryCollection = view.getAllEntries();
            this.getRecycle().add(this._oViewEntryCollection);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private DateRange getDateRange() throws LotusPimException {
        try {
            if (this._oDateRange == null) {
                this.getKeysVector();
            }
            return this._oDateRange;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private Vector getKeysVector() throws LotusPimException {
        try {
            if (this.m_oKeysVector == null) {
                Session session = this.getLotusView().getParent().getParent();
                this._oDateRange = session.createDateRange(session.createDateTime(new Date()), session.createDateTime(new Date()));
                this.m_oKeysVector = new Vector();
                this.m_oKeysVector.add(0, this._oDateRange);
            }
            return this.m_oKeysVector;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public ViewEntryCollection getLotusViewEntryCollection() {
        return this._oViewEntryCollection;
    }

    public View getLotusView() throws LotusPimException {
        try {
            return this.getLotusViewEntryCollection().getParent();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        return new LotusPimFilterFieldItems(this.getLotusViewEntryCollection(), this.getLotusPimSession(), this.getRecycle());
    }

    public void setStartTime(Date date) throws LotusPimException {
        try {
            this.getDateRange().setStartDateTime(this.getLotusView().getParent().getParent().createDateTime(date));
            this._oViewEntryCollection = this.getLotusView().getAllEntriesByKey(this.getKeysVector(), false);
            this.getRecycle().add(this._oViewEntryCollection);
            this.getPimAppointmentItems().clearHash();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setEndTime(Date date) throws LotusPimException {
        try {
            this.getDateRange().setEndDateTime(this.getLotusView().getParent().getParent().createDateTime(date));
            this._oViewEntryCollection = this.getLotusView().getAllEntriesByKey(this.getKeysVector(), false);
            this.getRecycle().add(this._oViewEntryCollection);
            this.getPimAppointmentItems().clearHash();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
        try {
            if (this.getLotusViewEntryCollection().getCount() == 0) {
                return;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.getFilterCriteria().add("FIELD subject CONTAINS " + string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setText(String string) throws LotusPimException {
        try {
            this.getFilterCriteria().add("FIELD Body CONTAINS " + string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

