/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.URLName;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class CalendarStore {
    private CalendarSession session;
    private URLName serviceUrl;
    private Hashtable calendarCache;

    protected CalendarStore(CalendarSession calendarSession) {
        this.session = calendarSession;
        this.calendarCache = new Hashtable();
    }

    public final void connect(String string) throws CalendarStoreException {
        this.connect(string, -1);
    }

    public void connect(String string, int n) throws CalendarStoreException {
        String string2 = this.session.getProperty("cal.protocol", "http");
        String string3 = this.session.getProperty("cal.user", "");
        String string4 = this.session.getProperty("cal.password", "");
        if (n <= 0) {
            n = -1;
        }
        this.serviceUrl = new URLName(string2, string, n, "", string3, string4);
        this.connect(this.serviceUrl);
    }

    public final void connect(URLName uRLName) throws CalendarStoreException {
        this.serviceUrl = uRLName;
        this.connectURL(uRLName);
    }

    protected abstract void connectURL(URLName var1) throws CalendarStoreException;

    public abstract void disconnect() throws CalendarStoreException;

    public abstract boolean isConnected();

    public void update() {
        Enumeration enumeration = this.calendarCache.elements();
        ICalendar iCalendar = null;
        while (enumeration.hasMoreElements()) {
            iCalendar = (ICalendar)enumeration.nextElement();
            iCalendar.update();
        }
    }

    public CalendarSession getSession() {
        return this.session;
    }

    public URLName getServiceUrl() {
        return this.serviceUrl;
    }

    public ICalendar openCalendar() throws CalendarStoreException {
        String string = null;
        string = this.getDefaultCalendarId();
        return this.openCalendar(string);
    }

    public ICalendar openCalendar(String string) throws CalendarStoreException {
        if (!this.isConnected()) {
            throw new CalendarStoreException("Not Connected");
        }
        ICalendar iCalendar = (ICalendar)this.calendarCache.get(string);
        if (iCalendar == null && (iCalendar = this.loadCalendar(string)) != null) {
            this.calendarCache.put(string, iCalendar);
        }
        return iCalendar;
    }

    public abstract ICalendar[] getCalendars() throws CalendarStoreException, OperationNotSupportedException;

    public abstract String[] getSubscribedCalenders() throws CalendarStoreException, OperationNotSupportedException;

    public abstract String verifyCalendarId(String var1) throws CalendarStoreException, OperationNotSupportedException;

    protected abstract String getDefaultCalendarId() throws CalendarStoreException;

    protected abstract ICalendar loadCalendar(String var1) throws CalendarStoreException;

    public abstract ICalendar[] searchCalendars(String var1) throws CalendarStoreException, OperationNotSupportedException;

    public abstract ICalendar[] searchCalendars(String var1, int var2, int var3) throws CalendarStoreException, OperationNotSupportedException;

    protected abstract void unloadCalendar(ICalendar var1) throws CalendarStoreException;

    public void closeCalendar(String string) throws CalendarStoreException {
        ICalendar iCalendar = null;
        if (string != null) {
            iCalendar = (ICalendar)this.calendarCache.get(string);
        }
        this.closeCalendar(iCalendar);
    }

    public void closeCalendar(ICalendar iCalendar) throws CalendarStoreException {
        if (iCalendar != null) {
            this.unloadCalendar(iCalendar);
        }
        this.calendarCache.remove(iCalendar.getCalID());
    }

    public abstract ICalendar createCalendar(String var1) throws CalendarStoreException, OperationNotSupportedException;

    public abstract ICalendar createCalendar(String var1, Properties var2) throws CalendarStoreException, OperationNotSupportedException;

    public abstract void deleteCalendar(String var1) throws CalendarStoreException, OperationNotSupportedException;

    public abstract BufferedReader exportCalendar(String var1, DateTime var2, DateTime var3, String var4) throws CalendarStoreException, OperationNotSupportedException;

    public abstract BufferedReader exportCalendar(String var1, DateTime var2, DateTime var3, String var4, String var5, int var6) throws CalendarStoreException, OperationNotSupportedException;

    public abstract void importCalendar(String var1, String var2, InputStream var3) throws CalendarStoreException, OperationNotSupportedException;

    public abstract void importCalendar(String var1, DateTime var2, DateTime var3, String var4, InputStream var5) throws CalendarStoreException, OperationNotSupportedException;
}

