/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.util;

import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.util.PropertyUtil;
import com.sun.portal.providers.util.ProviderProperties;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class ProviderCommands
implements ProviderProperties {
    private static final int DEFAULT_COMMAND_SIZE = 512;
    private static final int DEFAULT_URL_SIZE = 128;
    private static final String DESKTOP_IMAGES = "/desktop/images/";

    private ProviderCommands() {
    }

    public static Hashtable getProviderCommands(Provider provider, String container, ProviderContext pc, HttpServletRequest req, ResourceBundle bundle, String desktopURL, String sContext, Map channelsIsDetachable, Map channelsIsDetached, Map channelsIsMinimizable, Map channelsIsMaximizable, String maximizedChannel, Map channelsIsMinimized, Map channelsIsRemovable, boolean dIsDetachable, boolean dIsDetached, boolean dIsMinimizable, boolean dIsMaximizable, boolean dIsMinimized, boolean dIsRemovable, String normalizeImage, String maximizeImage, String minimizeImage, String helpImage, String editImage, String removeImage, String attachImage, String detachImage) throws ProviderException {
        DesktopContext dc = DesktopContextThreadLocalizer.get();
        int i = PerfThreadLocalizer.mark();
        String providerName = provider.getName();
        boolean isDetached = PropertyUtil.getBooleanValueFromMap(channelsIsDetached, providerName, dIsDetached);
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("providerName", provider.getTitle());
        String providerNameUE = URLEncoder.encode(providerName);
        String containerUE = URLEncoder.encode(container);
        try {
            ProviderCommands.genMinimize(provider, container, containerUE, pc, sContext, bundle, desktopURL, isDetached, providerName, providerNameUE, channelsIsMinimizable, channelsIsMinimized, dIsMinimizable, dIsMinimized, normalizeImage, minimizeImage, tagTable);
        }
        catch (ProviderException pe) {
            pc.debugError("ProviderCommands.getProviderCommands(): genMinimize failed " + pe);
        }
        try {
            ProviderCommands.genMaximize(provider, container, containerUE, pc, sContext, bundle, desktopURL, isDetached, providerName, providerNameUE, channelsIsMaximizable, maximizedChannel, dIsMaximizable, normalizeImage, maximizeImage, tagTable);
        }
        catch (ProviderException pe) {
            pc.debugError("ProviderCommands.getProviderCommands(): genMaximize failed " + pe);
        }
        try {
            ProviderCommands.genHelp(req, provider, container, containerUE, pc, sContext, bundle, desktopURL, providerName, providerNameUE, helpImage, tagTable);
        }
        catch (ProviderException pe) {
            pc.debugError("ProviderCommands.getProviderCommands(): genHelp failed" + pe);
        }
        try {
            ProviderCommands.genEdit(provider, container, containerUE, pc, sContext, bundle, desktopURL, isDetached, providerName, providerNameUE, editImage, tagTable);
        }
        catch (ProviderException pe) {
            pc.debugError("ProviderCommands.getProviderCommands(): genEdit failed" + pe);
        }
        try {
            ProviderCommands.genDetach(provider, container, containerUE, pc, sContext, bundle, desktopURL, isDetached, providerName, providerNameUE, channelsIsDetachable, dIsDetachable, maximizedChannel, attachImage, detachImage, tagTable);
        }
        catch (ProviderException pe) {
            pc.debugError("ProviderCommands.getProviderCommands(): genDetach failed" + pe);
        }
        try {
            ProviderCommands.genRemove(provider, container, containerUE, pc, sContext, bundle, desktopURL, isDetached, providerName, providerNameUE, channelsIsRemovable, dIsRemovable, removeImage, tagTable);
        }
        catch (ProviderException pe) {
            pc.debugError("ProviderCommands.getProviderCommands(): genRemove failed" + pe);
        }
        long end = System.currentTimeMillis();
        PerfThreadLocalizer.add(i, "ProviderCommands.ProviderCommands()");
        return tagTable;
    }

    private static void genMinimize(Provider provider, String frontContainerName, String frontContainerNameUE, ProviderContext providerContext, String sContext, ResourceBundle bundle, String desktopURL, boolean isDetached, String providerName, String providerNameUE, Map channelsIsMinimizable, Map channelsIsMinimized, boolean dIsMinimizable, boolean dIsMinimized, String normalizeImage, String minimizeImage, Hashtable tagTable) throws ProviderException {
        boolean minimized = PropertyUtil.getBooleanValueFromMap(channelsIsMinimized, providerName, dIsMinimized);
        boolean minimizable = PropertyUtil.getBooleanValueFromMap(channelsIsMinimizable, providerName, dIsMinimizable);
        StringBuffer minMaximizeCommand = new StringBuffer(512);
        if (minimizable && !isDetached) {
            try {
                StringBuffer minMaximizeURL = new StringBuffer(128);
                if (minimized) {
                    String maximizeTag = bundle.getString("maximize");
                    String maximizeIcon = sContext + bundle.getString("maximizeIcon");
                    tagTable.put("minMaximizeIcon", maximizeIcon);
                    tagTable.put("minMaximizeText", maximizeTag);
                    minMaximizeURL.append(desktopURL).append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=maximize&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("minMaximizeURL", minMaximizeURL);
                    if (normalizeImage != null) {
                        tagTable.put("s_normalizeImage", sContext + DESKTOP_IMAGES + normalizeImage);
                    }
                    minMaximizeCommand = providerContext.getTemplate(frontContainerName, "normalizeCommand.template", tagTable);
                } else {
                    String minimizeTag = bundle.getString("minimize");
                    String minimizeIcon = sContext + bundle.getString("minimizeIcon");
                    tagTable.put("minMaximizeIcon", minimizeIcon);
                    tagTable.put("minMaximizeText", minimizeTag);
                    if (minimizeImage != null) {
                        tagTable.put("s_minimizeImage", sContext + DESKTOP_IMAGES + minimizeImage);
                    }
                    minMaximizeURL.append(desktopURL).append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=minimize&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("minMaximizeURL", minMaximizeURL);
                    minMaximizeCommand = providerContext.getTemplate(frontContainerName, "minimizeCommand.template", tagTable);
                }
                minMaximizeCommand.setLength(minMaximizeCommand.length() - 1);
                tagTable.put("minMaximizeCommand", minMaximizeCommand.toString());
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("ProviderCommands.genMinimized(): ", pce);
            }
        } else {
            tagTable.put("minMaximizeCommand", "");
        }
    }

    private static void genMaximize(Provider provider, String frontContainerName, String frontContainerNameUE, ProviderContext providerContext, String sContext, ResourceBundle bundle, String desktopURL, boolean isDetached, String providerName, String providerNameUE, Map channelsIsMaximizable, String maximizedChannel, boolean dIsMaximizable, String normalizeImage, String maximizeImage, Hashtable tagTable) throws ProviderException {
        boolean maximized = providerName.equalsIgnoreCase(maximizedChannel);
        boolean maximizable = PropertyUtil.getBooleanValueFromMap(channelsIsMaximizable, providerName, dIsMaximizable);
        StringBuffer maximizeCommand = new StringBuffer(512);
        if (maximizable && !isDetached) {
            StringBuffer maximizeURL = new StringBuffer(128);
            try {
                if (!maximized) {
                    String maximizeTag = bundle.getString("truemaximize");
                    tagTable.put("maximizeText", maximizeTag);
                    maximizeURL.append(desktopURL).append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=truemaximize&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("maximizeURL", maximizeURL);
                    if (maximizeImage != null) {
                        tagTable.put("s_maximizeImage", sContext + DESKTOP_IMAGES + maximizeImage);
                    }
                    maximizeCommand = providerContext.getTemplate(frontContainerName, "MaximizeCommand.template", tagTable);
                } else {
                    String maximizeTag = bundle.getString("maximize");
                    tagTable.put("minMaximizeText", maximizeTag);
                    maximizeURL.append(desktopURL).append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=maximize&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("minMaximizeURL", maximizeURL);
                    if (normalizeImage != null) {
                        tagTable.put("s_normalizeImage", sContext + DESKTOP_IMAGES + normalizeImage);
                    }
                    maximizeCommand = providerContext.getTemplate(frontContainerName, "normalizeCommand.template", tagTable);
                }
                maximizeCommand.setLength(maximizeCommand.length() - 1);
                tagTable.put("maximizeCommand", maximizeCommand.toString());
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("ProviderCommands.genMinimized(): ", pce);
            }
        } else {
            tagTable.put("maximizeCommand", "");
        }
    }

    private static void genHelp(HttpServletRequest req, Provider provider, String frontContainerName, String frontContainerNameUE, ProviderContext providerContext, String sContext, ResourceBundle bundle, String desktopURL, String providerName, String providerNameUE, String helpImage, Hashtable tagTable) throws ProviderException {
        StringBuffer helpLink = new StringBuffer(512);
        URL helpURL = null;
        try {
            helpURL = provider.getHelp(req);
        }
        catch (Throwable e) {
            providerContext.debugError("ProviderCommands.genHelp(): can not get helpURL for: " + providerName, e);
        }
        if (helpURL == null) {
            tagTable.put("helpCommand", "");
        } else {
            String helpTag = bundle.getString("help");
            String helpIcon = sContext + bundle.getString("helpIcon");
            StringBuffer url = new StringBuffer(helpURL.toString());
            int queryStrIndex = url.toString().indexOf("?");
            if (queryStrIndex != -1) {
                url.insert(queryStrIndex + 1, "containerName=" + frontContainerNameUE + "&");
            }
            tagTable.put("help_link", url.toString());
            tagTable.put("help_tag", helpTag);
            tagTable.put("help_icon", helpIcon);
            if (helpImage != null) {
                tagTable.put("s_helpImage", sContext + DESKTOP_IMAGES + helpImage);
            }
            try {
                helpLink = providerContext.getTemplate(frontContainerName, "helpHref.template", tagTable);
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("ProviderCommands.genHelp(): ", pce);
            }
            helpLink.setLength(helpLink.length() - 1);
            tagTable.put("helpCommand", helpLink.toString());
        }
    }

    private static void genEdit(Provider provider, String frontContainerName, String frontContainerNameUE, ProviderContext providerContext, String sContext, ResourceBundle bundle, String desktopURL, boolean isDetached, String providerName, String providerNameUE, String editImage, Hashtable tagTable) throws ProviderException {
        StringBuffer editCommand = new StringBuffer(512);
        if (provider.isEditable()) {
            String editTag = bundle.getString("edit");
            String editIcon = sContext + bundle.getString("editIcon");
            tagTable.put("editTag", editTag);
            tagTable.put("editIcon", editIcon);
            if (editImage != null) {
                tagTable.put("s_editImage", sContext + DESKTOP_IMAGES + editImage);
            }
            StringBuffer editURL = new StringBuffer(128);
            try {
                String editContainerUE = URLEncoder.encode(providerContext.getStringProperty(frontContainerName, "editContainerName"));
                if (!isDetached) {
                    editURL.append(desktopURL).append("?action=edit&").append("provider=").append(editContainerUE).append("&targetprovider=").append(providerNameUE).append("&").append("containerName=").append(frontContainerNameUE);
                    tagTable.put("editURL", editURL);
                    editCommand = providerContext.getTemplate(frontContainerName, "editCommand.template", tagTable);
                } else {
                    editURL.append("dt").append("?action=edit&").append("provider=").append(editContainerUE).append("&targetprovider=").append(providerNameUE).append("&").append("containerName=").append(frontContainerNameUE);
                    tagTable.put("editURL", editURL);
                    editCommand = providerContext.getTemplate(frontContainerName, "detachEditCommand.template", tagTable);
                }
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("ProviderCommands.genEdit(): ", pce);
            }
            editCommand.setLength(editCommand.length() - 1);
            tagTable.put("editCommand", editCommand.toString());
        } else {
            tagTable.put("editCommand", "");
        }
    }

    private static void genDetach(Provider provider, String frontContainerName, String frontContainerNameUE, ProviderContext providerContext, String sContext, ResourceBundle bundle, String desktopURL, boolean isDetached, String providerName, String providerNameUE, Map channelsIsDetachable, boolean dIsDetachable, String maximizedChannel, String attachImage, String detachImage, Hashtable tagTable) throws ProviderException {
        boolean maximized = providerName.equalsIgnoreCase(maximizedChannel);
        boolean isDetachable = PropertyUtil.getBooleanValueFromMap(channelsIsDetachable, providerName, dIsDetachable);
        StringBuffer detachAttachCommand = new StringBuffer(512);
        if (isDetachable && !maximized) {
            StringBuffer detachURL = new StringBuffer(128);
            String icon = null;
            Object action = null;
            String alt = null;
            try {
                if (!isDetached) {
                    icon = sContext + bundle.getString("detachIcon");
                    alt = bundle.getString("detach");
                    detachURL.append(desktopURL).append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=detach&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("detachAttachIcon", icon);
                    tagTable.put("detachAttachText", alt);
                    tagTable.put("detachAttachURL", detachURL);
                    if (detachImage != null) {
                        tagTable.put("s_detachImage", sContext + DESKTOP_IMAGES + detachImage);
                    }
                    detachAttachCommand = providerContext.getTemplate(frontContainerName, "detachCommand.template", tagTable);
                } else {
                    icon = sContext + bundle.getString("attachIcon");
                    alt = bundle.getString("attach");
                    detachURL.append("dt").append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=attach&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("detachAttachIcon", icon);
                    tagTable.put("detachAttachText", alt);
                    tagTable.put("detachAttachURL", detachURL);
                    if (attachImage != null) {
                        tagTable.put("s_attachImage", sContext + DESKTOP_IMAGES + attachImage);
                    }
                    detachAttachCommand = providerContext.getTemplate(frontContainerName, "AtachCommand.template", tagTable);
                }
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("ProviderCommands.genDetach(): ", pce);
            }
            detachAttachCommand.setLength(detachAttachCommand.length() - 1);
            tagTable.put("detachAtachCommand", detachAttachCommand.toString());
        } else {
            tagTable.put("detachAtachCommand", "");
        }
    }

    private static void genRemove(Provider provider, String frontContainerName, String frontContainerNameUE, ProviderContext providerContext, String sContext, ResourceBundle bundle, String desktopURL, boolean isDetached, String providerName, String providerNameUE, Map channelsIsRemovable, boolean dIsRemovable, String removeImage, Hashtable tagTable) throws ProviderException {
        boolean isRemovable = PropertyUtil.getBooleanValueFromMap(channelsIsRemovable, providerName, dIsRemovable);
        StringBuffer removeCommand = new StringBuffer(512);
        if (isRemovable) {
            String removeTag = bundle.getString("remove");
            String removeIcon = sContext + bundle.getString("removeIcon");
            StringBuffer removeURL = new StringBuffer(128);
            tagTable.put("removeTag", removeTag);
            tagTable.put("removeIcon", removeIcon);
            if (removeImage != null) {
                tagTable.put("s_removeImage", sContext + DESKTOP_IMAGES + removeImage);
            }
            try {
                if (!isDetached) {
                    removeURL.append(desktopURL).append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=remove&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("removeURL", removeURL);
                    removeCommand = providerContext.getTemplate(frontContainerName, "removeCommand.template", tagTable);
                } else {
                    removeURL.append("dt").append("?action=process&provider=").append(frontContainerNameUE).append("&").append(frontContainerNameUE).append(".channelAction=remove&").append(frontContainerNameUE).append(".targetProvider=").append(providerNameUE);
                    tagTable.put("removeURL", removeURL);
                    removeCommand = providerContext.getTemplate(frontContainerName, "detachRemoveCommand.template", tagTable);
                }
                removeCommand.setLength(removeCommand.length() - 1);
                tagTable.put("removeCommand", removeCommand.toString());
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("ProviderCommands.genRemove(): ", pce);
            }
        } else {
            tagTable.put("removeCommand", "");
        }
    }
}

