/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.CmdOpts;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;

public class CmdContainers {
    public static void doContainers(DPRootSpecifier dpr, boolean debug, PrintStream out) throws ParFileException {
        if (debug) {
            try {
                FileOutputStream oxf = new FileOutputStream("dn.xml");
                StringBuffer sb = new StringBuffer(256);
                dpr.getRoot().toXML(sb, 0);
                oxf.write(sb.toString().getBytes());
                oxf.flush();
                out.println(Par.getLocalizedString("msgDPDebugDoc"));
            }
            catch (Exception ex) {
                Object[] tok = new Object[]{ex};
                out.println(Par.getLocalizedString("msgDPDebugDocFail", tok));
            }
        }
        CmdContainers.doContainers(0, dpr.getRoot(), out);
    }

    private static void doContainers(int indent, DPNode node, PrintStream out) throws ParFileException {
        String nm = null;
        try {
            Set set = node.getChannelNames();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String pnm;
                nm = (String)it.next();
                DPChannel ch = node.getChannel(nm);
                StringBuffer buf = CmdContainers.indentedBuffer(indent);
                buf.append(nm);
                buf.append(" (");
                if (ch.getProvider() != null) {
                    buf.append(ch.getProvider().getClassName());
                    buf.append(" ");
                }
                buf.append((pnm = ch.getProviderName()) == null ? "?" : pnm);
                buf.append(")");
                out.println(buf.toString());
                if (!(ch instanceof DPContainerChannel)) continue;
                CmdContainers.doContainers(indent + 1, ch, out);
                DPContainerChannel cch = (DPContainerChannel)ch;
                CmdContainers.doList("Available", cch.getAvailable().getNames(), indent + 1, out);
                CmdContainers.doList("Selected", cch.getSelected().getNames(), indent + 1, out);
            }
        }
        catch (Exception ex) {
            throw new ParFileException("Exception describing channel - " + nm, ex);
        }
    }

    private static void doList(String pfx, Set set, int indent, PrintStream out) {
        StringBuffer buf = CmdContainers.indentedBuffer(indent);
        buf.append(pfx);
        buf.append(":");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            buf.append(" ");
            buf.append(it.next().toString());
        }
        out.println(buf.toString());
    }

    private static StringBuffer indentedBuffer(int indent) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < indent) {
            buf.append("  ");
            ++i;
        }
        return buf;
    }

    public static void main(String[] args) {
        CmdOpts opts = CmdOpts.parseOpts(args, 1, 0, Par.getLocalizedString("usageContainers"), "rpd");
        if (opts != null) {
            try {
                CmdContainers.doContainers(opts.dproot(), opts.debug(), System.out);
            }
            catch (Exception ex) {
                opts.produceErrorMessage(ex);
            }
        }
        System.exit(0);
    }
}

