/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ClassInfoCache;
import com.sun.portal.desktop.context.ProviderClassLoaderListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ProviderClassLoader
extends ClassLoader {
    private static ClassInfoCache cic = null;
    private static String baseSearchDir = null;
    private static ProviderClassLoader instance;
    private ClassLoader parent = (class$com$sun$portal$desktop$context$ProviderClassLoader == null ? (class$com$sun$portal$desktop$context$ProviderClassLoader = ProviderClassLoader.class$("com.sun.portal.desktop.context.ProviderClassLoader")) : class$com$sun$portal$desktop$context$ProviderClassLoader).getClassLoader();
    private Collection failedToLoadClassSet;
    private List listeners;
    static /* synthetic */ Class class$com$sun$portal$desktop$context$ProviderClassLoader;

    public static synchronized ProviderClassLoader getInstance(String providerBaseDir) {
        if (instance == null) {
            instance = new ProviderClassLoader(providerBaseDir);
        }
        return instance;
    }

    public static synchronized ProviderClassLoader getInstance(String providerClassName, String providerBaseDir) {
        if (instance == null || instance.isProviderClassOutOfDate(providerClassName)) {
            instance = new ProviderClassLoader(providerBaseDir);
        }
        return instance;
    }

    private ProviderClassLoader(String providerBaseDir) {
        super((class$com$sun$portal$desktop$context$ProviderClassLoader == null ? (class$com$sun$portal$desktop$context$ProviderClassLoader = ProviderClassLoader.class$("com.sun.portal.desktop.context.ProviderClassLoader")) : class$com$sun$portal$desktop$context$ProviderClassLoader).getClassLoader());
        cic = ClassInfoCache.getInstance(providerBaseDir);
        if (cic != null) {
            baseSearchDir = providerBaseDir;
        }
        this.failedToLoadClassSet = new HashSet();
        this.listeners = new ArrayList();
    }

    public synchronized void addListener(ProviderClassLoaderListener pcll) {
        this.listeners.add(pcll);
    }

    public synchronized void notifyListeners() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ProviderClassLoaderListener)this.listeners.get(i)).providerClassLoaderOutdated();
            ++i;
        }
        this.listeners.clear();
    }

    public boolean isProviderClassOutOfDate(String theClassName) {
        boolean outdated = false;
        File fileHandle = cic.getHandle(theClassName);
        if (fileHandle != null) {
            long lastModTime = cic.getModifiedTime(theClassName);
            if (fileHandle != null && fileHandle.exists()) {
                if (fileHandle.lastModified() > lastModTime) {
                    outdated = true;
                    cic.removeClassInfo(theClassName);
                }
            } else {
                outdated = true;
                cic.removeClassInfo(theClassName);
            }
        } else if (this.failedToLoadClassSet.contains(theClassName)) {
            outdated = true;
        }
        if (outdated) {
            this.notifyListeners();
        }
        return outdated;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class<?> rclass = null;
        byte[] classBytes = null;
        try {
            classBytes = this.findLocalClass(className);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("ProviderClassLoader.findClass() : not found class Name = " + className, ioe);
        }
        if (classBytes != null) {
            rclass = this.defineClass(className, classBytes, 0, classBytes.length);
            if (rclass == null) {
                this.failedToLoadClassSet.add(className);
                throw new ClassNotFoundException("ProviderClassLoader.findClass() : not found class Name = " + className);
            }
        } else {
            this.failedToLoadClassSet.add(className);
            throw new ClassNotFoundException("ProviderClassLoader.findClass() : not found class Name = " + className);
        }
        return rclass;
    }

    public byte[] findLocalClass(String className) throws IOException {
        byte[] result = null;
        String cString = className.replace('.', File.separatorChar) + ".class";
        String fullFileLocation = baseSearchDir + File.separatorChar + cString;
        File classFile = new File(fullFileLocation);
        if (!classFile.exists()) {
            File jarFile = cic.getJarFileHandle(className);
            if (jarFile != null && jarFile.isFile()) {
                ZipFile zip = new ZipFile(jarFile);
                ZipEntry entryInJar = zip.getEntry(cString);
                InputStream istream = zip.getInputStream(entryInJar);
                result = this.getClassData(istream);
                cic.setClassInfo(className, true, jarFile);
                istream.close();
                zip.close();
            }
        } else {
            FileInputStream fi = new FileInputStream(classFile);
            result = this.getClassData(fi);
            cic.setClassInfo(className, false, classFile);
            fi.close();
        }
        return result;
    }

    private byte[] getClassData(InputStream cistream) throws IOException {
        if (cistream == null) {
            return null;
        }
        byte[] byteBuf = new byte[1024];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int len = 0;
        while ((len = cistream.read(byteBuf)) != -1) {
            byteOut.write(byteBuf, 0, len);
        }
        return byteOut.toByteArray();
    }

    public URL getResource(String name) {
        URL resURL = null;
        File fHandle = new File(baseSearchDir + File.separatorChar + name);
        if (fHandle.canRead()) {
            try {
                resURL = fHandle.toURL();
            }
            catch (MalformedURLException mfu) {}
        } else {
            resURL = super.getResource(name);
        }
        return resURL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

