/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.identity.authentication.AuthContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.util.ApplicationLoginHostChooser;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SystemProperties;
import java.net.URL;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class ApplicationLogin {
    static String login(String string) {
        block17: {
            String string2;
            AuthContext authContext = null;
            try {
                string2 = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.defaultOrg");
                URL uRL = ApplicationLoginHostChooser.getInstance().getAlivePlatFormServerURL();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("platformUrl : " + uRL);
                    GWDebug.debug.message("ApplicationLogin.login : defOrg : " + string2);
                }
                if (uRL == null) {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Using AuthContext(org) constructor.");
                    }
                    authContext = new AuthContext(string2);
                } else {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Using AuthContext(org , url) constructor.");
                    }
                    authContext = new AuthContext(string2, uRL);
                }
                AuthContext.IndexType indexType = AuthContext.IndexType.SERVICE;
                authContext.login(indexType, "srapGatewayAccessService".toLowerCase());
                Callback[] callbackArray = null;
                while (authContext.hasMoreRequirements()) {
                    callbackArray = authContext.getRequirements();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ApplicationLogin.login : callback : " + callbackArray);
                    }
                    if (callbackArray == null) continue;
                    ApplicationLogin.processCallBack(callbackArray);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ApplicationLogin.login : process over , submitting ...");
                    }
                    authContext.submitRequirements(callbackArray);
                    if (!GWDebug.debug.messageEnabled()) continue;
                    GWDebug.debug.message("ApplicationLogin.login : submitted. authContext.hasMoreRequirements() : " + authContext.hasMoreRequirements());
                }
            }
            catch (LoginException loginException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("LoginException while creating Application session", loginException);
                }
                return null;
            }
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ApplicationLogin.login : authContext : " + authContext);
            }
            try {
                if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
                    string2 = authContext.getSSOToken().getTokenID().toString();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ApplicationLogin.login : appSess : " + string2);
                    }
                    return string2;
                }
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.message("ApplicationLogin.login : getStatus() returned  : " + authContext.getStatus());
                }
            }
            catch (Exception exception) {
                if (!GWDebug.debug.errorEnabled()) break block17;
                GWDebug.debug.error("Exception while obtaining App session from authContext", exception);
            }
        }
        return null;
    }

    private static void processCallBack(Callback[] callbackArray) {
        int n = 0;
        while (n < callbackArray.length) {
            String string;
            Callback callback;
            if (callbackArray[n] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[n];
                string = SystemProperties.get("gateway.logging.user.id", "amService-srapGateway");
                ((NameCallback)callback).setName(string);
            } else if (callbackArray[n] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[n];
                string = SystemProperties.get("gateway.logging.password", "TEST");
                try {
                    string = JSSUtil.decryptPassword((String)string).getPassword();
                }
                catch (SRADecoderException sRADecoderException) {
                    // empty catch block
                }
                char[] cArray = new char[string.length()];
                string.getChars(0, cArray.length, cArray, 0);
                ((PasswordCallback)callback).setPassword(cArray);
            }
            ++n;
        }
    }
}

